/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import java.util.Objects;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Throws;

public abstract class Result<T> {
    public static final int OK = 0;
    public static final int ABSENT = -1;
    private static final Absent DEFAULT_ABSENT = new Absent(-1, null);

    public static <T> Result<T> of(T reference) {
        return new Present(Objects.requireNonNull(reference));
    }

    public static <T> Result<T> fromNullable(T nullableReference) {
        return nullableReference == null ? Result.absent() : new Present(nullableReference);
    }

    public static <T> Result<T> absent() {
        return DEFAULT_ABSENT;
    }

    public static <T> Result<T> absent(int code) {
        return new Absent(code, null);
    }

    public static <T> Result<T> absent(Throwable exception) {
        return new Absent(-1, exception);
    }

    public static <T> Result<T> absent(int code, Throwable exception) {
        return new Absent(code, exception);
    }

    public abstract boolean isPresent();

    public abstract boolean hasReason();

    public abstract int getReason();

    public abstract T get();

    public abstract T or(T var1);

    public abstract Result<Throwable> getException();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    private static final class Absent
    extends Result<Object> {
        private final int reason;
        private final Throwable exception;

        private Absent(int reason, Throwable exception) {
            Checks.ensureIsTrue(reason != 0);
            this.reason = reason;
            this.exception = exception;
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public boolean hasReason() {
            return this.reason != -1;
        }

        @Override
        public Object or(Object defaultValue) {
            return defaultValue;
        }

        @Override
        public Object get() {
            throw Throws.throwIllegalStateException("cannot get() value from Absent");
        }

        @Override
        public int getReason() {
            return this.reason;
        }

        @Override
        public Result<Throwable> getException() {
            return Result.fromNullable(this.exception);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            Absent that = (Absent)other;
            return this.reason == that.reason && Objects.equals(this.exception, that.exception);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.reason, this.exception);
        }

        public String toString() {
            return "Result.absent(" + this.reason + ", " + this.exception + ")";
        }
    }

    private static final class Present<T>
    extends Result<T> {
        private final T reference;

        private Present(T reference) {
            this.reference = reference;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public boolean hasReason() {
            return false;
        }

        @Override
        public T or(T defaultValue) {
            return this.reference;
        }

        @Override
        public T get() {
            return this.reference;
        }

        @Override
        public int getReason() {
            return 0;
        }

        @Override
        public Result<Throwable> getException() {
            return Result.absent();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            Present that = (Present)other;
            return Objects.equals(this.reference, that.reference);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.reference);
        }

        public String toString() {
            return "Result.of(" + this.reference + ")";
        }
    }
}

