/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.launch;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.ui.filters.ClosedProjectFilter;
import org.eclipse.dltk.internal.ui.filters.DotFileFilter;
import org.eclipse.dltk.internal.ui.filters.LibraryFilter;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.ui.filters.RSEProjectFilter;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.ui.launch.OpenFileDialog;
import org.eclipse.php.phpunit.ui.launch.PHPUnitLaunchUtils;
import org.eclipse.php.phpunit.ui.launch.PHPUnitTestElementFinder;
import org.eclipse.php.phpunit.ui.launch.TestSelectionDialog;
import org.eclipse.php.phpunit.ui.preference.PHPUnitPreferenceKeys;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class PHPUnitLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected static PHPUnitLaunchConfigurationTab theTab;
    private Button fCodeCoverageButton;
    private Button fReportingButton;
    private Text fPhpunitConfigPath;
    private Button fSingleTestRadioButton;
    private Button fProjButton;
    private Label fProjLabel;
    private Text fProjText;
    private String previousSelectedProjectText;
    private Button fSearchButton;
    private Label fTestFileLabel;
    private Label fTestLabel;
    private Text fTestText;
    private Button fTestContainerRadioButton;
    private IResource fContainerElement;
    private Button fContainerSearchButton;
    private Text fContainerText;
    private Button fUsePharButton;
    private Button fUseComposerButton;
    private IProject fSelectedProject;
    private String fElementPath = "";
    private PHPUnitTestElementFinder testElementFinder = new PHPUnitTestElementFinder();
    private final ILabelProvider fPHPElementLabelProvider = new PHPUnitTreeLabelProvider();
    private final Image fTestIcon = PHPUnitPlugin.createImage("main.png");

    public static PHPUnitLaunchConfigurationTab getCurrent() {
        if (theTab == null) {
            theTab = new PHPUnitLaunchConfigurationTab();
        }
        return theTab;
    }

    public PHPUnitLaunchConfigurationTab() {
        theTab = this;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            boolean isContainer = config.getAttribute("org.eclipse.php.phpunit.is_suite", false);
            String container = config.getAttribute("org.eclipse.php.phpunit.container", "");
            String containerTypeName = config.getAttribute("ZEND_PHPUNIT_TESTS_CONTAINER_TYPE", "");
            String projectName = config.getAttribute("org.eclipse.php.phpunit.project", "");
            String testClassName = config.getAttribute("org.eclipse.php.phpunit.class", "");
            String testFileName = config.getAttribute("org.eclipse.php.phpunit.file", "");
            boolean codeCoverage = config.getAttribute("org.eclipse.php.phpunit.code_coverage", false);
            boolean xmlReporting = config.getAttribute("org.eclipse.php.phpunit.logXml", false);
            String xmlUnitConfig = config.getAttribute("org.eclipse.php.phpunit.phpunitPath", "");
            String executionType = config.getAttribute("org.eclipse.php.phpunit.runType", "PHAR_EXECUTION_TYPE");
            this.fSingleTestRadioButton.setSelection(!isContainer);
            this.fTestContainerRadioButton.setSelection(isContainer);
            this.setEnableSingleTestGroup(!isContainer);
            this.setEnableContainerTestGroup(isContainer);
            if (isContainer && !projectName.isEmpty()) {
                IProject containerElement = null;
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (!container.isEmpty()) {
                    if ("SCRIPT_SOURCE".equals(containerTypeName)) {
                        IFile file = project.getFile(container);
                        containerElement = file;
                    }
                    if ("SCRIPT_FOLDER".equals(containerTypeName)) {
                        IFolder folder = project.getFolder(container);
                        containerElement = folder;
                    }
                }
                if ("SCRIPT_PROJECT".equals(containerTypeName)) {
                    containerElement = project;
                }
                if (containerElement != null) {
                    this.fContainerElement = containerElement;
                    this.fContainerText.setText(this.fContainerElement.getFullPath().toPortableString());
                }
                if (this.fContainerElement == null) {
                    this.testModeChanged();
                }
                this.fTestText.setText("");
                this.fTestFileLabel.setText("");
            } else {
                this.fProjText.setText(projectName);
                this.fTestText.setText(testClassName);
                this.fTestFileLabel.setText(testFileName);
                this.fContainerText.setText("");
            }
            this.fPhpunitConfigPath.setText(xmlUnitConfig);
            this.fCodeCoverageButton.setSelection(codeCoverage);
            this.fReportingButton.setSelection(xmlReporting);
            this.fUsePharButton.setSelection(executionType.equals("PHAR_EXECUTION_TYPE"));
            this.fUseComposerButton.setSelection(!this.fUsePharButton.getSelection());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.createElementGroup(comp);
        this.createAdditionalGroup(comp);
        this.createExecutionGroup(comp);
    }

    private String choosePHPUnitConfig() {
        String initialPath = this.fPhpunitConfigPath.getText();
        IProject root = this.fSelectedProject;
        String pathStr = OpenFileDialog.openFile(this.getShell(), (IContainer)root, PHPUnitMessages.PHPUnitLaunchConfigurationTab_2, PHPUnitMessages.PHPUnitLaunchConfigurationTab_3, initialPath);
        if (pathStr == null) {
            return "";
        }
        Path path = new Path(pathStr);
        return path.removeFirstSegments(1).toOSString();
    }

    private void notifyParameterChanged() {
        this.validatePage();
        this.updateLaunchConfigurationDialog();
    }

    private void createAdditionalGroup(Composite comp) {
        Group additionalGroup = new Group(comp, 0);
        additionalGroup.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Additional);
        additionalGroup.setLayout((Layout)new GridLayout(3, false));
        additionalGroup.setLayoutData((Object)new GridData(768));
        this.createCodeCoverageSection((Composite)additionalGroup);
        this.createReportingSection((Composite)additionalGroup);
    }

    private void createCodeCoverageSection(Composite comp) {
        this.fCodeCoverageButton = new Button(comp, 32);
        this.fCodeCoverageButton.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Coverage);
        this.fCodeCoverageButton.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fCodeCoverageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPUnitLaunchConfigurationTab.this.notifyParameterChanged();
            }
        });
        Link fLink = new Link(comp, 64);
        fLink.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_6);
        fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)PHPUnitLaunchConfigurationTab.this.getShell(), (String)"org.eclipse.php.phpunit.preferences", (String[])new String[]{"org.eclipse.php.phpunit.preferences"}, null);
                dialog.open();
            }
        });
    }

    private void createReportingSection(Composite comp) {
        this.fReportingButton = new Button(comp, 32);
        this.fReportingButton.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Generate_Report);
        this.fReportingButton.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        this.fReportingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPUnitLaunchConfigurationTab.this.notifyParameterChanged();
            }
        });
        Label label = new Label(comp, 0);
        label.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_2);
        this.fPhpunitConfigPath = new Text(comp, 2048);
        this.fPhpunitConfigPath.addModifyListener(e -> this.notifyParameterChanged());
        GridData gd = new GridData(768);
        this.fPhpunitConfigPath.setLayoutData((Object)gd);
        Button browse = new Button(comp, 0);
        browse.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_5);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPUnitLaunchConfigurationTab.this.handleBrowsePHPUnitConfigPressed();
            }
        });
    }

    private void createExecutionGroup(Composite comp) {
        Group group = new Group(comp, 0);
        group.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Execution_parameters);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.fUsePharButton = new Button((Composite)group, 16);
        this.fUsePharButton.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Use_global_phar);
        this.fUsePharButton.setLayoutData((Object)new GridData(1, 1, true, true));
        this.fUsePharButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPUnitLaunchConfigurationTab.this.notifyParameterChanged();
            }
        });
        Link fLink = new Link((Composite)group, 64);
        fLink.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Preferences_link);
        fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)PHPUnitLaunchConfigurationTab.this.getShell(), (String)"org.eclipse.php.phpunit.preferences", (String[])new String[]{"org.eclipse.php.phpunit.preferences"}, null);
                dialog.open();
            }
        });
        this.fUseComposerButton = new Button((Composite)group, 16);
        this.fUseComposerButton.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Use_composer);
        this.fUseComposerButton.setLayoutData((Object)new GridData(1, 1, true, true, 2, 1));
        this.fUseComposerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPUnitLaunchConfigurationTab.this.notifyParameterChanged();
            }
        });
    }

    private void createElementGroup(Composite comp) {
        Group elementGroup = new Group(comp, 0);
        elementGroup.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Elements);
        elementGroup.setLayout((Layout)new GridLayout(3, false));
        elementGroup.setLayoutData((Object)new GridData(768));
        this.createSingleTestSection((Composite)elementGroup);
        this.createTestContainerSection((Composite)elementGroup);
    }

    private void createProjButton(Composite comp) {
        this.fProjButton = new Button(comp, 8);
        this.fProjButton.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Browse);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PHPUnitLaunchConfigurationTab.this.handleProjectButtonPressed();
            }
        });
        this.setButtonGridData(this.fProjButton);
    }

    private void createProjLabel(Composite comp) {
        this.fProjLabel = new Label(comp, 0);
        this.fProjLabel.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Project);
        GridData gd = new GridData();
        gd.horizontalIndent = 25;
        this.fProjLabel.setLayoutData((Object)gd);
    }

    private void createProjText(Composite comp) {
        this.fProjText = new Text(comp, 2052);
        this.fProjText.setLayoutData((Object)new GridData(768));
        this.fProjText.addModifyListener(evt -> {
            if (this.previousSelectedProjectText != null && this.previousSelectedProjectText.length() > 0 && !this.previousSelectedProjectText.equals(this.fProjText.getText())) {
                this.testElementFinder.cleareCaches();
            }
            this.previousSelectedProjectText = this.fProjText.getText();
            this.validatePage();
            this.notifyParameterChanged();
            this.fSearchButton.setEnabled(this.fSingleTestRadioButton.getSelection() && this.fProjText.getText().length() > 0);
        });
    }

    private void createSingleTestSection(Composite comp) {
        this.createTestRadioButton(comp);
        this.createProjLabel(comp);
        this.createProjText(comp);
        this.createProjButton(comp);
        this.createTestLabel(comp);
        this.createTestText(comp);
        this.createTestSearchButton(comp);
        new Label(comp, 0);
        this.createTestFileLabel(comp);
    }

    private void createTestContainerSection(Composite comp) {
        this.fTestContainerRadioButton = new Button(comp, 16);
        this.fTestContainerRadioButton.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Run_Container);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fTestContainerRadioButton.setLayoutData((Object)gd);
        this.fTestContainerRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PHPUnitLaunchConfigurationTab.this.fTestContainerRadioButton.getSelection()) {
                    PHPUnitLaunchConfigurationTab.this.testModeChanged();
                }
            }
        });
        this.fContainerText = new Text(comp, 2060);
        gd = new GridData(768);
        gd.horizontalIndent = 25;
        gd.horizontalSpan = 2;
        this.fContainerText.setLayoutData((Object)gd);
        this.fContainerText.addModifyListener(evt -> this.notifyParameterChanged());
        this.fContainerSearchButton = new Button(comp, 8);
        this.fContainerSearchButton.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Search);
        this.fContainerSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PHPUnitLaunchConfigurationTab.this.handleContainerSearchButtonSelected();
            }
        });
        this.setButtonGridData(this.fContainerSearchButton);
    }

    private void createTestFileLabel(Composite comp) {
        this.fTestFileLabel = new Label(comp, 0);
        this.fTestFileLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
    }

    private void createTestLabel(Composite comp) {
        this.fTestLabel = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalIndent = 25;
        this.fTestLabel.setLayoutData((Object)gd);
        this.fTestLabel.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Class);
    }

    private void createTestRadioButton(Composite comp) {
        this.fSingleTestRadioButton = new Button(comp, 16);
        this.fSingleTestRadioButton.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Test);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fSingleTestRadioButton.setLayoutData((Object)gd);
        this.fSingleTestRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PHPUnitLaunchConfigurationTab.this.fSingleTestRadioButton.getSelection()) {
                    PHPUnitLaunchConfigurationTab.this.testModeChanged();
                }
            }
        });
    }

    private void createTestSearchButton(Composite comp) {
        this.fSearchButton = new Button(comp, 8);
        this.fSearchButton.setEnabled(this.fProjText.getText().length() > 0);
        this.fSearchButton.setText(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Search);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IScriptProject phpProject;
                if (PHPUnitLaunchConfigurationTab.this.previousSelectedProjectText != null && PHPUnitLaunchConfigurationTab.this.previousSelectedProjectText.length() > 0 && !PHPUnitLaunchConfigurationTab.this.previousSelectedProjectText.equals(PHPUnitLaunchConfigurationTab.this.fProjText.getText())) {
                    PHPUnitLaunchConfigurationTab.this.testElementFinder.cleareCaches();
                }
                if (!PHPUnitLaunchConfigurationTab.this.validatePHPProject((phpProject = PHPUnitLaunchConfigurationTab.this.getPHPProject()).getProject())) {
                    return;
                }
                PHPUnitLaunchConfigurationTab.this.previousSelectedProjectText = PHPUnitLaunchConfigurationTab.this.fProjText.getText();
                PHPUnitLaunchConfigurationTab.this.handleSearchButtonPressed();
            }
        });
        this.setButtonGridData(this.fSearchButton);
    }

    private void createTestText(Composite comp) {
        this.fTestText = new Text(comp, 2052);
        this.fTestText.setLayoutData((Object)new GridData(768));
        this.fTestText.addModifyListener(evt -> this.updateLaunchConfigurationDialog());
        this.fTestText.setEditable(false);
    }

    private IScriptProject getPHPProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.isEmpty()) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.fProjText.getText());
        try {
            if (PHPToolkitUtil.isPHPProject((IProject)project)) {
                return DLTKCore.create((IProject)project);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    private String getProjectRelativePath(IResource element) {
        if (element instanceof IProject) {
            return "";
        }
        return element.getFullPath().makeRelativeTo(element.getProject().getFullPath()).toOSString();
    }

    private void handleContainerSearchButtonSelected() {
        IResource phpElement = this.chooseContainer(this.fContainerElement);
        if (phpElement != null) {
            this.setContainerElement(phpElement);
        }
    }

    private IResource chooseContainer(Object initElement) {
        WorkbenchContentProvider provider = new WorkbenchContentProvider();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setTitle(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Container_Selection);
        dialog.setMessage(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Choose_Container);
        RSEProjectFilter filter1 = new RSEProjectFilter();
        dialog.addFilter((ViewerFilter)filter1);
        DotFileFilter filter2 = new DotFileFilter();
        dialog.addFilter((ViewerFilter)filter2);
        ClosedProjectFilter filter3 = new ClosedProjectFilter();
        dialog.addFilter((ViewerFilter)filter3);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    IResource resource = (IResource)element;
                    return "php".equalsIgnoreCase(resource.getFileExtension());
                }
                return true;
            }
        });
        LibraryFilter filter6 = new LibraryFilter();
        dialog.addFilter((ViewerFilter)filter6);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.setInitialSelection(initElement);
        if (dialog.open() == 0) {
            return (IResource)dialog.getFirstResult();
        }
        return null;
    }

    private void handleProjectButtonPressed() {
        IProject project = this.choosePHPProject();
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        this.fProjText.setText(projectName);
        this.validatePHPProject(project);
    }

    private void handleBrowsePHPUnitConfigPressed() {
        String newPath = this.choosePHPUnitConfig();
        this.fPhpunitConfigPath.setText(newPath);
    }

    private void handleSearchButtonPressed() {
        IScriptProject phpProject = this.getPHPProject();
        if (phpProject == null) {
            return;
        }
        boolean[] radioSetting = new boolean[2];
        try {
            try {
                radioSetting[0] = this.fSingleTestRadioButton.getSelection();
                radioSetting[1] = this.fTestContainerRadioButton.getSelection();
                if (this.testElementFinder.getPHP_UNIT_SUITE_CACHED() == null && this.testElementFinder.getPHP_UNIT_CASE_CACHED() == null) {
                    this.getLaunchConfigurationDialog().run(true, false, this.testElementFinder.search(phpProject));
                }
            }
            catch (InterruptedException e) {
                this.setErrorMessage(e.getMessage());
                this.fSingleTestRadioButton.setSelection(radioSetting[0]);
                this.fTestContainerRadioButton.setSelection(radioSetting[1]);
                return;
            }
            catch (InvocationTargetException e) {
                PHPUnitPlugin.log(e.getTargetException());
                this.fSingleTestRadioButton.setSelection(radioSetting[0]);
                this.fTestContainerRadioButton.setSelection(radioSetting[1]);
                return;
            }
        }
        finally {
            this.fSingleTestRadioButton.setSelection(radioSetting[0]);
            this.fTestContainerRadioButton.setSelection(radioSetting[1]);
        }
        Shell shell = this.getShell();
        TestSelectionDialog dialog = new TestSelectionDialog(shell, this.testElementFinder.getPHP_UNIT_CASES_AND_SUITES());
        dialog.setTitle(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Test_Selection);
        dialog.setMessage(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Choose_Test);
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        IType type = (IType)results[0];
        if (type != null) {
            this.fElementPath = type.getPath().toOSString();
            this.fTestText.setText(type.getElementName());
            this.fProjText.setText(type.getScriptProject().getElementName());
            IResource typResource = type.getResource();
            if (typResource != null) {
                IPath relativePath = typResource.getFullPath().makeRelativeTo(typResource.getProject().getFullPath());
                this.fTestFileLabel.setText(relativePath.toPortableString());
                this.validatePHPProject(typResource.getProject());
            } else {
                this.fTestFileLabel.setText("");
                this.validatePHPProject(null);
            }
        }
    }

    private IProject choosePHPProject() {
        ModelElementLabelProvider labelProvider = new ModelElementLabelProvider(ModelElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Project_Selection);
        dialog.setMessage(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Choose_Project);
        Object[] scriptProjects = this.getScriptProjects();
        dialog.setElements(scriptProjects);
        dialog.setInitialSelections(scriptProjects);
        if (dialog.open() == 0) {
            IScriptProject scriptProject = (IScriptProject)dialog.getFirstResult();
            return scriptProject.getProject();
        }
        return null;
    }

    private IScriptProject[] getScriptProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects == null) {
            return new IScriptProject[0];
        }
        ArrayList<IScriptProject> scriptProjectsList = new ArrayList<IScriptProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isOpen() && project.hasNature("org.eclipse.php.core.PHPNature") && !project.hasNature("org.eclipse.rse.ui.remoteSystemsTempNature") && !project.getName().equals("RemoteSystemsTempFiles")) {
                    IScriptProject scriptProject = DLTKCore.create((IProject)project);
                    scriptProjectsList.add(scriptProject);
                }
            }
            catch (CoreException e) {
                PHPUnitPlugin.log(e);
            }
            ++n2;
        }
        return scriptProjectsList.toArray(new IScriptProject[scriptProjectsList.size()]);
    }

    private String findFileToExecute(ILaunchConfiguration config, IProject project) throws CoreException {
        String runType = config.getAttribute("org.eclipse.php.phpunit.runType", "PHAR_EXECUTION_TYPE");
        if ("COMPOSER_EXECUTION_TYPE".equals(runType)) {
            return PHPUnitLaunchUtils.findComposerExecutionFile(project);
        }
        if ("PHAR_EXECUTION_TYPE".equals(runType)) {
            return PHPUnitPreferenceKeys.getPHPUnitPharPath();
        }
        return null;
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.getErrorMessage() == null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this.fSelectedProject = null;
        if (this.fTestContainerRadioButton.getSelection()) {
            config.setAttribute("org.eclipse.php.phpunit.is_suite", true);
            if (this.fContainerElement != null) {
                this.fElementPath = this.fContainerElement.getFullPath().toOSString();
                this.fSelectedProject = this.fContainerElement.getProject();
                config.setAttribute("org.eclipse.php.phpunit.project", this.fSelectedProject.getProject().getName());
                config.setAttribute("org.eclipse.php.phpunit.container", this.getProjectRelativePath(this.fContainerElement));
                String typeName = this.getContainerType(this.fContainerElement);
                config.setAttribute("ZEND_PHPUNIT_TESTS_CONTAINER_TYPE", typeName);
            }
        } else {
            config.setAttribute("org.eclipse.php.phpunit.is_suite", false);
            String pText = this.fProjText.getText();
            config.setAttribute("org.eclipse.php.phpunit.project", pText);
            if (pText != null) {
                IScriptProject[] scriptProjects;
                IScriptProject[] iScriptProjectArray = scriptProjects = this.getScriptProjects();
                int n = scriptProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IScriptProject script = iScriptProjectArray[n2];
                    if (pText.equals(script.getProject().getName())) {
                        this.fSelectedProject = script.getProject();
                        break;
                    }
                    ++n2;
                }
            }
            config.setAttribute("org.eclipse.php.phpunit.class", this.fTestText.getText());
            config.setAttribute("org.eclipse.php.phpunit.file", this.fTestFileLabel.getText());
            config.setAttribute("ZEND_PHPUNIT_TESTS_CONTAINER_TYPE", "SCRIPT_SOURCE");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.fElementPath)) {
            config.setAttribute("org.eclipse.php.phpunit.elementPath", this.fElementPath);
            this.fElementPath = "";
        }
        config.setAttribute("org.eclipse.php.phpunit.code_coverage", this.fCodeCoverageButton.getSelection());
        config.setAttribute("org.eclipse.php.phpunit.logXml", this.fReportingButton.getSelection());
        config.setAttribute("org.eclipse.php.phpunit.phpunitPath", this.fPhpunitConfigPath.getText());
        if (this.fUsePharButton.getSelection()) {
            config.setAttribute("org.eclipse.php.phpunit.runType", "PHAR_EXECUTION_TYPE");
        } else if (this.fUseComposerButton.getSelection()) {
            config.setAttribute("org.eclipse.php.phpunit.runType", "COMPOSER_EXECUTION_TYPE");
        }
        try {
            config.setAttribute("firstLineBreakpoint", false);
            String projectName = config.getAttribute("org.eclipse.php.phpunit.project", "");
            if (StringUtils.isNotEmpty((CharSequence)projectName)) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                config.setAttribute("org.eclipse.php.debug.core.PHP_Project", project.getName());
                String fileToExecute = this.findFileToExecute((ILaunchConfiguration)config, project);
                config.setAttribute("ATTR_FILE", fileToExecute);
                config.setAttribute("ATTR_FILE_FULL_PATH", fileToExecute);
            }
        }
        catch (CoreException e) {
            PHPUnitPlugin.log(e);
        }
    }

    private String getContainerType(IResource container) {
        if (container instanceof IProject) {
            return "SCRIPT_PROJECT";
        }
        if (container instanceof IFolder) {
            return "SCRIPT_FOLDER";
        }
        if (container instanceof IFile) {
            return "SCRIPT_SOURCE";
        }
        return null;
    }

    private void setButtonGridData(Button button) {
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
    }

    private void setContainerElement(IResource container) {
        this.fContainerElement = container;
        this.fContainerText.setText(container.getFullPath().toString());
        this.validatePage();
        this.notifyParameterChanged();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        PHPUnitLaunchUtils.initializeDefaults(config);
    }

    private void setEnableContainerTestGroup(boolean enabled) {
        this.fContainerSearchButton.setEnabled(enabled);
        this.fContainerText.setEnabled(enabled);
    }

    private void setEnableSingleTestGroup(boolean enabled) {
        this.fProjLabel.setEnabled(enabled);
        this.fProjText.setEnabled(enabled);
        this.fProjButton.setEnabled(enabled);
        this.fTestLabel.setEnabled(enabled);
        this.fSearchButton.setEnabled(enabled && this.fProjText.getText().length() > 0);
    }

    private void testModeChanged() {
        IScriptProject phpProject;
        if (this.previousSelectedProjectText != null && this.previousSelectedProjectText.length() > 0 && !this.previousSelectedProjectText.equals(this.fProjText.getText())) {
            this.testElementFinder.cleareCaches();
        }
        this.previousSelectedProjectText = this.fProjText.getText();
        boolean isSingleTestMode = this.fSingleTestRadioButton.getSelection();
        this.setEnableSingleTestGroup(isSingleTestMode);
        this.setEnableContainerTestGroup(!isSingleTestMode);
        if (!isSingleTestMode && StringUtils.isEmpty((CharSequence)this.fContainerText.getText()) && (phpProject = this.getPHPProject()) != null) {
            this.setContainerElement((IResource)phpProject.getProject());
        }
        this.validatePage();
        this.updateLaunchConfigurationDialog();
    }

    private void validatePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fSingleTestRadioButton.getSelection()) {
            IScriptProject scriptProject = this.getPHPProject();
            if (scriptProject == null) {
                this.testElementFinder.cleareCaches();
                this.setErrorMessage(PHPUnitMessages.PHPUnitLaunchConfigurationTab_No_Project);
                return;
            }
            String projectName = scriptProject.getElementName();
            IStatus status = ResourcesPlugin.getWorkspace().validatePath(String.valueOf('/') + projectName, 4);
            if (!status.isOK()) {
                this.testElementFinder.cleareCaches();
                this.setErrorMessage(PHPUnitMessages.format(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Bad_Project_Name, projectName));
                return;
            }
            IProject project = scriptProject.getProject();
            if (!project.exists()) {
                this.testElementFinder.cleareCaches();
                this.setErrorMessage(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Project_unavailable);
                return;
            }
            try {
                if (!PHPToolkitUtil.isPHPProject((IProject)project)) {
                    this.setErrorMessage(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Project_Not_PHP);
                    this.testElementFinder.cleareCaches();
                    return;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (this.validatePHPProject(project.getProject())) {
                String className = this.fTestText.getText().trim();
                if (className.length() == 0) {
                    this.setErrorMessage(PHPUnitMessages.PHPUnitLaunchConfigurationTab_No_Test);
                    return;
                }
                IDLTKSearchScope searchScope = SearchEngine.createSearchScope((IModelElement)scriptProject);
                IType[] classes = PHPModelAccess.getDefault().findTypes(className, ISearchEngine.MatchRule.EXACT, 0, 2057, searchScope, null);
                if (classes.length < 1) {
                    this.setErrorMessage(PHPUnitMessages.format(PHPUnitMessages.PHPUnitValidator_Not_In_Project, new String[]{className, projectName}));
                }
            }
        } else {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = root.findMember(this.fContainerText.getText());
            if (resource == null) {
                this.setErrorMessage(PHPUnitMessages.PHPUnitLaunchConfigurationTab_No_Element_To_Test);
                return;
            }
        }
        if (this.fUseComposerButton.getSelection() && this.fSelectedProject != null && PHPUnitLaunchUtils.findComposerExecutionFile(this.fSelectedProject) == null) {
            this.setErrorMessage(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Unable_find_dependencies);
            return;
        }
    }

    private boolean validatePHPProject(IProject phpProject) {
        try {
            if (this.testElementFinder.getPHP_UNIT_SUITE_CACHED() == null && this.testElementFinder.getPHP_UNIT_CASE_CACHED() == null) {
                this.getLaunchConfigurationDialog().run(true, false, this.testElementFinder.search(DLTKCore.create((IProject)phpProject)));
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            PHPUnitPlugin.log(e);
        }
        if (this.testElementFinder.getPHP_UNIT_CASES_AND_SUITES() == null || this.testElementFinder.getPHP_UNIT_CASES_AND_SUITES().length == 0) {
            this.setErrorMessage(PHPUnitMessages.PHPUnitLaunchConfigurationTab_Project_No_Tests);
            this.fSearchButton.setEnabled(false);
            this.updateLaunchConfigurationDialog();
            return false;
        }
        this.fSearchButton.setEnabled(true);
        return true;
    }

    public Image getImage() {
        return this.fTestIcon;
    }

    public String getName() {
        return PHPUnitMessages.PHPUnitLaunchConfigurationTab_7;
    }

    public void dispose() {
        super.dispose();
        this.fTestIcon.dispose();
        this.fPHPElementLabelProvider.dispose();
    }

    protected static class PHPUnitTreeLabelProvider
    extends LabelProvider {
        private Image fScriptFolder;
        private Image fClassImage = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.class_obj.png");
        private Image fPHPProject;
        private Image fPHPFile;

        public PHPUnitTreeLabelProvider() {
            this.fScriptFolder = PHPPluginImages.get((String)"org.eclipse.php.ui.folder_opened.png");
            this.fPHPProject = PHPPluginImages.get((String)"org.eclipse.php.ui.php_project_obj.png");
            this.fPHPFile = PHPPluginImages.get((String)"org.eclipse.php.ui.phpfile.png");
        }

        public String getText(Object element) {
            if (element != null) {
                String elementName = "";
                if (element instanceof IModelElement) {
                    IModelElement modelElement = (IModelElement)element;
                    elementName = modelElement.getElementName();
                }
                return elementName;
            }
            return "";
        }

        public Image getImage(Object element) {
            Image result = null;
            if (element != null && element instanceof IModelElement) {
                if (element instanceof IScriptProject) {
                    return this.fPHPProject;
                }
                if (element instanceof IScriptFolder || element instanceof IProjectFragment) {
                    result = this.fScriptFolder;
                }
                if (element instanceof ISourceModule) {
                    result = this.fPHPFile;
                }
                if (element instanceof IType) {
                    result = this.fClassImage;
                }
            }
            return result;
        }
    }
}

