/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTNodes;
import org.eclipse.php.core.ast.nodes.BindingResolver;
import org.eclipse.php.core.ast.nodes.Bindings;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FieldAccess;
import org.eclipse.php.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.core.ast.nodes.FormalParameter;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.FunctionName;
import org.eclipse.php.core.ast.nodes.IBinding;
import org.eclipse.php.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.Include;
import org.eclipse.php.core.ast.nodes.IncludeBinding;
import org.eclipse.php.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.core.ast.nodes.MethodBinding;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.MethodInvocation;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.core.ast.nodes.TypeBinding;
import org.eclipse.php.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.core.ast.nodes.VariableBinding;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.model.PerFileModelAccessCache;
import org.eclipse.php.internal.core.typeinference.BindingUtility;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPCachedTypeInferencer;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPNamespaceConstantType;

public class DefaultBindingResolver
extends BindingResolver {
    BindingTables bindingTables;
    private final ISourceModule sourceModule;
    WorkingCopyOwner workingCopyOwner;
    private BindingUtility bindingUtil;
    private PerFileModelAccessCache modelAccessCache;

    public DefaultBindingResolver(ISourceModule sourceModule, WorkingCopyOwner owner) {
        this.sourceModule = sourceModule;
        this.workingCopyOwner = owner;
        this.bindingTables = new BindingTables();
        this.modelAccessCache = new PerFileModelAccessCache(sourceModule);
        this.bindingUtil = new BindingUtility(this.sourceModule, this.modelAccessCache);
    }

    private ITypeBinding internalGetTypeBinding(IEvaluatedType type, IModelElement modelElement) {
        String typeName = type.getTypeName();
        if (typeName == null) {
            return null;
        }
        String key = "7:" + typeName;
        IBinding binding = this.bindingTables.bindingKeysToBindings.get(key);
        if (binding == null) {
            binding = new TypeBinding((BindingResolver)this, type, modelElement);
            this.bindingTables.bindingKeysToBindings.put(key, binding);
        }
        return (ITypeBinding)binding;
    }

    private ITypeBinding internalGetTypeBinding(IEvaluatedType type, IModelElement[] modelElements) {
        String typeName = type.getTypeName();
        if (typeName == null) {
            return null;
        }
        String key = "7:" + typeName;
        IBinding binding = this.bindingTables.bindingKeysToBindings.get(key);
        if (binding == null) {
            binding = new TypeBinding((BindingResolver)this, type, modelElements);
            this.bindingTables.bindingKeysToBindings.put(key, binding);
        }
        return (ITypeBinding)binding;
    }

    @Override
    ITypeBinding getTypeBinding(IType type) {
        if (type != null) {
            return this.internalGetTypeBinding((IEvaluatedType)PHPClassType.fromIType(type), (IModelElement)type);
        }
        return null;
    }

    @Override
    ITypeBinding getTypeBinding(IType[] types) {
        if (ArrayUtils.isNotEmpty((Object[])types)) {
            return this.internalGetTypeBinding((IEvaluatedType)PHPClassType.fromIType(types[0]), (IModelElement[])types);
        }
        return null;
    }

    @Override
    IVariableBinding getVariableBinding(IField field) {
        if (field != null) {
            return new VariableBinding(this, (IMember)field);
        }
        return null;
    }

    @Override
    public IMethodBinding getMethodBinding(IMethod method) {
        if (method != null) {
            return new MethodBinding(this, method);
        }
        return null;
    }

    @Override
    public ITypeBinding[] getMethodReturnTypeBinding(IMethod method) {
        LinkedList<ITypeBinding> result;
        block9: {
            result = new LinkedList<ITypeBinding>();
            try {
                int flags = method.getFlags();
                if (!PHPFlags.isAbstract((int)flags)) {
                    IEvaluatedType[] evaluatedFunctionReturnTypes;
                    IEvaluatedType[] iEvaluatedTypeArray = evaluatedFunctionReturnTypes = this.bindingUtil.getFunctionReturnType(method);
                    int n = evaluatedFunctionReturnTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEvaluatedType currentEvaluatedType = iEvaluatedTypeArray[n2];
                        ITypeBinding typeBinding = this.getTypeBinding(currentEvaluatedType, this.sourceModule);
                        if (typeBinding != null) {
                            result.add(typeBinding);
                        }
                        ++n2;
                    }
                } else {
                    IModelElement parentElement = method.getParent();
                    if (parentElement instanceof IType) {
                        IType[] functionReturnTypes;
                        IType parent = (IType)parentElement;
                        IType[] iTypeArray = functionReturnTypes = CodeAssistUtils.getFunctionReturnType(new IType[]{parent}, method.getElementName(), 96, method.getSourceModule(), 0);
                        int n = functionReturnTypes.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IType currentEvaluatedType = iTypeArray[n3];
                            ITypeBinding typeBinding = this.getTypeBinding(currentEvaluatedType);
                            if (typeBinding != null) {
                                result.add(typeBinding);
                            }
                            ++n3;
                        }
                    }
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block9;
                e.printStackTrace();
            }
        }
        return result.toArray(new ITypeBinding[result.size()]);
    }

    @Override
    protected IEvaluatedType getEvaluatedType(int offset, int length) {
        try {
            return this.bindingUtil.getType(offset, length);
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                Logger.logException(e);
            }
            return null;
        }
    }

    @Override
    public IModelElement[] getModelElements(int offset, int length) {
        return this.getModelElements(offset, length, true);
    }

    @Override
    public IModelElement[] getModelElements(int offset, int length, boolean filter) {
        try {
            return this.bindingUtil.getModelElement(offset, length, filter, this.getModelAccessCache());
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                Logger.logException(e);
            }
            return null;
        }
    }

    @Override
    IBinding resolveName(Identifier name) {
        FunctionName functionName = this.getFunctionName(name);
        if (functionName != null && functionName.getParent() instanceof FunctionInvocation) {
            return this.resolveFunction((FunctionInvocation)functionName.getParent());
        }
        if (name.getParent() instanceof Variable) {
            return this.resolveVariable((Variable)name.getParent());
        }
        ITypeBinding binding = this.resolveExpressionType(name);
        if (binding instanceof ITypeBinding && binding.getEvaluatedType() instanceof PHPNamespaceConstantType) {
            return this.resolveField(name);
        }
        return binding;
    }

    private FunctionName getFunctionName(Identifier name) {
        ASTNode node = name.getParent();
        while (node != null) {
            if (node instanceof FunctionName) {
                return (FunctionName)node;
            }
            node = node.getParent();
        }
        return null;
    }

    @Override
    IMethodBinding resolveMethod(MethodDeclaration method) {
        block4: {
            if (method == null || method.getFunction() == null) {
                throw new IllegalArgumentException("Can not resolve null expression");
            }
            try {
                IModelElement elementAt = this.sourceModule.getElementAt(method.getStart());
                if (elementAt instanceof IMethod) {
                    return this.getMethodBinding((IMethod)elementAt);
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    ITypeBinding resolveExpressionType(Expression expression) {
        int length;
        if (expression == null) {
            throw new IllegalArgumentException("Can not resolve null expression");
        }
        int start = expression.getStart();
        IEvaluatedType type = this.getEvaluatedType(start, length = expression.getLength());
        if (type != null) {
            IModelElement[] modelElements = this.getModelElements(start, length, false);
            return this.internalGetTypeBinding(type, modelElements);
        }
        return null;
    }

    @Override
    IBinding resolveInclude(Include includeDeclaration) {
        return new IncludeBinding(this.sourceModule, includeDeclaration);
    }

    @Override
    ASTNode findDeclaringNode(IBinding binding) {
        return super.findDeclaringNode(binding);
    }

    @Override
    ASTNode findDeclaringNode(String bindingKey) {
        return super.findDeclaringNode(bindingKey);
    }

    @Override
    ITypeBinding getTypeBinding(SingleFieldDeclaration fieldDeclaration) {
        Object[] modelElements;
        try {
            modelElements = this.bindingUtil.getModelElement(fieldDeclaration.getStart(), fieldDeclaration.getLength(), this.getModelAccessCache());
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                Logger.logException(e);
            }
            return null;
        }
        if (ArrayUtils.isNotEmpty((Object[])modelElements) && modelElements[0].getElementType() == 7) {
            ArrayList<IType> types = new ArrayList<IType>(modelElements.length);
            Object[] objectArray = modelElements;
            int n = modelElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object elem = objectArray[n2];
                types.add((IType)elem);
                ++n2;
            }
            return this.getTypeBinding(types.toArray(new IType[types.size()]));
        }
        return super.getTypeBinding(fieldDeclaration);
    }

    @Override
    ITypeBinding getTypeBinding(IEvaluatedType referenceBinding, ISourceModule sourceModule) {
        if (referenceBinding != null) {
            return this.internalGetTypeBinding(referenceBinding, (IModelElement)sourceModule);
        }
        return null;
    }

    @Override
    Object resolveConstantExpressionValue(Expression expression) {
        return super.resolveConstantExpressionValue(expression);
    }

    @Override
    IMethodBinding resolveConstructor(ClassInstanceCreation expression) {
        Object[] modelElements;
        try {
            modelElements = this.sourceModule.codeSelect(expression.getStart(), expression.getLength());
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                Logger.logException(e);
            }
            return null;
        }
        if (ArrayUtils.isNotEmpty((Object[])modelElements)) {
            Object[] objectArray = modelElements;
            int n = modelElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element.getElementType() == 9) {
                    return new MethodBinding(this, (IMethod)element);
                }
                ++n2;
            }
        }
        return super.resolveConstructor(expression);
    }

    @Override
    IMethodBinding resolveConstructor(MethodInvocation expression) {
        IMethodBinding binding = this.resolveMethod(expression);
        if (binding != null) {
            return binding;
        }
        return super.resolveConstructor(expression);
    }

    @Override
    IVariableBinding resolveField(FieldAccess fieldAccess) {
        Variable var;
        VariableBase member = fieldAccess.getMember();
        if (member.getType() == 60 && !(var = (Variable)member).isDollared() && var.getName() instanceof Identifier) {
            Identifier id = (Identifier)var.getName();
            String fieldName = "$" + id.getName();
            ITypeBinding type = fieldAccess.getDispatcher().resolveTypeBinding();
            return Bindings.findFieldInHierarchy(type, fieldName);
        }
        return null;
    }

    @Override
    IVariableBinding resolveField(StaticConstantAccess constantAccess) {
        Identifier constName = constantAccess.getConstant();
        ITypeBinding type = constantAccess.getClassName().resolveTypeBinding();
        return Bindings.findFieldInHierarchy(type, constName.getName());
    }

    @Override
    IVariableBinding resolveField(Scalar scalar) {
        try {
            IModelElement[] modelElements = this.sourceModule.codeSelect(scalar.getStart(), scalar.getLength());
            if (modelElements != null && modelElements.length > 0) {
                IModelElement[] iModelElementArray = modelElements;
                int n = modelElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelElement element = iModelElementArray[n2];
                    if (element.getElementType() == 8) {
                        return new VariableBinding(this, (IMember)((IField)element));
                    }
                    ++n2;
                }
            }
        }
        catch (ModelException modelException) {}
        return null;
    }

    @Override
    IVariableBinding resolveField(Identifier name) {
        try {
            IModelElement[] modelElements = this.sourceModule.codeSelect(name.getStart(), name.getLength());
            if (modelElements != null && modelElements.length > 0) {
                IModelElement[] iModelElementArray = modelElements;
                int n = modelElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelElement element = iModelElementArray[n2];
                    if (element.getElementType() == 8) {
                        return new VariableBinding(this, (IMember)((IField)element));
                    }
                    ++n2;
                }
            }
        }
        catch (ModelException modelException) {}
        return null;
    }

    @Override
    IVariableBinding resolveField(StaticFieldAccess fieldAccess) {
        Variable var;
        Variable member = fieldAccess.getField();
        if (((ASTNode)member).getType() == 60 && (var = member).isDollared() && var.getName() instanceof Identifier) {
            Identifier id = (Identifier)var.getName();
            String fieldName = "$" + id.getName();
            ITypeBinding type = fieldAccess.getClassName().resolveTypeBinding();
            return Bindings.findFieldInHierarchy(type, fieldName);
        }
        return null;
    }

    @Override
    IFunctionBinding resolveFunction(FunctionDeclaration function) {
        Object[] modelElements = null;
        try {
            Identifier functionName = function.getFunctionName();
            modelElements = this.sourceModule.codeSelect(functionName.getStart(), functionName.getLength());
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                Logger.logException(e);
            }
            return null;
        }
        if (ArrayUtils.isNotEmpty((Object[])modelElements)) {
            Object[] objectArray = modelElements;
            int n = modelElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element.getElementType() == 9) {
                    return new MethodBinding(this, (IMethod)element);
                }
                ++n2;
            }
        }
        return super.resolveFunction(function);
    }

    @Override
    IFunctionBinding resolveFunction(FunctionInvocation function) {
        Object[] modelElements = null;
        try {
            FunctionName functionName = function.getFunctionName();
            modelElements = this.sourceModule.codeSelect(functionName.getStart(), functionName.getLength());
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                Logger.logException(e);
            }
            return null;
        }
        if (ArrayUtils.isNotEmpty((Object[])modelElements)) {
            Object[] objectArray = modelElements;
            int n = modelElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element.getElementType() == 9) {
                    return new MethodBinding(this, (IMethod)element);
                }
                ++n2;
            }
        }
        return super.resolveFunction(function);
    }

    @Override
    IMethodBinding resolveMethod(MethodInvocation method) {
        Object[] modelElements = null;
        try {
            FunctionName functionName = method.getMethod().getFunctionName();
            modelElements = this.sourceModule.codeSelect(functionName.getStart(), functionName.getLength());
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                Logger.logException(e);
            }
            return null;
        }
        if (ArrayUtils.isNotEmpty((Object[])modelElements)) {
            Object[] objectArray = modelElements;
            int n = modelElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element.getElementType() == 9) {
                    return new MethodBinding(this, (IMethod)element);
                }
                ++n2;
            }
        }
        return super.resolveMethod(method);
    }

    @Override
    IMethodBinding resolveMethod(StaticMethodInvocation method) {
        Object[] modelElements = null;
        try {
            FunctionName functionName = method.getMethod().getFunctionName();
            modelElements = this.sourceModule.codeSelect(functionName.getStart(), functionName.getLength());
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                Logger.logException(e);
            }
            return null;
        }
        if (ArrayUtils.isNotEmpty((Object[])modelElements)) {
            Object[] objectArray = modelElements;
            int n = modelElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element.getElementType() == 9) {
                    return new MethodBinding(this, (IMethod)element);
                }
                ++n2;
            }
        }
        return super.resolveMethod(method);
    }

    @Override
    ITypeBinding resolveType(TypeDeclaration type) {
        Object[] modelElements;
        try {
            modelElements = this.bindingUtil.getModelElement(type.getName().getStart(), type.getName().getLength(), this.getModelAccessCache());
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                Logger.logException(e);
            }
            return null;
        }
        if (ArrayUtils.isNotEmpty((Object[])modelElements) && modelElements[0].getElementType() == 7) {
            ArrayList<IType> types = new ArrayList<IType>(modelElements.length);
            Object[] objectArray = modelElements;
            int n = modelElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object elem = objectArray[n2];
                types.add((IType)elem);
                ++n2;
            }
            return this.getTypeBinding(types.toArray(new IType[types.size()]));
        }
        return super.resolveType(type);
    }

    @Override
    ITypeBinding resolveTypeParameter(FormalParameter typeParameter) {
        return super.resolveTypeParameter(typeParameter);
    }

    @Override
    IVariableBinding resolveVariable(FieldsDeclaration variable) {
        return super.resolveVariable(variable);
    }

    @Override
    IVariableBinding resolveVariable(Variable variable) {
        IModelElement modelElements = null;
        try {
            modelElements = this.bindingUtil.getFieldByPosition(variable.getStart(), variable.getLength());
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                Logger.logException(e);
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        if (modelElements != null && modelElements.getElementType() == 8) {
            int id = LocalVariableIndex.perform(variable.getEnclosingBodyNode(), variable);
            return new VariableBinding(this, (IMember)modelElements, variable, id);
        }
        return super.resolveVariable(variable);
    }

    @Override
    ITypeBinding resolveWellKnownType(String name) {
        return super.resolveWellKnownType(name);
    }

    @Override
    public IModelAccessCache getModelAccessCache() {
        return this.modelAccessCache;
    }

    @Override
    public void startBindingSession() {
        this.bindingUtil.setCachedInferencer(new PHPCachedTypeInferencer());
    }

    @Override
    public void stopBindingSession() {
        this.bindingUtil.setCachedInferencer(null);
    }

    protected static class BindingTables {
        Map<String, IBinding> bindingKeysToBindings;
        Map<Integer, org.eclipse.dltk.ast.ASTNode> compilerNodeToASTNode = new HashMap<Integer, org.eclipse.dltk.ast.ASTNode>();

        BindingTables() {
            this.bindingKeysToBindings = new HashMap<String, IBinding>();
        }
    }

    private static class LocalVariableIndex
    extends AbstractVisitor {
        private int fTopIndex;
        private static boolean isProgramScope = false;
        private final Set<String> variablesSet = new HashSet<String>();
        private Variable variable;

        public LocalVariableIndex(Variable variable) {
            this.variable = variable;
        }

        public static int perform(ASTNode node, Variable variable) {
            Assert.isTrue((node != null ? 1 : 0) != 0);
            switch (node.getType()) {
                case 42: {
                    isProgramScope = false;
                    return LocalVariableIndex.internalPerform(((MethodDeclaration)node).getFunction(), variable);
                }
                case 29: {
                    isProgramScope = false;
                    return LocalVariableIndex.internalPerform(node, variable);
                }
                case 46: {
                    isProgramScope = true;
                    return LocalVariableIndex.internalPerform(node, variable);
                }
            }
            Assert.isTrue((boolean)false);
            return -1;
        }

        private static int internalPerform(ASTNode node, Variable variable) {
            LocalVariableIndex counter = new LocalVariableIndex(variable);
            node.accept(counter);
            return counter.fTopIndex;
        }

        @Override
        public boolean visit(Variable variable) {
            String variableName;
            Expression name = variable.getName();
            if ((variable.isDollared() || ASTNodes.isQuotedDollaredCurlied(variable)) && name instanceof Identifier && !(variableName = ((Identifier)name).getName()).equalsIgnoreCase("this") && !this.variablesSet.contains(variableName)) {
                String searchName = ((Identifier)this.variable.getName()).getName();
                if (variableName.equals(searchName) && variable.getType() == this.variable.getType()) {
                    this.handleVariableBinding();
                }
                this.variablesSet.add(variableName);
            }
            return true;
        }

        @Override
        public boolean visit(FunctionDeclaration function) {
            return !isProgramScope;
        }

        @Override
        public boolean visit(ClassDeclaration classDeclaration) {
            return !isProgramScope;
        }

        @Override
        public boolean visit(InterfaceDeclaration interfaceDeclaration) {
            return !isProgramScope;
        }

        private void handleVariableBinding() {
            this.fTopIndex = this.variablesSet.size();
        }
    }
}

