/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.docker.launcher;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.ProcessClosure;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.cdt.managedbuilder.buildproperties.IOptionalBuildProperties;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.linuxtools.docker.ui.launch.ContainerLauncher;
import org.eclipse.linuxtools.docker.ui.launch.IErrorMessageHolder;
import org.eclipse.linuxtools.internal.docker.ui.launch.ContainerCommandProcess;
import org.eclipse.osgi.util.NLS;

public class ContainerCommandLauncher
implements ICommandLauncher,
IErrorMessageHolder {
    public static final String CONTAINER_BUILD_ENABLED = "org.eclipse.cdt.docker.launcher.containerbuild.property.enablement";
    public static final String CONNECTION_ID = "org.eclipse.cdt.docker.launcher.containerbuild.property.connection";
    public static final String IMAGE_ID = "org.eclipse.cdt.docker.launcher.containerbuild.property.image";
    public static final String VOLUMES_ID = "org.eclipse.cdt.docker.launcher.containerbuild.property.volumes";
    public static final String SELECTED_VOLUMES_ID = "org.eclipse.cdt.docker.launcher.containerbuild.property.selectedvolumes";
    public static final String VOLUME_SEPARATOR_REGEX = "[|]";
    private IProject fProject;
    private Process fProcess;
    private boolean fShowCommand;
    private String fErrorMessage;
    private Properties fEnvironment;
    private String[] commandArgs;
    private String fImageName = "";
    public static final int COMMAND_CANCELED = 1;
    public static final int ILLEGAL_COMMAND = -1;
    public static final int OK = 0;
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    protected static final long DELAY = 50L;

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public IProject getProject() {
        return this.fProject;
    }

    private String getImageName() {
        return this.fImageName;
    }

    private void setImageName(String imageName) {
        this.fImageName = imageName;
    }

    public void showCommand(boolean show) {
        this.fShowCommand = show;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void setErrorMessage(String error) {
        this.fErrorMessage = error;
    }

    public String[] getCommandArgs() {
        return this.commandArgs;
    }

    public Properties getEnvironment() {
        return this.fEnvironment;
    }

    public String getCommandLine() {
        return null;
    }

    public Process execute(IPath commandPath, String[] args, String[] env, IPath workingDirectory, IProgressMonitor monitor) throws CoreException {
        String connectionName;
        Path referencedProjects;
        Path p;
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("org.eclipse.cdt.container-command", "");
        String projectName = this.fProject.getName();
        labels.put("org.eclipse.cdt.project-name", projectName);
        ArrayList<String> additionalDirs = new ArrayList<String>();
        IPath projectLocation = this.fProject.getLocation();
        String projectPath = projectLocation.toPortableString();
        if (projectLocation.getDevice() != null) {
            projectPath = "/" + projectPath.replace(':', '/');
        }
        additionalDirs.add(projectPath);
        ArrayList<String> commandSegments = new ArrayList<String>();
        StringBuilder b = new StringBuilder();
        String commandString = commandPath.toPortableString();
        if (commandPath.getDevice() != null) {
            commandString = "/" + commandString.replace(':', '/');
        }
        b.append(commandString);
        commandSegments.add(commandString);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            File f;
            String arg = stringArray[n2];
            b.append(" ");
            String realArg = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arg);
            if (Platform.getOS().equals("win32")) {
                p = new Path(realArg);
                if (p.isValidPath(realArg) && p.getDevice() != null) {
                    f = p.toFile();
                    String modifiedArg = realArg;
                    if (f.isFile()) {
                        f = f.getParentFile();
                        modifiedArg = "/" + p.toPortableString().replace(':', '/');
                        p = p.removeLastSegments(1);
                    }
                    if (f != null && f.exists()) {
                        additionalDirs.add("/" + p.toPortableString().replace(':', '/'));
                        realArg = modifiedArg;
                    }
                }
            } else if (realArg.startsWith("/") && (p = new Path(realArg)).isValidPath(realArg)) {
                f = p.toFile();
                if (f.isFile()) {
                    f = f.getParentFile();
                }
                if (f != null && f.exists()) {
                    additionalDirs.add(f.getAbsolutePath());
                }
            }
            b.append(realArg);
            commandSegments.add(realArg);
            ++n2;
        }
        this.commandArgs = commandSegments.toArray(new String[0]);
        String commandDir = commandPath.removeLastSegments(1).toString();
        if (commandDir.isEmpty()) {
            commandDir = null;
        } else if (commandPath.getDevice() != null) {
            commandDir = "/" + commandDir.replace(':', '/');
        }
        p = referencedProjects = this.fProject.getReferencedProjects();
        int realArg = ((IProject[])p).length;
        int n3 = 0;
        while (n3 < realArg) {
            Path referencedProject = p[n3];
            String referencedProjectPath = referencedProject.getLocation().toPortableString();
            if (referencedProject.getLocation().getDevice() != null) {
                referencedProjectPath = "/" + referencedProjectPath.replace(':', '/');
            }
            additionalDirs.add(referencedProjectPath);
            ++n3;
        }
        String command = b.toString();
        String workingDir = workingDirectory.makeAbsolute().toPortableString();
        if (workingDirectory.toPortableString().equals(".")) {
            workingDir = "/tmp";
        } else if (workingDirectory.getDevice() != null) {
            workingDir = "/" + workingDir.replace(':', '/');
        }
        this.parseEnvironment(env);
        Map origEnv = null;
        boolean supportStdin = false;
        boolean privilegedMode = false;
        ContainerLauncher launcher = new ContainerLauncher();
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.docker.launcher");
        boolean keepContainer = prefs.getBoolean("keepContainerAfterLaunch", false);
        ICConfigurationDescription cfgd = CoreModel.getDefault().getProjectDescription(this.fProject).getActiveConfiguration();
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
        if (cfg == null) {
            return null;
        }
        IOptionalBuildProperties props = cfg.getOptionalBuildProperties();
        String selectedVolumeString = props.getProperty(SELECTED_VOLUMES_ID);
        if (selectedVolumeString != null && !selectedVolumeString.isEmpty()) {
            String[] selectedVolumes = selectedVolumeString.split(VOLUME_SEPARATOR_REGEX);
            if (Platform.getOS().equals("win32")) {
                String[] stringArray2 = selectedVolumes;
                int n4 = selectedVolumes.length;
                int n5 = 0;
                while (n5 < n4) {
                    String selectedVolume = stringArray2[n5];
                    Path path = new Path(selectedVolume);
                    String selectedPath = path.toPortableString();
                    if (path.getDevice() != null) {
                        selectedPath = "/" + selectedPath.replace(':', '/');
                    }
                    additionalDirs.add(selectedPath);
                    ++n5;
                }
            } else {
                additionalDirs.addAll(Arrays.asList(selectedVolumes));
            }
        }
        if ((connectionName = props.getProperty(CONNECTION_ID)) == null) {
            return null;
        }
        String imageName = props.getProperty(IMAGE_ID);
        if (imageName == null) {
            return null;
        }
        this.setImageName(imageName);
        this.fProcess = launcher.runCommand(connectionName, imageName, this.fProject, (IErrorMessageHolder)this, command, commandDir, workingDir, additionalDirs, origEnv, this.fEnvironment, supportStdin, privilegedMode, labels, keepContainer);
        return this.fProcess;
    }

    private void parseEnvironment(String[] env) {
        this.fEnvironment = null;
        if (env != null) {
            this.fEnvironment = new Properties();
            String[] stringArray = env;
            int n = env.length;
            int n2 = 0;
            while (n2 < n) {
                String envStr = stringArray[n2];
                int pos = envStr.indexOf(61);
                if (pos < 0) {
                    pos = envStr.length();
                }
                String key = envStr.substring(0, pos);
                String value = envStr.substring(pos + 1);
                this.fEnvironment.put(key, value);
                ++n2;
            }
        }
    }

    public int waitAndRead(OutputStream out, OutputStream err) {
        this.printImageHeader(out);
        if (this.fShowCommand) {
            this.printCommandLine(out);
        }
        if (this.fProcess == null) {
            return -1;
        }
        ProcessClosure closure = new ProcessClosure(this.fProcess, out, err);
        closure.runBlocking();
        return 0;
    }

    public int waitAndRead(OutputStream output, OutputStream err, IProgressMonitor monitor) {
        this.printImageHeader(output);
        if (this.fShowCommand) {
            this.printCommandLine(output);
        }
        if (this.fProcess == null) {
            return -1;
        }
        ProcessClosure closure = new ProcessClosure(this.fProcess, output, err);
        closure.runNonBlocking();
        Runnable watchProcess = () -> {
            try {
                this.fProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            closure.terminate();
        };
        Thread t = new Thread(watchProcess);
        t.start();
        while (!monitor.isCanceled() && closure.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        try {
            t.join(500L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        int state = 0;
        if (monitor.isCanceled()) {
            closure.terminate();
            state = 1;
            this.setErrorMessage(Messages.CommandLauncher_CommandCancelled);
        }
        try {
            this.fProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        monitor.done();
        return state;
    }

    protected void printImageHeader(OutputStream os) {
        if (os != null) {
            try {
                os.write(NLS.bind((String)Messages.ContainerCommandLauncher_image_msg, (Object)((ContainerCommandProcess)this.fProcess).getImage()).getBytes());
                os.write(NEWLINE.getBytes());
                os.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void printCommandLine(OutputStream os) {
        if (os != null) {
            try {
                os.write(this.getCommandLineQuoted(this.getCommandArgs(), true).getBytes());
                os.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getCommandLineQuoted(String[] commandArgs, boolean quote) {
        StringBuilder buf = new StringBuilder();
        if (commandArgs != null) {
            String[] stringArray = commandArgs;
            int n = commandArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String commandArg = stringArray[n2];
                if (quote && (commandArg.contains(" ") || commandArg.contains("\"") || commandArg.contains("\\"))) {
                    commandArg = String.valueOf('\"') + commandArg.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"") + '\"';
                }
                buf.append(commandArg);
                buf.append(' ');
                ++n2;
            }
            buf.append(NEWLINE);
        }
        return buf.toString();
    }

    protected String getCommandLine(String[] commandArgs) {
        return this.getCommandLineQuoted(commandArgs, false);
    }
}

