/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.nodeselection;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelectionProvider;
import org.eclipse.buildship.ui.util.nodeselection.SelectionSpecificAction;
import org.eclipse.buildship.ui.view.NoActionsAvailableAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;

public final class ActionShowingContextMenuListener
implements IMenuListener {
    private final NodeSelectionProvider selectionProvider;
    private final ImmutableList<SelectionSpecificAction> actions;
    private final ImmutableList<? extends SelectionSpecificAction> actionsPrecededBySeparator;
    private final ImmutableList<? extends SelectionSpecificAction> actionsSucceededBySeparator;

    public ActionShowingContextMenuListener(NodeSelectionProvider selectionProvider, List<? extends SelectionSpecificAction> actions, List<? extends SelectionSpecificAction> actionsPrecededBySeparator, List<? extends SelectionSpecificAction> actionsSucceededBySeparator) {
        this.selectionProvider = (NodeSelectionProvider)Preconditions.checkNotNull((Object)selectionProvider);
        this.actions = ImmutableList.copyOf(actions);
        this.actionsPrecededBySeparator = ImmutableList.copyOf(actionsPrecededBySeparator);
        this.actionsSucceededBySeparator = ImmutableList.copyOf(actionsSucceededBySeparator);
    }

    public void menuAboutToShow(IMenuManager manager) {
        NodeSelection selection = this.selectionProvider.getSelection();
        this.handleSelection(manager, selection);
    }

    private void handleSelection(IMenuManager manager, NodeSelection selection) {
        boolean isContextMenuEmpty = true;
        for (SelectionSpecificAction action : this.actions) {
            if (!action.isVisibleFor(selection)) continue;
            isContextMenuEmpty = false;
            if (this.actionsPrecededBySeparator.contains((Object)action)) {
                manager.add((IContributionItem)new Separator());
            }
            action.setEnabledFor(selection);
            manager.add((IAction)action);
            if (!this.actionsSucceededBySeparator.contains((Object)action)) continue;
            manager.add((IContributionItem)new Separator());
        }
        if (isContextMenuEmpty) {
            manager.add((IAction)new NoActionsAvailableAction());
        }
    }
}

