/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.CellDragoicator;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ColumnDragTracker;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.RowDragTracker;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.tools.ResizeTracker;

public class TableCellDragHandle
extends AbstractHandle {
    private int cursorDirection = 0;
    private int start;
    private int end;

    public TableCellDragHandle(TableCellEditPart owner, int direction, int start, int end) {
        this.setOwner((GraphicalEditPart)owner);
        this.setLocator(new CellDragoicator(owner.getFigure(), direction));
        this.setCursor(Cursors.getDirectionalCursor((int)direction, (boolean)owner.getFigure().isMirrored()));
        this.cursorDirection = direction;
        this.setOpaque(false);
        this.start = start;
        this.end = end;
    }

    protected DragTracker createDragTracker() {
        if (this.cursorDirection == 16) {
            return new ColumnDragTracker(this.getOwner().getParent(), this.start, this.end);
        }
        if (this.cursorDirection == 4) {
            return new RowDragTracker(this.getOwner().getParent(), this.start, this.end);
        }
        return new ResizeTracker(this.getOwner(), this.cursorDirection){

            protected void showTargetFeedback() {
            }

            protected void eraseTargetFeedback() {
            }

            protected void showSourceFeedback() {
            }

            protected void eraseSourceFeedback() {
            }

            protected Command getCommand() {
                return UnexecutableCommand.INSTANCE;
            }
        };
    }

    public void paintFigure(Graphics g) {
    }

    public boolean containsPoint(int x, int y) {
        return this.getBounds().getCopy().shrink(-1, -1).contains(x, y);
    }

    public void setBounds(Rectangle rect) {
        if (this.start == this.end && this.cursorDirection == 4) {
            rect.y -= rect.height;
        } else if (this.start == this.end && this.cursorDirection == 16) {
            rect.x -= rect.width;
        }
        super.setBounds(rect);
    }
}

