/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class AP2946
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;

    public AP2946(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            boolean mimeContentsFound = false;
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List ops = binding.getBindingOperations();
            int i = 0;
            while (i < ops.size()) {
                BindingOperation bindingOperation = (BindingOperation)ops.get(i);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                List inputMimeContents = this.getMimeContentElements(bindingInput == null ? null : bindingInput.getExtensibilityElements());
                List outputMimeContents = this.getMimeContentElements(bindingOutput == null ? null : bindingOutput.getExtensibilityElements());
                if (!inputMimeContents.isEmpty()) {
                    mimeContentsFound = true;
                    if (this.hasInvalidMimeContent(inputMimeContents)) {
                        throw new AssertionFailException("The invalid mime:content element is in the wsdl:input of the \"" + bindingOperation.getName() + "\" binding operation.");
                    }
                }
                if (!outputMimeContents.isEmpty()) {
                    mimeContentsFound = true;
                    if (this.hasInvalidMimeContent(outputMimeContents)) {
                        throw new AssertionFailException("The invalid mime:content element is in the wsdl:output of the \"" + bindingOperation.getName() + "\" binding operation.");
                    }
                }
                ++i;
            }
            if (!mimeContentsFound) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private List getMimeContentElements(List extElems) {
        ArrayList<ExtensibilityElement> mimeContentElements = new ArrayList<ExtensibilityElement>();
        if (extElems != null) {
            int i = 0;
            while (i < extElems.size()) {
                ExtensibilityElement extElem = (ExtensibilityElement)extElems.get(i);
                if (extElem.getElementType().equals(WSDL_MIME_MULTIPART)) {
                    List mimeParts = ((MIMEMultipartRelated)extElem).getMIMEParts();
                    int j = 0;
                    while (j < mimeParts.size()) {
                        List elems = this.getMimeContentElements(((MIMEPart)mimeParts.get(j)).getExtensibilityElements());
                        mimeContentElements.addAll(elems);
                        ++j;
                    }
                } else if (extElem.getElementType().equals(WSDL_MIME_CONTENT)) {
                    mimeContentElements.add(extElem);
                }
                ++i;
            }
        }
        return mimeContentElements;
    }

    private boolean hasInvalidMimeContent(List mimeContents) {
        int i = 0;
        while (i < mimeContents.size()) {
            if (((MIMEContent)mimeContents.get(i)).getPart() == null) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

