/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.form;

import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableDialog;
import org.eclipse.wb.internal.swt.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetSelectDialog<C extends IAbstractComponentInfo>
extends ResizableDialog {
    private final List<C> m_widgets;
    private final String m_dialogTitle;
    private final String m_listTitle;
    private final String m_columnTitle;
    private TableViewer m_viewer;
    private C m_defaultSelectedWidget;
    private C m_selectedWidget;

    public WidgetSelectDialog(Shell parentShell, List<C> widgets, String dialogTitle, String listTitle, String columnTitle) {
        super(parentShell, (AbstractUIPlugin)Activator.getDefault());
        this.m_widgets = widgets;
        this.m_dialogTitle = dialogTitle;
        this.m_listTitle = listTitle;
        this.m_columnTitle = columnTitle;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().forceFocus();
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.create((Composite)area).spacingV(2);
        Label titleLabel = new Label(area, 0);
        titleLabel.setText(this.m_listTitle);
        GridDataFactory.create((Control)titleLabel).grabH().fillH();
        this.m_viewer = new TableViewer(area, 67584);
        this.m_viewer.setContentProvider((IContentProvider)new ControlContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new ControlLabelProvider());
        Table table = this.m_viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridDataFactory.create((Control)table).grab().fill();
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(400);
        tableColumn.setText(this.m_columnTitle);
        this.m_viewer.setInput(new Object());
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WidgetSelectDialog.this.updateButtons();
            }
        });
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WidgetSelectDialog.this.okPressed();
            }
        });
        table.setFocus();
        table.select(0);
        return area;
    }

    protected Control createContents(Composite parent) {
        Control dialogContents = super.createContents(parent);
        if (this.m_defaultSelectedWidget != null) {
            this.m_viewer.setSelection((ISelection)new StructuredSelection(this.m_defaultSelectedWidget));
        }
        return dialogContents;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_dialogTitle);
    }

    protected void okPressed() {
        this.m_selectedWidget = (IAbstractComponentInfo)this.getViewerSelection().getFirstElement();
        super.okPressed();
    }

    private void updateButtons() {
        this.getButton(0).setEnabled(!this.getViewerSelection().isEmpty());
    }

    private IStructuredSelection getViewerSelection() {
        return (IStructuredSelection)this.m_viewer.getSelection();
    }

    public void setDefaultSelectedWidget(C defaultSelectedWidget) {
        this.m_defaultSelectedWidget = defaultSelectedWidget;
    }

    public C getSelectedWidget() {
        return this.m_selectedWidget;
    }

    private class ControlContentProvider
    implements IStructuredContentProvider {
        private ControlContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return WidgetSelectDialog.this.m_widgets.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ControlLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ControlLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            IAbstractComponentInfo info = (IAbstractComponentInfo)element;
            try {
                return info.getPresentation().getText();
            }
            catch (Throwable e) {
                throw ReflectionUtils.propagate((Throwable)e);
            }
        }

        public Image getColumnImage(Object element, int columnIndex) {
            IAbstractComponentInfo info = (IAbstractComponentInfo)element;
            try {
                return info.getPresentation().getIcon();
            }
            catch (Throwable e) {
                throw ReflectionUtils.propagate((Throwable)e);
            }
        }
    }
}

