/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class WipeEngineHandler extends AbstractHandler {
  @Override
  public Object execute(final ExecutionEvent event) throws ExecutionException {
    IWorkbenchSite _activeSite = HandlerUtil.getActiveSite(event);
    IWorkbenchPage _page = _activeSite.getPage();
    final IViewPart resultView = _page.findView(QueryResultView.ID);
    if ((resultView instanceof QueryResultView)) {
      QueryResultView queryResultView = ((QueryResultView) resultView);
      queryResultView.wipeEngine();
    }
    return null;
  }
}
