/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.editor.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.editor.UMLEditorPlugin;
import org.eclipse.uml2.uml.editor.actions.UMLCommandAction;
import org.eclipse.uml2.uml.editor.dialogs.AbstractChoicesDialogDelegate;
import org.eclipse.uml2.uml.editor.dialogs.ChoicesDialog;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyStereotypeAction
extends UMLCommandAction {
    protected Command createActionCommand(EditingDomain editingDomain, Collection<?> collection) {
        if (collection.size() == 1 && collection.iterator().next() instanceof Element) {
            return IdentityCommand.INSTANCE;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void run(IAction action) {
        if (this.command != UnexecutableCommand.INSTANCE) {
            final Element element = (Element)this.collection.iterator().next();
            ArrayList<Stereotype> choiceOfValues = new ArrayList<Stereotype>();
            for (Stereotype applicableStereotype : element.getApplicableStereotypes()) {
                if (element.isStereotypeApplied(applicableStereotype)) continue;
                choiceOfValues.add(applicableStereotype);
            }
            Collections.sort(choiceOfValues, new UMLCommandAction.TextComparator(this));
            String label = UMLEditorPlugin.INSTANCE.getString("_UI_ApplyStereotypeActionCommand_label");
            final ChoicesDelegate chooserDelegate = new ChoicesDelegate(element, choiceOfValues);
            final ChoicesDialog<Stereotype> dialog = new ChoicesDialog<Stereotype>(this.workbenchPart.getSite().getShell(), element, label, chooserDelegate);
            dialog.open();
            if (dialog.getReturnCode() == 0 && !dialog.getResult().isEmpty()) {
                this.editingDomain.getCommandStack().execute((Command)new UMLCommandAction.RefreshingChangeCommand(this, this.editingDomain, new Runnable(){

                    public void run() {
                        UMLUtil.StereotypeApplicationHelper helper = chooserDelegate.getSelectedResource() == null ? null : new UMLUtil.StereotypeApplicationHelper(){

                            protected EList<EObject> getContainmentList(Element element, EClass definition) {
                                return chooserDelegate.getSelectedResource().getContents();
                            }
                        };
                        for (Stereotype result : dialog.getResult()) {
                            EObject newApplication = element.applyStereotype(result);
                            if (helper == null) continue;
                            helper.addToContainmentList(element, newApplication);
                        }
                    }
                }, label));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ChoicesDelegate
    extends AbstractChoicesDialogDelegate<Stereotype> {
        private ComboViewer resourceCombo;
        private EList<Object> resourcesList;
        private final Element element;
        private final Collection<Stereotype> applicableStereotypes;
        private Resource selectedResource;

        ChoicesDelegate(Element element, Collection<Stereotype> applicableStereotypes) {
            super(Stereotype.class);
            this.element = element;
            this.applicableStereotypes = applicableStereotypes;
        }

        public Resource getSelectedResource() {
            Resource result = this.selectedResource;
            if (result == this.element.eResource()) {
                result = null;
            }
            return result;
        }

        @Override
        public String getChoicesLabelText() {
            return UMLEditorPlugin.INSTANCE.getString("_UI_ApplicableStereotypes_label");
        }

        @Override
        public String getValuesLabelText() {
            return UMLEditorPlugin.INSTANCE.getString("_UI_StereotypesToApply_label");
        }

        @Override
        public String getAddButtonText() {
            return UMLEditorPlugin.INSTANCE.getString("_UI_Apply_label");
        }

        @Override
        public String getRemoveButtonText() {
            return UMLEditorPlugin.INSTANCE.getString("_UI_Unapply_label");
        }

        @Override
        public ILabelProvider getLabelProvider() {
            return ApplyStereotypeAction.this.getLabelProvider();
        }

        @Override
        public Collection<Stereotype> getChoiceOfValues() {
            return this.applicableStereotypes;
        }

        @Override
        public void createAdditionalControls(Composite parent) {
            Composite contents = new Composite(parent, 0);
            contents.setLayout((Layout)new GridLayout(2, false));
            new Label(contents, 0).setText(UMLEditorPlugin.INSTANCE.getString("_UI_StereotypesResource_label"));
            this.resourceCombo = new ComboViewer(contents, 12);
            this.resourceCombo.getControl().setLayoutData((Object)new GridData(768));
            this.resourceCombo.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
            this.resourceCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
            final Resource defaultResource = this.computeDefaultResource();
            ResourceSet rset = defaultResource.getResourceSet();
            this.resourcesList = new BasicEList(rset.getResources().size() + 1);
            for (Resource next : rset.getResources()) {
                if (ApplyStereotypeAction.this.editingDomain.isReadOnly(next)) continue;
                this.resourcesList.add((Object)next);
            }
            this.resourcesList.move(0, (Object)defaultResource);
            this.resourcesList.add((Object)this.createLoadExistingResourceAction());
            this.resourcesList.add((Object)this.createCreateNewResourceAction());
            this.resourceCombo.setInput(this.resourcesList);
            this.resourceCombo.setSelection((ISelection)new StructuredSelection((Object)defaultResource));
            this.selectedResource = defaultResource;
            this.resourceCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection().isEmpty()) {
                        ChoicesDelegate.this.selectedResource = defaultResource;
                    } else {
                        Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                        if (selected instanceof Resource) {
                            ChoicesDelegate.this.selectedResource = (Resource)selected;
                        } else {
                            ((IAction)selected).run();
                        }
                    }
                }
            });
        }

        private Resource computeDefaultResource() {
            Resource result = null;
            for (EObject next : this.element.getStereotypeApplications()) {
                Resource res = next.eResource();
                if (result == null) {
                    result = res;
                    continue;
                }
                if (res == result) continue;
                result = null;
                break;
            }
            if (result == null) {
                result = this.element.eResource();
            }
            return result;
        }

        private IAction createLoadExistingResourceAction() {
            return new LoadOtherResourceAction(UMLEditorPlugin.INSTANCE.getString("_UI_StereotypesResource_existing_label")){

                protected Resource openDialog(Shell parentShell, final ResourceSet rset, URI contextURI) {
                    ResourceDialog dlg = new ResourceDialog(ChoicesDelegate.this.resourceCombo.getControl().getShell(), UMLEditorPlugin.INSTANCE.getString("_UI_StereotypesResource_existingDialog_label"), 4100, contextURI){

                        protected boolean processResources() {
                            URI selectedURI;
                            Resource resource;
                            block6: {
                                block5: {
                                    resource = null;
                                    try {
                                        if (!this.getURIs().isEmpty()) break block5;
                                        return true;
                                    }
                                    catch (Exception e) {
                                        MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)UMLEditorPlugin.INSTANCE.getString("_UI_StereotypesResource_loadFailed_message"));
                                        UMLEditorPlugin.INSTANCE.log(e);
                                        return false;
                                    }
                                }
                                selectedURI = (URI)this.getURIs().get(0);
                                if (rset.getURIConverter().exists(selectedURI, null)) break block6;
                                MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)UMLEditorPlugin.INSTANCE.getString("_UI_StereotypesResource_notExists_message"));
                                return false;
                            }
                            resource = rset.getResource(selectedURI, true);
                            if (ApplyStereotypeAction.this.editingDomain.isReadOnly(resource)) {
                                MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_ReadOnlyResource"));
                                return false;
                            }
                            return resource != null;
                        }
                    };
                    Resource result = null;
                    if (dlg.open() == 0 && !dlg.getURIs().isEmpty()) {
                        URI newURI = (URI)dlg.getURIs().get(0);
                        result = rset.getResource(newURI, true);
                    }
                    return result;
                }

                public String toString() {
                    return this.getText();
                }
            };
        }

        private IAction createCreateNewResourceAction() {
            return new LoadOtherResourceAction(UMLEditorPlugin.INSTANCE.getString("_UI_StereotypesResource_new_label")){

                protected Resource openDialog(Shell parentShell, final ResourceSet rset, URI contextURI) {
                    ResourceDialog dlg = new ResourceDialog(ChoicesDelegate.this.resourceCombo.getControl().getShell(), UMLEditorPlugin.INSTANCE.getString("_UI_StereotypesResource_newDialog_label"), 8196, contextURI){

                        protected boolean processResources() {
                            URI selectedURI;
                            Resource resource;
                            block6: {
                                block5: {
                                    resource = null;
                                    try {
                                        if (!this.getURIs().isEmpty()) break block5;
                                        return true;
                                    }
                                    catch (Exception e) {
                                        MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)UMLEditorPlugin.INSTANCE.getString("_UI_StereotypesResource_createFailed_message"));
                                        UMLEditorPlugin.INSTANCE.log(e);
                                        return false;
                                    }
                                }
                                selectedURI = (URI)this.getURIs().get(0);
                                if (!rset.getURIConverter().exists(selectedURI, null)) break block6;
                                MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)UMLEditorPlugin.INSTANCE.getString("_UI_StereotypesResource_exists_message"));
                                return false;
                            }
                            resource = rset.createResource(selectedURI, "");
                            if (resource != null) {
                                resource.getContents().clear();
                            }
                            return resource != null;
                        }
                    };
                    Resource result = null;
                    if (dlg.open() == 0 && !dlg.getURIs().isEmpty()) {
                        URI newURI = (URI)dlg.getURIs().get(0);
                        result = rset.getResource(newURI, true);
                    }
                    return result;
                }

                public String toString() {
                    return this.getText();
                }
            };
        }

        private abstract class LoadOtherResourceAction
        extends Action {
            LoadOtherResourceAction(String label) {
                super(label);
            }

            public void run() {
                ResourceSet rset = ChoicesDelegate.this.element.eResource().getResourceSet();
                URI contextURI = null;
                if (ChoicesDelegate.this.selectedResource != null && ChoicesDelegate.this.selectedResource.getURI().isPlatformResource()) {
                    contextURI = ChoicesDelegate.this.selectedResource.getURI();
                }
                Resource newResource = null;
                try {
                    newResource = this.openDialog(ChoicesDelegate.this.resourceCombo.getControl().getShell(), rset, contextURI);
                }
                catch (Exception e) {
                    UMLEditorPlugin.INSTANCE.log(e);
                }
                if (newResource != null) {
                    ChoicesDelegate.this.resourcesList.add(1, (Object)newResource);
                    ChoicesDelegate.this.resourceCombo.refresh();
                } else {
                    newResource = ChoicesDelegate.this.selectedResource;
                }
                ChoicesDelegate.this.resourceCombo.setSelection((ISelection)new StructuredSelection((Object)newResource));
                ChoicesDelegate.this.selectedResource = newResource;
                ChoicesDelegate.this.applicableStereotypes.removeAll((Collection<?>)ChoicesDelegate.this.element.getAppliedStereotypes());
                ChoicesDelegate.this.getDialog().updateChoiceOfValues();
            }

            protected abstract Resource openDialog(Shell var1, ResourceSet var2, URI var3);

            public String toString() {
                return this.getText();
            }
        }
    }
}

