/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.building.LttngKernelExecGraphProvider;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.BaseHandler;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.Messages;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.EventField;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.LttngSystemModel;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.LttngWorker;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class TraceEventHandlerStatedump
extends BaseHandler {
    public TraceEventHandlerStatedump(LttngKernelExecGraphProvider provider) {
        super(provider);
    }

    @Override
    public void handleEvent(ITmfEvent event) {
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        LttngSystemModel system = this.getProvider().getSystem();
        String eventName = event.getName();
        if (!eventName.equals(eventLayout.eventStatedumpProcessState())) {
            return;
        }
        Integer tid = EventField.getInt(event, eventLayout.fieldTid());
        String name = EventField.getOrDefault(event, eventLayout.fieldName(), NonNullUtils.nullToEmptyString((Object)Messages.TraceEventHandlerSched_UnknownThreadName));
        Integer status = EventField.getInt(event, eventLayout.fieldStatus());
        String host = event.getTrace().getHostId();
        long ts = event.getTimestamp().getValue();
        HostThread ht = new HostThread(host, tid);
        LttngWorker task = system.findWorker(ht);
        if (task == null) {
            task = new LttngWorker(ht, name, ts);
            system.addWorker(task);
        } else {
            task.setName(name);
        }
        task.setStatus(LttngKernelExecGraphProvider.ProcessStatus.getStatus(status.intValue()));
    }
}

