/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.properties;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IResourcePropertyProvider;
import org.eclipse.team.svn.core.operation.local.property.GetPropertiesOperation;
import org.eclipse.team.svn.core.operation.remote.GetRemotePropertiesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.AbstractSVNView;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.PropertiesComposite;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class PropertiesView
extends AbstractSVNView {
    public static final String VIEW_ID = PropertiesView.class.getName();
    protected PropertiesComposite propertiesComposite;
    protected IResourcePropertyProvider propertyProvider;
    protected IAdaptable adaptable;
    protected Action linkWithEditorAction;
    protected Action linkWithEditorDropDownAction;
    protected boolean backgroundExecution;

    public PropertiesView() {
        super(SVNUIMessages.PropertiesView_Description);
    }

    public void setFocus() {
    }

    public void setResource(IAdaptable resource, IResourcePropertyProvider propertyProvider, boolean backgroundExecution) {
        if (resource instanceof IRepositoryResource) {
            this.repositoryResource = (IRepositoryResource)resource;
            this.wcResource = null;
        } else if (resource instanceof IResource) {
            this.wcResource = (IResource)resource;
            this.repositoryResource = null;
        }
        this.adaptable = resource;
        this.propertyProvider = propertyProvider;
        this.backgroundExecution = backgroundExecution;
        this.propertiesComposite.setResource(resource, propertyProvider);
        this.refresh();
    }

    public void refresh() {
        boolean operationToFollow = this.propertyProvider != null && this.propertyProvider.getExecutionState() != 0;
        this.propertiesComposite.setPending(operationToFollow);
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                PropertiesView.this.showResourceLabel();
                PropertiesView.this.propertiesComposite.initializeComposite();
            }
        });
        CompositeOperation composite = new CompositeOperation("Operation_ShowProperties", SVNUIMessages.class);
        if (this.propertyProvider != null && this.propertyProvider.getExecutionState() != 0) {
            composite.add((IActionOperation)this.propertyProvider);
            composite.add(this.propertiesComposite.getRefreshViewOperation(), new IActionOperation[]{this.propertyProvider});
        } else {
            composite.add(this.propertiesComposite.getRefreshViewOperation());
        }
        if (this.backgroundExecution) {
            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)composite);
        } else {
            UIMonitorUtility.doTaskScheduledDefault((IWorkbenchPart)this, (IActionOperation)composite);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        this.isLinkWithEditorEnabled = SVNTeamPreferences.getPropertiesBoolean(store, "linkWithEditor");
        this.propertiesComposite = new PropertiesComposite(parent);
        this.propertiesComposite.setLayoutData(new GridData(1808));
        this.propertiesComposite.setPropertiesView(this);
        this.refresh();
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager actionBarsMenu = actionBars.getMenuManager();
        this.linkWithEditorDropDownAction = new Action(SVNUIMessages.SVNView_LinkWith_Label, 2){

            public void run() {
                PropertiesView.this.linkWithEditor();
                PropertiesView.this.linkWithEditorAction.setChecked(PropertiesView.this.isLinkWithEditorEnabled);
            }
        };
        this.linkWithEditorDropDownAction.setChecked(this.isLinkWithEditorEnabled);
        actionBarsMenu.add((IAction)this.linkWithEditorDropDownAction);
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.removeAll();
        Action action = new Action(SVNUIMessages.SVNView_Refresh_Label){

            public void run() {
                PropertiesView.this.refreshAction();
            }
        };
        action.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/refresh.gif"));
        tbm.add((IAction)action);
        tbm.add((IAction)this.getLinkWithEditorAction());
        tbm.update(true);
        this.getSite().getPage().addSelectionListener(this.selectionListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.propertiesViewContext");
    }

    protected void disconnectView() {
        this.propertiesComposite.disconnectComposite();
        this.wcResource = null;
    }

    protected void refreshAction() {
        if (this.repositoryResource != null) {
            this.propertyProvider = new GetRemotePropertiesOperation(this.repositoryResource);
            this.propertiesComposite.setResource(this.adaptable, this.propertyProvider);
        }
        this.refresh();
    }

    protected Action getLinkWithEditorAction() {
        this.linkWithEditorAction = new Action(SVNUIMessages.SVNView_LinkWith_Label, 2){

            public void run() {
                PropertiesView.this.linkWithEditor();
                PropertiesView.this.linkWithEditorDropDownAction.setChecked(PropertiesView.this.isLinkWithEditorEnabled);
            }
        };
        this.linkWithEditorAction.setToolTipText(SVNUIMessages.SVNView_LinkWith_ToolTip);
        this.linkWithEditorAction.setDisabledImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/link_with_disabled.gif"));
        this.linkWithEditorAction.setHoverImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/link_with.gif"));
        this.linkWithEditorAction.setChecked(this.isLinkWithEditorEnabled);
        return this.linkWithEditorAction;
    }

    protected void linkWithEditor() {
        this.isLinkWithEditorEnabled = !this.isLinkWithEditorEnabled;
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        SVNTeamPreferences.setPropertiesBoolean(store, "linkWithEditor", this.isLinkWithEditorEnabled);
        if (this.isLinkWithEditorEnabled) {
            this.editorActivated(this.getSite().getPage().getActiveEditor());
        }
    }

    protected void updateViewInput(IRepositoryResource resource) {
        if (this.repositoryResource != null && this.repositoryResource.equals(resource)) {
            return;
        }
        if (resource != null) {
            this.setResource((IAdaptable)resource, (IResourcePropertyProvider)new GetRemotePropertiesOperation(resource), true);
        }
    }

    protected void updateViewInput(IResource resource) {
        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
        if (IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED.accept(local)) {
            if (local.getResource().equals((Object)this.wcResource)) {
                return;
            }
            this.setResource((IAdaptable)resource, (IResourcePropertyProvider)new GetPropertiesOperation(resource), true);
        }
    }

    protected boolean needsLinkWithEditorAndSelection() {
        return true;
    }
}

