/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.SpellcheckedTextProvider;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.extension.factory.ICommentManager;
import org.eclipse.team.svn.ui.panel.IDialogManager;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.properties.bugtraq.BugtraqModel;
import org.eclipse.team.svn.ui.utility.UserInputHistory;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;
import org.eclipse.team.svn.ui.verifier.CommentVerifier;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.IValidationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentComposite
extends Composite
implements ICommentManager {
    public static String TEMPORARY_COMMENT = null;
    protected static final String COMMENT_HISTORY_NAME = "comment";
    protected StyledText text;
    protected Text bugIdText;
    protected String message;
    protected String bugID;
    protected UserInputHistory history;
    protected Set logTemplates;
    protected Set ignoredStrings;
    protected BugtraqModel bugtraqModel;
    protected int minLogSize;
    protected int maxLogWidth;
    protected IValidationManager validationManager;
    protected IDialogManager dialogManager;
    protected Map<String, String> sections = new LinkedHashMap<String, String>();
    protected Map<String, List<String>> sectionComments = new LinkedHashMap<String, List<String>>();

    public CommentComposite(Composite parent, IValidationManager validationManager) {
        this(parent, validationManager, null);
    }

    public CommentComposite(Composite parent, IValidationManager validationManager, Set logTemplates) {
        this(parent, null, validationManager, logTemplates, null);
    }

    public CommentComposite(Composite parent, String message, IValidationManager validationManager, Set logTemplates, BugtraqModel bugtraqModel) {
        this(parent, message, validationManager, logTemplates, null, 0);
    }

    public CommentComposite(Composite parent, String message, IValidationManager validationManager, Set logTemplates, BugtraqModel bugtraqModel, int minLogSize) {
        this(parent, message, validationManager, logTemplates, null, minLogSize, 0);
    }

    public CommentComposite(Composite parent, String message, IValidationManager validationManager, Set logTemplates, BugtraqModel bugtraqModel, int minLogSize, int maxLogWidth) {
        super(parent, 0);
        this.message = message;
        this.validationManager = validationManager;
        this.logTemplates = logTemplates;
        this.ignoredStrings = new HashSet();
        this.bugtraqModel = bugtraqModel;
        this.minLogSize = minLogSize;
        this.maxLogWidth = maxLogWidth;
        this.createControls();
    }

    @Override
    public String getTemporarySavedComment() {
        return TEMPORARY_COMMENT;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
        if (this.text != null) {
            this.text.setText(message);
        }
    }

    public String getBugID() {
        return this.bugID;
    }

    public void insertText(String text) {
        this.text.insert(text);
    }

    public void saveChanges() {
        this.message = this.text.getText();
        this.history.addLine(this.message);
        TEMPORARY_COMMENT = null;
        if (this.bugIdText != null) {
            this.bugID = this.bugIdText.getText();
        }
        ExtensionsManager.getInstance().getCurrentCommitFactory().confirmMessage(this);
    }

    public void cancelChanges() {
        TEMPORARY_COMMENT = this.text.getText().trim().length() == 0 ? null : this.text.getText();
        ExtensionsManager.getInstance().getCurrentCommitFactory().cancelMessage(this);
    }

    private void createControls() {
        Label label;
        GridData data = null;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        final Text[] tBugIdTextA = new Text[1];
        if (this.bugtraqModel != null && (this.bugtraqModel.getMessage() != null || this.bugtraqModel.getLogregex() != null)) {
            Composite bugtraqComposite = new Composite((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            bugtraqComposite.setLayout((Layout)layout);
            bugtraqComposite.setLayoutData((Object)new GridData(768));
            label = new Label(bugtraqComposite, 0);
            label.setLayoutData((Object)new GridData(1));
            label.setText(this.bugtraqModel.getLabel());
            if (this.bugtraqModel.getLogregex() == null) {
                this.bugIdText = new Text(bugtraqComposite, 2052);
                this.bugIdText.setLayoutData((Object)new GridData(768));
                this.bugIdText.setFocus();
                this.validationManager.attachTo((Control)this.bugIdText, new AbstractVerifier(){

                    protected String getErrorMessage(Control input) {
                        String bugId = this.getText(input);
                        if (bugId.length() > 0 && CommentComposite.this.bugtraqModel.isNumber() && !bugId.matches("[0-9]+(\\s*,\\s*?[0-9]+)*")) {
                            return SVNUIMessages.format((String)SVNUIMessages.CommentComposite_BugID_Verifier_Error_Number, (Object[])new String[]{CommentComposite.this.bugtraqModel.getLabel()});
                        }
                        return null;
                    }

                    protected String getWarningMessage(Control input) {
                        if (CommentComposite.this.bugtraqModel.isWarnIfNoIssue() && this.getText(input).length() == 0) {
                            return SVNUIMessages.CommentComposite_BugID_Verifier_Warning;
                        }
                        return null;
                    }
                });
            } else {
                Text tBugIdText = new Text(bugtraqComposite, 2060);
                tBugIdText.setLayoutData((Object)new GridData(768));
                tBugIdTextA[0] = tBugIdText;
            }
        }
        data = new GridData(1808);
        data.heightHint = 80;
        this.text = SpellcheckedTextProvider.getTextWidget(this, 834, data, this.maxLogWidth);
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (!SVNTeamPreferences.getCommentTemplatesBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "useShiftEnter") && (e.stateMask & 0x20000) != 0 && e.detail == 4) {
                    e.doit = false;
                } else if (e.character == '\t') {
                    e.doit = true;
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommentComposite.this.message = CommentComposite.this.text.getText();
            }
        });
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new CommentVerifier(SVNUIMessages.CommentComposite_Comment_Verifier, this.minLogSize));
        if (this.bugtraqModel != null && this.bugtraqModel.getLogregex() != null) {
            this.text.setFocus();
            String[] logregex = this.bugtraqModel.getLogregex();
            final Pattern mainRegex = Pattern.compile(logregex[0]);
            final Pattern numberRegex = logregex.length > 1 ? Pattern.compile(logregex[1]) : (this.bugtraqModel.isNumber() ? Pattern.compile("[0-9]+(\\s*,\\s*?[0-9]+)*") : null);
            verifier.add(new AbstractVerifier(){

                protected String getErrorMessage(Control input) {
                    return null;
                }

                protected String getWarningMessage(Control input) {
                    if (CommentComposite.this.bugtraqModel.isWarnIfNoIssue()) {
                        String text = this.getText(input);
                        Matcher matcher = mainRegex.matcher(text);
                        if (matcher.find()) {
                            String bugIdEntry = matcher.group();
                            if (numberRegex != null) {
                                matcher = numberRegex.matcher(bugIdEntry);
                                String entryList = null;
                                while (matcher.find()) {
                                    String string = entryList = entryList == null ? matcher.group() : String.valueOf(entryList) + ", " + matcher.group();
                                }
                                if (entryList != null) {
                                    tBugIdTextA[0].setText(entryList);
                                    return null;
                                }
                                tBugIdTextA[0].setText("");
                                return SVNUIMessages.format((String)SVNUIMessages.CommentComposite_BugID_Verifier_Error_Text, (Object[])new String[]{CommentComposite.this.bugtraqModel.getLabel(), numberRegex.pattern()});
                            }
                            tBugIdTextA[0].setText(bugIdEntry);
                            return null;
                        }
                        tBugIdTextA[0].setText("");
                        return SVNUIMessages.CommentComposite_BugID_Verifier_Warning;
                    }
                    return null;
                }
            });
        }
        this.validationManager.attachTo((Control)this.text, verifier);
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNUIMessages.CommentComposite_ChooseComment);
        this.history = new UserInputHistory(COMMENT_HISTORY_NAME, SVNTeamPreferences.getCommentTemplatesInt(SVNTeamUIPlugin.instance().getPreferenceStore(), "savedCommentsCount"));
        final Combo previousCommentsCombo = new Combo((Composite)this, 8);
        data = new GridData(768);
        data.widthHint = 200;
        previousCommentsCombo.setLayoutData((Object)data);
        String logTemplateMessage = this.initCommentsMap();
        final List commentsList = this.getCommentsList();
        if (this.message != null && this.message.length() > 0) {
            this.text.setText(this.message);
        } else if (TEMPORARY_COMMENT != null) {
            this.text.setText(TEMPORARY_COMMENT);
        } else if (logTemplateMessage != null) {
            this.text.setText(logTemplateMessage);
        }
        this.text.selectAll();
        ArrayList<String> flattenCommentsList = new ArrayList<String>();
        Iterator iter = commentsList.iterator();
        while (iter.hasNext()) {
            flattenCommentsList.add(FileUtility.flattenText((String)((String)iter.next())));
        }
        previousCommentsCombo.setVisibleItemCount(flattenCommentsList.size());
        previousCommentsCombo.setItems(flattenCommentsList.toArray(new String[flattenCommentsList.size()]));
        previousCommentsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int idx = previousCommentsCombo.getSelectionIndex();
                if (idx != -1) {
                    String comboText = (String)commentsList.get(idx);
                    CommentComposite.this.text.setText(CommentComposite.this.ignoredStrings.contains(comboText) ? CommentComposite.this.text.getText() : comboText);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void postInit(IDialogManager dialogManager) {
        this.dialogManager = dialogManager;
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 9) {
                    CommentComposite.this.text.traverse(16);
                    event.doit = false;
                }
            }
        });
        if (this.minLogSize > 0) {
            this.validationManager.validateContent();
        }
    }

    protected String initCommentsMap() {
        String retVal = null;
        this.addCommentsSection("CommentComposite_Previous", "    " + SVNUIMessages.CommentComposite_Previous_Hint);
        this.addCommentsToSection("CommentComposite_Previous", Arrays.asList(this.history.getHistory()));
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        boolean logTemplatesEnabled = SVNTeamPreferences.getCommentTemplatesBoolean(store, "comment.logTemplates.enabled");
        boolean userTemplatesEnabled = SVNTeamPreferences.getCommentTemplatesBoolean(store, "comment.templates.enabled");
        if (userTemplatesEnabled) {
            this.addCommentsSection("CommentComposite_Template", "    " + SVNUIMessages.CommentComposite_Template_Hint);
            String[] templates = FileUtility.decodeStringToArray((String)SVNTeamPreferences.getCommentTemplatesString(store, "comment.templates"));
            this.addCommentsToSection("CommentComposite_Template", Arrays.asList(templates));
        }
        if (this.logTemplates != null && logTemplatesEnabled) {
            this.addCommentsSection("CommentComposite_LogTemplate", "    " + SVNUIMessages.CommentComposite_LogTemplate_Hint);
            this.addCommentsToSection("CommentComposite_LogTemplate", this.logTemplates);
            if (this.logTemplates.size() > 0) {
                retVal = (String)this.logTemplates.iterator().next();
            }
        }
        ExtensionsManager.getInstance().getCurrentCommitFactory().initCommentManager(this);
        return retVal;
    }

    @Override
    public void addCommentsSection(String sectionHeader, String sectionHint) {
        sectionHeader = SVNUIMessages.getString(sectionHeader);
        this.sections.put(sectionHeader, sectionHint);
        this.sectionComments.put(sectionHeader, new LinkedList());
    }

    @Override
    public void addCommentsToSection(String sectionHeader, Collection<String> templates) {
        if (this.sectionComments.containsKey(sectionHeader = SVNUIMessages.getString(sectionHeader))) {
            this.sectionComments.get(sectionHeader).addAll(templates);
        }
    }

    protected List getCommentsList() {
        ArrayList<String> commentsList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.sections.entrySet()) {
            List<String> comments = this.sectionComments.get(entry.getKey());
            if (this.sections.size() <= 1) continue;
            commentsList.add(entry.getKey());
            this.ignoredStrings.add(entry.getKey());
            if (comments.size() == 0) {
                commentsList.add(entry.getValue());
                this.ignoredStrings.add(entry.getValue());
            }
            commentsList.addAll(comments);
        }
        return commentsList;
    }
}

