/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.actions;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.graphic.actions.BaseRevisionGraphAction;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionEditPart;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.operation.OpenRemoteFileOperation;
import org.eclipse.ui.IWorkbenchPart;

public class OpenFileWithInplaceAction
extends BaseRevisionGraphAction {
    public static final String OpenFileWithInplaceAction_ID = "OpenFileWithInplace";

    public OpenFileWithInplaceAction(IWorkbenchPart part) {
        super(part);
        this.setId(OpenFileWithInplaceAction_ID);
    }

    protected boolean calculateEnabled() {
        RevisionEditPart[] editParts = null;
        if (this.getSelectedEditParts().length == 1 && (editParts = this.getSelectedEditParts(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER)).length == 1) {
            IRepositoryResource resource = BaseRevisionGraphAction.convertToResource(editParts[0]);
            return SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry().isSystemInPlaceEditorAvailable(resource.getName());
        }
        return false;
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        IRepositoryResource[] resources = BaseRevisionGraphAction.convertToResources(this.getSelectedEditParts(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER));
        ImageDescriptor imgDescriptor = resources.length > 0 ? SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getSystemExternalEditorImageDescriptor(resources[0].getName()) : null;
        this.setImageDescriptor(imgDescriptor);
    }

    public void run() {
        IRepositoryResource[] resources = BaseRevisionGraphAction.convertToResources(this.getSelectedEditParts(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER));
        this.runOperation((IActionOperation)new OpenRemoteFileOperation(new IRepositoryFile[]{(IRepositoryFile)resources[0]}, 2));
    }
}

