/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

public abstract class ResponseHandler {
    public abstract String getResponseID();

    public abstract void handle(Session var1, String var2, IProgressMonitor var3) throws CVSException;

    protected static ICVSFolder createFolder(Session session, String localDir, String repositoryDir) throws CVSException {
        ICVSFolder folder;
        block5: {
            folder = session.getLocalRoot().getFolder(localDir);
            if (!(folder.exists() || CVSProviderPlugin.getPlugin().getPruneEmptyDirectories() && folder.getParent().isCVSFolder())) {
                folder.mkdir();
            }
            if (!folder.isCVSFolder()) {
                IProject project;
                String repositoryRoot = session.getRepositoryRoot();
                String relativePath = repositoryDir.startsWith(repositoryRoot) ? Util.getRelativePath(repositoryRoot, repositoryDir) : repositoryDir;
                IResource resource = folder.getIResource();
                if (resource != null && (project = resource.getProject()) != null && project.isAccessible() && !CVSTeamProvider.isSharedWithCVS(project)) {
                    CVSTeamProvider.markAsTempShare(project);
                }
                try {
                    folder.setFolderSyncInfo(new FolderSyncInfo(relativePath, session.getCVSRepositoryLocation().getLocation(false), null, false));
                }
                catch (CVSException ex) {
                    IStatus status = ex.getStatus();
                    if (status == null || status.getCode() == 77) break block5;
                    throw ex;
                }
            }
        }
        return folder;
    }

    protected ICVSFolder getExistingFolder(Session session, String localDir) throws CVSException {
        ICVSFolder mParent;
        block3: {
            IContainer container;
            mParent = session.getLocalRoot().getFolder(localDir);
            if (!mParent.exists() && (container = (IContainer)mParent.getIResource()) != null) {
                try {
                    this.recreatePhantomFolders(mParent);
                }
                catch (CVSException e) {
                    if (this.handleInvalidResourceName(session, mParent, e)) break block3;
                    throw e;
                }
            }
        }
        return mParent;
    }

    private void recreatePhantomFolders(ICVSFolder folder) throws CVSException {
        ICVSFolder parent = folder.getParent();
        if (!parent.exists()) {
            this.recreatePhantomFolders(parent);
        }
        folder.mkdir();
    }

    ResponseHandler getInstance() {
        return this;
    }

    protected boolean handleInvalidResourceName(Session session, ICVSResource resource, CVSException e) {
        int code = e.getStatus().getCode();
        if (code == 77 || code == 278 || code == 368 || code == 367 || code == 366 || code == 275 || code == 374) {
            try {
                IResource local = resource.getIResource();
                String path = local == null ? resource.getRepositoryRelativePath() : local.getFullPath().toString();
                CVSStatus status = new CVSStatus(4, -27, NLS.bind((String)CVSMessages.ResponseHandler_0, (Object[])new String[]{path, e.getMessage()}), (Throwable)((Object)e), session.getLocalRoot());
                session.handleResponseError((IStatus)status);
            }
            catch (CVSException e1) {
                CVSProviderPlugin.log((CoreException)((Object)e1));
            }
            return true;
        }
        return false;
    }
}

