/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.rse.shells;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.terminals.AbstractTerminalShell;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.tcf.internal.rse.ITCFSessionProvider;
import org.eclipse.tcf.internal.rse.Messages;
import org.eclipse.tcf.internal.rse.TCFConnectorService;
import org.eclipse.tcf.internal.rse.TCFRSETask;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.ITerminals;
import org.eclipse.tcf.util.TCFVirtualInputStream;
import org.eclipse.tcf.util.TCFVirtualOutputStream;

public class TCFTerminalShell
extends AbstractTerminalShell {
    private final ITCFSessionProvider fSessionProvider;
    private final IChannel fChannel;
    private String fPtyType;
    private ITerminals.TerminalContext terminalContext;
    private String fEncoding;
    private InputStream fInputStream;
    private OutputStream fOutputStream;
    private Writer fOutputStreamWriter;
    private int fWidth = 0;
    private int fHeight = 0;
    private String fContextID;
    private String inp_id;
    private String out_id;
    private boolean connected;
    private boolean exited;
    private ITerminals terminals;
    private int status;
    private IPropertySet tcfPropertySet = null;
    private static String defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
    private ITerminals.TerminalsListener listeners = new ITerminals.TerminalsListener(){

        public void exited(String terminalId, int exitCode) {
            if (!TCFTerminalShell.this.terminalContext.getID().equals(terminalId)) {
                return;
            }
            TCFTerminalShell.this.terminals.removeListener(TCFTerminalShell.this.listeners);
            TCFTerminalShell.this.connected = false;
            TCFTerminalShell.this.exited = true;
        }

        public void winSizeChanged(String terminalId, int newWidth, int newHeight) {
        }
    };

    public void write(String value) {
        try {
            this.fOutputStream.write(value.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int login(String username, String password) throws InterruptedException {
        long millisToEnd = System.currentTimeMillis() + 10000L;
        LoginThread checkLogin = new LoginThread(username, password);
        this.status = 100;
        checkLogin.start();
        while (checkLogin.isAlive() && System.currentTimeMillis() < millisToEnd) {
            checkLogin.join(500L);
        }
        this.status = checkLogin.getLoginStatus();
        checkLogin.join();
        return this.status;
    }

    public TCFTerminalShell(final ITCFSessionProvider sessionProvider, final String ptyType, final String encoding, final String[] environment, String initialWorkingDirectory, String commandToRun) throws SystemMessageException {
        this.fSessionProvider = sessionProvider;
        this.fEncoding = encoding;
        this.fPtyType = ptyType;
        this.fChannel = this.fSessionProvider.getChannel();
        Exception nestedException = null;
        try {
            try {
                if (this.fChannel == null || this.fChannel.getState() != 1) {
                    throw new Exception("TCP channel is not connected!");
                }
                new TCFRSETask<ITerminals.TerminalContext>(){

                    public void run() {
                        TCFTerminalShell.this.terminals = ((TCFConnectorService)sessionProvider).getService(ITerminals.class);
                        TCFTerminalShell.this.fSessionProvider.onStreamsConnecting();
                        TCFTerminalShell.this.terminals.launch(ptyType, encoding, environment, new ITerminals.DoneLaunch(){

                            public void doneLaunch(IToken token, Exception error, ITerminals.TerminalContext ctx) {
                                if (ctx != null) {
                                    TCFTerminalShell.this.terminalContext = ctx;
                                    TCFTerminalShell.this.terminals.addListener(TCFTerminalShell.this.listeners);
                                    TCFTerminalShell.this.inp_id = ctx.getStdOutID();
                                    TCFTerminalShell.this.out_id = ctx.getStdInID();
                                    TCFTerminalShell.this.fSessionProvider.onStreamsID(TCFTerminalShell.this.inp_id);
                                    TCFTerminalShell.this.fSessionProvider.onStreamsID(TCFTerminalShell.this.out_id);
                                    try {
                                        TCFTerminalShell.this.fInputStream = (InputStream)new TCFVirtualInputStream(TCFTerminalShell.this.fChannel, TCFTerminalShell.this.inp_id, new Runnable(){

                                            @Override
                                            public void run() {
                                                TCFTerminalShell.this.onInputStreamClosed();
                                            }
                                        });
                                        TCFTerminalShell.this.fOutputStream = (OutputStream)new TCFVirtualOutputStream(TCFTerminalShell.this.fChannel, TCFTerminalShell.this.out_id, true, new Runnable(){

                                            @Override
                                            public void run() {
                                                TCFTerminalShell.this.onOutputStreamClosed();
                                            }
                                        });
                                    }
                                    catch (Exception x) {
                                        error = x;
                                    }
                                }
                                TCFTerminalShell.this.fSessionProvider.onStreamsConnected();
                                if (error != null) {
                                    this.error(error);
                                } else {
                                    this.done(ctx);
                                }
                            }
                        });
                    }
                }.getS(null, Messages.TCFTerminalService_Name);
                this.fPtyType = this.terminalContext.getPtyType();
                this.fEncoding = this.terminalContext.getEncoding();
                this.fContextID = this.terminalContext.getID();
                this.fWidth = this.terminalContext.getWidth();
                this.fHeight = this.terminalContext.getHeight();
                String user = this.fSessionProvider.getSessionUserId();
                String password = this.fSessionProvider.getSessionPassword();
                this.status = 100;
                this.fOutputStreamWriter = this.fEncoding != null ? new BufferedWriter(new OutputStreamWriter(this.fOutputStream, encoding)) : new BufferedWriter(new OutputStreamWriter(this.fOutputStream));
                this.status = this.login(user, password);
                if (this.status == 200) {
                    this.status = this.login(user, password);
                }
                if (this.status == 150) {
                    this.connected = true;
                    if (initialWorkingDirectory != null && initialWorkingDirectory.length() > 0 && !initialWorkingDirectory.equals(".") && !initialWorkingDirectory.equals("Command Shell")) {
                        this.writeToShell("cd " + PathUtility.enQuoteUnix((String)initialWorkingDirectory));
                    }
                    if (commandToRun != null && commandToRun.length() > 0) {
                        this.writeToShell(commandToRun);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                nestedException = e;
                if (this.status != 150) {
                    SimpleSystemMessage msg;
                    if (nestedException != null) {
                        msg = new SimpleSystemMessage("org.eclipse.tcf.rse", "RSEG1003", 4, CommonMessages.MSG_EXCEPTION_OCCURRED, (Throwable)nestedException);
                    } else {
                        String strErr = this.status == 200 ? "Connection closed!" : (this.status == 100 ? "Login Incorrect or meet other unknown error!" : "Not identified Errors");
                        msg = new SimpleSystemMessage("org.eclipse.tcf.rse", "RSEC1002", 4, strErr, "Meet error when trying to login in!");
                        msg.makeSubstitution((Object)((TCFConnectorService)this.fSessionProvider).getHost().getAliasName());
                    }
                    throw new SystemMessageException((SystemMessage)msg);
                }
            }
        }
        finally {
            if (this.status != 150) {
                SimpleSystemMessage msg;
                if (nestedException != null) {
                    msg = new SimpleSystemMessage("org.eclipse.tcf.rse", "RSEG1003", 4, CommonMessages.MSG_EXCEPTION_OCCURRED, (Throwable)nestedException);
                } else {
                    String strErr = this.status == 200 ? "Connection closed!" : (this.status == 100 ? "Login Incorrect or meet other unknown error!" : "Not identified Errors");
                    msg = new SimpleSystemMessage("org.eclipse.tcf.rse", "RSEC1002", 4, strErr, "Meet error when trying to login in!");
                    msg.makeSubstitution((Object)((TCFConnectorService)this.fSessionProvider).getHost().getAliasName());
                }
                throw new SystemMessageException((SystemMessage)msg);
            }
        }
    }

    public void writeToShell(String command) throws IOException {
        if (this.isActive()) {
            command = "#break".equals(command) ? "\u0003" : String.valueOf(command) + "\r\n";
            this.fOutputStreamWriter.write(command);
        }
    }

    public void exit() {
        if (this.fChannel == null || this.fChannel.getState() == 2 || !this.connected) {
            return;
        }
        try {
            this.getOutputStream().close();
            this.getInputStream().close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            new TCFRSETask<Object>(){

                public void run() {
                    TCFTerminalShell.this.terminalContext.exit(new ITerminals.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error != null) {
                                this.error(error);
                            } else {
                                this.done(this);
                            }
                        }
                    });
                }
            }.getS(null, Messages.TCFShellService_Name);
        }
        catch (SystemMessageException e) {
            e.printStackTrace();
        }
    }

    public InputStream getInputStream() {
        if (!this.connected) {
            throw new Error("Not connected");
        }
        return this.fInputStream;
    }

    public OutputStream getOutputStream() {
        if (!this.connected) {
            throw new Error("Not connected");
        }
        return this.fOutputStream;
    }

    public boolean isActive() {
        if (this.fChannel != null && this.fChannel.getState() != 2 && this.connected) {
            return true;
        }
        this.exit();
        return false;
    }

    public String getPtyType() {
        return this.fPtyType;
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.fWidth == newWidth && this.fHeight == newHeight) {
            return;
        }
        if (this.fChannel == null || this.fChannel.getState() == 2 || !this.connected) {
            return;
        }
        this.fWidth = newWidth;
        this.fHeight = newHeight;
        try {
            new TCFRSETask<Object>(){

                public void run() {
                    if (TCFTerminalShell.this.fChannel != null && TCFTerminalShell.this.connected) {
                        TCFTerminalShell.this.terminals.setWinSize(TCFTerminalShell.this.fContextID, TCFTerminalShell.this.fWidth, TCFTerminalShell.this.fHeight, new ITerminals.DoneCommand(){

                            public void doneCommand(IToken token, Exception error) {
                                if (error != null) {
                                    this.error(error);
                                } else {
                                    this.done(this);
                                }
                            }
                        });
                    } else {
                        this.done((Object)this);
                    }
                }
            }.getS(null, Messages.TCFShellService_Name);
        }
        catch (SystemMessageException e) {
            e.printStackTrace();
        }
    }

    public String getDefaultEncoding() {
        if (this.fEncoding != null) {
            return this.fEncoding;
        }
        return defaultEncoding;
    }

    private void onInputStreamClosed() {
        this.inp_id = null;
        if (this.out_id == null && !this.exited) {
            this.terminalContext.exit(new ITerminals.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                }
            });
        }
    }

    private void onOutputStreamClosed() {
        this.out_id = null;
        if (this.inp_id == null && !this.exited) {
            this.terminalContext.exit(new ITerminals.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                }
            });
        }
    }

    private class LoginThread
    extends Thread {
        private String username;
        private String password;
        private int status = 150;

        public LoginThread(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void run() {
            TCFTerminalShell.this.tcfPropertySet = ((TCFConnectorService)TCFTerminalShell.this.fSessionProvider).getTCFPropertySet();
            String login_required = TCFTerminalShell.this.tcfPropertySet.getPropertyValue("Login.Required");
            if (Boolean.valueOf(login_required).booleanValue()) {
                String login_prompt = TCFTerminalShell.this.tcfPropertySet.getPropertyValue("Login.Prompt");
                String password_prompt = TCFTerminalShell.this.tcfPropertySet.getPropertyValue("Password.Prompt");
                String command_prompt = TCFTerminalShell.this.tcfPropertySet.getPropertyValue("Command.Prompt");
                String pwd_required = TCFTerminalShell.this.tcfPropertySet.getPropertyValue("Pwd.Required");
                this.status = 150;
                if (login_prompt != null && login_prompt.length() > 0) {
                    this.status = this.readUntil(login_prompt, TCFTerminalShell.this.fInputStream);
                    TCFTerminalShell.this.write(String.valueOf(this.username) + "\n");
                }
                if (Boolean.valueOf(pwd_required).booleanValue() && this.status == 150 && password_prompt != null && password_prompt.length() > 0) {
                    this.status = this.readUntil(password_prompt, TCFTerminalShell.this.fInputStream);
                    TCFTerminalShell.this.write(String.valueOf(this.password) + "\n");
                }
                if (this.status == 150 && command_prompt != null && command_prompt.length() > 0) {
                    this.status = this.readUntil(command_prompt, TCFTerminalShell.this.fInputStream);
                    TCFTerminalShell.this.write("\n");
                }
            } else {
                this.status = 150;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int readUntil(String pattern, InputStream in) {
            try {
                char lastChar = pattern.charAt(pattern.length() - 1);
                StringBuffer sb = new StringBuffer();
                int ch = in.read();
                while (true) {
                    if (ch < 0) {
                        return 200;
                    }
                    char tch = (char)ch;
                    sb.append(tch);
                    if (tch == 't' && sb.indexOf("incorrect") >= 0) {
                        return 100;
                    }
                    if (tch == 'd' && sb.indexOf("closed") >= 0) {
                        return 200;
                    }
                    if (tch == lastChar && sb.toString().endsWith(pattern)) {
                        return 150;
                    }
                    ch = in.read();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                SystemBasePlugin.logError((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()), (Throwable)e);
            }
            return 200;
        }

        public int getLoginStatus() {
            return this.status;
        }
    }
}

