/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INotableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.layout.FreeFormLayoutEx;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.OneLineBorder;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.ISiriusEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DCompartmentConnectionRefreshMgr;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.AirXYLayoutEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LaunchToolEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.NodeCreationEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusContainerDropPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusPopupBarEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DNodeContainerViewNodeContainerCompartmentItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.RegionCollapseAwarePropertyHandlerEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.operation.RegionContainerUpdateLayoutOperation;
import org.eclipse.sirius.diagram.ui.tools.api.figure.OneLineMarginBorder;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerFigureDesc;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.policies.ContainerCompartmentNodeEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.ruler.SiriusSnapToHelperUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.gmf.runtime.editpolicies.SiriusSnapFeedbackPolicy;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.description.style.LabelBorderStyleDescription;

public abstract class AbstractDNodeContainerCompartmentEditPart
extends ShapeCompartmentEditPart
implements INotableEditPart,
ISiriusEditPart {
    public static final int DEFAULT_MARGIN = 4;

    public AbstractDNodeContainerCompartmentEditPart(View view) {
        super(view);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateConnectionRequest || request instanceof ReconnectRequest) {
            return this.getParent();
        }
        return this;
    }

    public Command getCommand(Request _request) {
        if (_request instanceof ReconnectRequest) {
            return this.getParent().getCommand(_request);
        }
        if (_request instanceof CreateConnectionRequest) {
            Command command = this.getParent().getCommand(_request);
            return command;
        }
        if (_request instanceof EditCommandRequestWrapper && ((EditCommandRequestWrapper)_request).getEditCommandRequest() instanceof CreateRelationshipRequest) {
            return this.getParent().getCommand(_request);
        }
        return super.getCommand(_request);
    }

    public DragTracker getDragTracker(Request request) {
        return this.getParent().getDragTracker(request);
    }

    protected void refreshVisuals() {
        DNodeContainer container;
        EObject eObj = this.resolveSemanticElement();
        if (eObj instanceof DNodeContainer && (container = (DNodeContainer)eObj).getOwnedStyle() != null) {
            ContainerStyle ownedStyle = container.getOwnedStyle();
            RGBValues borderColor = ownedStyle.getBorderColor();
            if (borderColor != null) {
                this.getFigure().setForegroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(borderColor));
            }
            if (this.getFigure() instanceof ResizableCompartmentFigure) {
                ResizableCompartmentFigure rcf = (ResizableCompartmentFigure)this.getFigure();
                this.configureBorder(rcf);
                if (rcf.getScrollPane() != null) {
                    this.configureScrollPaneBorder(rcf.getScrollPane(), ownedStyle);
                }
            }
        }
        super.refreshVisuals();
    }

    public IFigure createFigure() {
        IMapMode mapMode = this.getMapMode();
        ShapeCompartmentFigure scf = new ShapeCompartmentFigure(this.getCompartmentName(), mapMode);
        if (new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)this.resolveSemanticElement()).isRegion()) {
            scf = new RegionShapeCompartmentFigure(this.getCompartmentName(), mapMode);
            scf.getScrollPane().setMinimumSize(new Dimension(0, 0));
        }
        this.configureBorder((ResizableCompartmentFigure)scf);
        scf.getContentPane().setLayoutManager(this.getLayoutManager());
        scf.getContentPane().addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        scf.setTitleVisibility(false);
        scf.setToolTip(null);
        return scf;
    }

    protected void configureBorder(ResizableCompartmentFigure rcf) {
        IFigure parentFigure;
        boolean shouldHaveBorder = this.isRegionContainerCompartment();
        Option<LabelBorderStyleDescription> labelBorderStyle = this.getLabelBorderStyle();
        if (labelBorderStyle.some()) {
            boolean bl = shouldHaveBorder = shouldHaveBorder || "labelBorderForContainer".equals(((LabelBorderStyleDescription)labelBorderStyle.get()).getId());
        }
        if (!shouldHaveBorder || this.isLabelHidden() || this.isCollapsed()) {
            if (rcf.getBorder() instanceof LineBorder || rcf.getBorder() == null) {
                rcf.setBorder((Border)new MarginBorder(this.getMapMode().DPtoLP(1), 0, 0, 0));
            }
        } else if (rcf.getBorder() instanceof MarginBorder || rcf.getBorder() == null) {
            rcf.setBorder((Border)new OneLineBorder(this.getMapMode().DPtoLP(1), 8));
        }
        if ((parentFigure = rcf.getParent()) != null && this.getParent() instanceof AbstractDiagramContainerEditPart) {
            AbstractDiagramContainerEditPart adcep = (AbstractDiagramContainerEditPart)this.getParent();
            if (shouldHaveBorder && adcep.getContentPane() != parentFigure) {
                parentFigure.remove((IFigure)rcf);
                adcep.getContentPane().add((IFigure)rcf);
            } else if (!shouldHaveBorder && adcep.getMainFigure() != parentFigure) {
                parentFigure.remove((IFigure)rcf);
                adcep.getMainFigure().add((IFigure)rcf);
            }
        }
    }

    protected void configureScrollPaneBorder(ScrollPane scrollPane, ContainerStyle ownedStyle) {
        int borderSize = 0;
        if (ownedStyle.getBorderSize() != null) {
            borderSize = ownedStyle.getBorderSize();
        }
        boolean fullLabelBorder = false;
        Option<LabelBorderStyleDescription> labelBorderStyle = this.getLabelBorderStyle();
        if (labelBorderStyle.some()) {
            fullLabelBorder = "labelBorderForContainer".equals(((LabelBorderStyleDescription)labelBorderStyle.get()).getId());
        }
        MarginBorder border = null;
        if (this.isRegionContainerCompartment()) {
            border = borderSize == 0 ? new MarginBorder(0, 0, 0, 0) : new MarginBorder(0, 0, -1, -1);
        } else if (fullLabelBorder) {
            border = new MarginBorder(4, 4, 4, 4);
        } else {
            int margin = borderSize + 4;
            border = new MarginBorder(margin, margin, margin, margin);
            if (((AbstractDiagramElementContainerEditPart)this.getParent()).getPrimaryShape().getBorder() instanceof OneLineMarginBorder) {
                int lineBorderPosition = ((OneLineMarginBorder)((AbstractDiagramElementContainerEditPart)this.getParent()).getPrimaryShape().getBorder()).getPosition();
                if (8 == lineBorderPosition) {
                    border = new MarginBorder(margin, 4, 4, 4);
                } else if (1 == lineBorderPosition) {
                    border = new MarginBorder(4, margin, 4, 4);
                } else if (32 == lineBorderPosition) {
                    border = new MarginBorder(4, 4, margin, 4);
                } else if (4 == lineBorderPosition) {
                    border = new MarginBorder(4, 4, 4, margin);
                }
            }
        }
        scrollPane.setBorder((Border)border);
    }

    private boolean isLabelHidden() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof DDiagramElement) {
            return new DDiagramElementQuery((DDiagramElement)element).isLabelHidden();
        }
        return false;
    }

    private boolean isCollapsed() {
        DrawerStyle style = (DrawerStyle)((View)this.getModel()).getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
        return style == null ? false : style.isCollapsed();
    }

    private Option<LabelBorderStyleDescription> getLabelBorderStyle() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof DDiagramElementContainer) {
            return new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)element).getLabelBorderStyle();
        }
        return Options.newNone();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DNodeContainerViewNodeContainerCompartmentItemSemanticEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new SiriusContainerDropPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new NodeCreationEditPolicy());
        this.installEditPolicy("launchTool", (EditPolicy)new LaunchToolEditPolicy());
        this.removeEditPolicy("LayoutEditPolicy");
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new AirXYLayoutEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ContainerCompartmentNodeEditPolicy());
        this.installEditPolicy("PopupBarEditPolicy", (EditPolicy)new SiriusPopupBarEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SiriusSnapFeedbackPolicy());
        this.installEditPolicy("PropertyHandlerPolicy", (EditPolicy)new RegionCollapseAwarePropertyHandlerEditPolicy());
    }

    protected void setRatio(Double ratio) {
        if (this.getFigure().getParent() != null && this.getFigure().getParent().getLayoutManager() instanceof ConstrainedToolbarLayout) {
            super.setRatio(ratio);
        }
    }

    protected List getModelChildren() {
        ArrayList modelChildren = Lists.newArrayList((Iterable)Iterables.filter((Iterable)super.getModelChildren(), View.class));
        DiagramElementEditPartOperation.removeInvisibleElements(modelChildren);
        if (this.isRegionContainerCompartment() && this.getModel() instanceof View) {
            RegionContainerUpdateLayoutOperation.sortRegions((DNodeContainer)this.resolveSemanticElement(), modelChildren);
        }
        return modelChildren;
    }

    private boolean isRegionContainerCompartment() {
        Option<DNodeContainerExperimentalQuery> query = this.getDNodeContainerQuery();
        return query.some() && ((DNodeContainerExperimentalQuery)query.get()).isRegionContainer();
    }

    private Option<DNodeContainerExperimentalQuery> getDNodeContainerQuery() {
        DNodeContainerExperimentalQuery query = null;
        EObject eObject = this.resolveSemanticElement();
        if (eObject instanceof DNodeContainer) {
            query = new DNodeContainerExperimentalQuery((DNodeContainer)eObject);
        }
        return Options.newSome(query);
    }

    protected Set getConnectionNodes(ShapeCompartmentEditPart scep) {
        HashSet endPoints = new HashSet();
        Object modelObject = scep.getModel();
        if (scep.getViewer() == null || modelObject == null || !(modelObject instanceof View)) {
            return endPoints;
        }
        if (((View)modelObject).getDiagram() == null) {
            return endPoints;
        }
        Diagram diagram = ((View)modelObject).getDiagram();
        Map registry = scep.getViewer().getEditPartRegistry();
        EList edges = diagram.getEdges();
        for (Edge edge : edges) {
            Object cep;
            EditPart endPoint = (EditPart)registry.get(edge.getSource());
            if (this.isChildOf((EditPart)scep, endPoint)) {
                cep = registry.get(edge);
                if (cep == null) continue;
                endPoints.add(cep);
                continue;
            }
            endPoint = (EditPart)registry.get(edge.getTarget());
            if (!this.isChildOf((EditPart)scep, endPoint) || (cep = registry.get(edge)) == null) continue;
            endPoints.add(cep);
        }
        return endPoints;
    }

    protected boolean isChildOf(EditPart parent, EditPart child) {
        EditPart walker = child;
        while (walker != null && walker != parent) {
            walker = walker.getParent();
        }
        return walker != null;
    }

    public boolean canAttachNote() {
        return true;
    }

    protected ShapeCompartmentEditPart.ConnectionRefreshMgr createConnectionRefreshMgr() {
        return new DCompartmentConnectionRefreshMgr();
    }

    protected LayoutManager getLayoutManager() {
        Object layoutManager = null;
        Option<DNodeContainerExperimentalQuery> query = this.getDNodeContainerQuery();
        if (query.some() && ((DNodeContainerExperimentalQuery)query.get()).isRegionContainer()) {
            if (((DNodeContainerExperimentalQuery)query.get()).isVerticalStackContainer()) {
                layoutManager = new RegionContainerLayoutManager(true);
            } else if (((DNodeContainerExperimentalQuery)query.get()).isHorizontaltackContainer()) {
                layoutManager = new RegionContainerLayoutManager(false);
            }
        }
        if (layoutManager == null) {
            layoutManager = super.getLayoutManager();
        }
        return layoutManager;
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            return SiriusSnapToHelperUtil.getSnapHelper((GraphicalEditPart)this);
        }
        return super.getAdapter(key);
    }

    protected void setCollapsed(boolean collapsed, boolean animate) {
        super.setCollapsed(collapsed, false);
    }

    public static class RegionContainerLayoutManager
    extends FreeFormLayoutEx {
        private final boolean isVertical;

        public RegionContainerLayoutManager(boolean isVertical) {
            this.isVertical = isVertical;
        }

        public boolean isVertical() {
            return this.isVertical;
        }

        public void layout(IFigure parent) {
            Rectangle bounds;
            ArrayList children = Lists.newArrayList((Iterable)Iterables.filter((Iterable)parent.getChildren(), IFigure.class));
            Point offset = this.getOrigin(parent);
            int maxWidth = 0;
            int maxHeight = 0;
            int minY = Integer.MAX_VALUE;
            HashMap regionsBounds = Maps.newHashMap();
            for (IFigure f : children) {
                Object constraint = this.getConstraint(f);
                if (!(constraint instanceof Rectangle)) continue;
                bounds = ((Rectangle)constraint).getCopy();
                bounds = this.computeFreeFormLayoutExBounds(f, bounds);
                regionsBounds.put(f, bounds);
                maxWidth = Math.max(maxWidth, bounds.width);
                maxHeight = Math.max(maxHeight, bounds.height);
                minY = Math.min(minY, bounds.y);
            }
            int labelWidth = 0;
            IFigure parentLabelFigure = this.getParentLabelFigure(parent);
            if (parentLabelFigure != null) {
                labelWidth = parentLabelFigure.getSize().width;
                if (this.isVertical) {
                    maxWidth = Math.max(maxWidth, labelWidth);
                }
            }
            int y = minY;
            int x = 0;
            for (IFigure f : children) {
                bounds = (Rectangle)regionsBounds.get(f);
                bounds.x = x;
                bounds.y = y;
                if (this.isVertical) {
                    bounds.width = maxWidth;
                    y += bounds.height;
                } else {
                    bounds.height = maxHeight;
                    x += bounds.width;
                }
                this.setConstraint(f, bounds);
                f.setBounds(bounds.translate(offset));
            }
            int delta = labelWidth - x;
            if (!this.isVertical && delta > 0 && !children.isEmpty()) {
                IFigure last = (IFigure)Iterables.getLast((Iterable)children);
                bounds = (Rectangle)regionsBounds.get(last);
                bounds.setWidth(bounds.width + delta);
                this.setConstraint(last, bounds);
                last.setBounds(bounds.translate(offset));
            }
        }

        private IFigure getParentLabelFigure(IFigure parent) {
            IFigure tmp = parent;
            ViewNodeContainerFigureDesc parentShape = null;
            while (parentShape == null && tmp != null) {
                if (tmp instanceof ViewNodeContainerFigureDesc) {
                    parentShape = (ViewNodeContainerFigureDesc)tmp;
                    tmp = null;
                    continue;
                }
                tmp = tmp.getParent();
            }
            return parentShape != null ? parentShape.getLabelFigure() : null;
        }

        private Rectangle computeFreeFormLayoutExBounds(IFigure f, Rectangle copy) {
            Rectangle bounds = copy;
            int widthHint = bounds.width;
            int heightHint = bounds.height;
            if (widthHint == -1 || heightHint == -1) {
                Dimension prefSize = f.getPreferredSize(widthHint, heightHint);
                if (widthHint == -1) {
                    bounds.width = prefSize.width;
                }
                if (heightHint == -1) {
                    bounds.height = prefSize.height;
                }
            }
            Dimension min = f.getMinimumSize(widthHint, heightHint);
            Dimension max = f.getMaximumSize();
            if (min.width > bounds.width) {
                bounds.width = min.width;
            } else if (max.width < bounds.width) {
                bounds.width = max.width;
            }
            if (min.height > bounds.height) {
                bounds.height = min.height;
            } else if (max.height < bounds.height) {
                bounds.height = max.height;
            }
            return bounds;
        }
    }

    private static class RegionShapeCompartmentFigure
    extends ShapeCompartmentFigure {
        public RegionShapeCompartmentFigure(String title, IMapMode mm) {
            super(title, mm);
        }

        public Dimension getMinClientDimension() {
            return new Dimension(0, 0);
        }
    }
}

