/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.handler;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.classid.MissingClassIdsNewOperation;
import org.eclipse.scout.sdk.s2e.job.ResourceBlockingOperationJob;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateMissingClassIdsSelectedHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        final Set<IResource> resourcesFromSelection = S2eUiUtils.getResourcesOfSelection(selection);
        if (resourcesFromSelection.isEmpty()) {
            CreateMissingClassIdsSelectedHandler.logNoSelection();
            return null;
        }
        MissingClassIdsNewOperation operation = new MissingClassIdsNewOperation(){

            protected ITypeHierarchy createHierarchy(IType iTypeWithClassId, SubMonitor monitor) throws CoreException {
                IRegion region = JavaCore.newRegion();
                boolean added = false;
                for (IResource r : resourcesFromSelection) {
                    IJavaElement element;
                    if (r == null || !r.isAccessible() || !S2eUtils.exists((IJavaElement)(element = JavaCore.create((IResource)r)))) continue;
                    region.add(element);
                    added = true;
                }
                if (!added) {
                    CreateMissingClassIdsSelectedHandler.logNoSelection();
                }
                ITypeHierarchy result = JavaCore.newTypeHierarchy((IRegion)region, null, (IProgressMonitor)monitor);
                return result;
            }
        };
        new ResourceBlockingOperationJob((IOperation)operation, resourcesFromSelection.toArray(new IResource[resourcesFromSelection.size()])).schedule();
        return null;
    }

    private static void logNoSelection() {
        SdkLog.warning((String)"Cannot create missing @ClassIds in the selected scope because no resources are selected.", (Object[])new Object[0]);
    }
}

