/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.internal.ValueSnapshot;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class NumericRangeFactsService
extends FactsService {
    @Text(value="Minimum value is {0}")
    private static LocalizableText minValueStatement;
    @Text(value="Maximum value is {0}")
    private static LocalizableText maxValueStatement;

    static {
        LocalizableText.init(NumericRangeFactsService.class);
    }

    @Override
    protected void facts(SortedSet<String> facts) {
        ValueProperty property = this.context(ValueProperty.class);
        NumericRange range = property.getAnnotation(NumericRange.class);
        String min = range.min();
        String max = range.max();
        if (min.length() > 0) {
            facts.add(minValueStatement.format(new ValueSnapshot(property, min)));
        }
        if (max.length() > 0) {
            facts.add(maxValueStatement.format(new ValueSnapshot(property, max)));
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            if (property != null) {
                NumericRange range = property.getAnnotation(NumericRange.class);
                return range != null && (range.min().length() > 0 || range.max().length() > 0);
            }
            return false;
        }
    }
}

