/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.HashMap;
import java.util.Map;

public final class Counter {
    private static Map<String, Counter> counters;
    private long value;

    public static synchronized Counter find(String name) {
        Counter counter;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (counters == null) {
            counters = new HashMap<String, Counter>();
        }
        if ((counter = counters.get(name)) == null) {
            counter = new Counter();
            counters.put(name, counter);
        }
        return counter;
    }

    public static Counter find(Class<?> cl) {
        if (cl == null) {
            throw new IllegalArgumentException();
        }
        return Counter.find(cl.getName());
    }

    public static synchronized void increment(String name) {
        Counter counter;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (counters != null && (counter = counters.get(name)) != null) {
            counter.increment();
        }
    }

    public static void increment(Class<?> cl) {
        if (cl == null) {
            throw new IllegalArgumentException();
        }
        Counter.increment(cl.getName());
    }

    public synchronized void increment() {
        ++this.value;
    }

    public synchronized void reset() {
        this.value = 0L;
    }

    public synchronized long read() {
        return this.value;
    }
}

