/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.filesystem;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.server.SecuredThread;
import org.eclipse.rse.dstore.universal.miners.ICancellableHandler;
import org.eclipse.rse.dstore.universal.miners.UniversalFileSystemMiner;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;

public class UniversalDownloadHandler
extends SecuredThread
implements ICancellableHandler {
    private boolean _isDone = false;
    private UniversalFileSystemMiner _miner;
    private DataElement _status;
    private DataElement _cmdElement;
    private boolean _isCancelled = false;

    public UniversalDownloadHandler(DataStore dataStore, UniversalFileSystemMiner miner, DataElement cmdElement, DataElement status) {
        super(dataStore);
        this._miner = miner;
        this._status = status;
        this._cmdElement = cmdElement;
    }

    public void run() {
        super.run();
        this.handleDownload(this._cmdElement, this._status);
        this._isDone = true;
        this.removeFromCancellableList();
        this._dataStore.disconnectObject(this._cmdElement);
    }

    private void removeFromCancellableList() {
        this._miner.updateCancellableThreads(this._status.getParent(), this);
    }

    public boolean isDone() {
        return this._isDone;
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public void cancel() {
        this._dataStore.trace("cancelling download");
        this._isCancelled = true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DataElement handleDownload(DataElement theElement, DataElement status) {
        block28: {
            block26: {
                block27: {
                    arg1 = this._miner.getCommandArgument(theElement, 1);
                    elementType = arg1.getType();
                    remotePath = arg1.getName();
                    buffer_size = 10240;
                    bufferSizeElement = this._dataStore.find(theElement, 0, "buffer_size", 1);
                    if (bufferSizeElement != null) {
                        try {
                            buffer_size = Integer.parseInt(bufferSizeElement.getName());
                        }
                        catch (Exception v0) {}
                    }
                    resultType = null;
                    resultMessage = null;
                    inputStream = null;
                    bufInputStream = null;
                    try {
                        try {
                            if (!elementType.equals("universal.FileObject") && !elementType.equals("universal.ArchiveFileObject") && !elementType.equals("universal.VirtualFileObject")) break block26;
                            this._dataStore.trace("download:" + remotePath + "," + elementType);
                            file = new File(remotePath);
                            v1 = new String[4];
                            v1[0] = "READ";
                            v1[1] = file.getAbsolutePath();
                            auditData = v1;
                            UniversalServerUtilities.logAudit(auditData, this._dataStore);
                            if (elementType.equals("universal.VirtualFileObject")) {
                                vpath = this._miner.getAbsoluteVirtualPath(remotePath);
                                handler = this._miner.getArchiveHandlerFor(vpath.getContainingArchiveString());
                                if (handler == null) {
                                    status.setAttribute(4, "failed");
                                    resultType = "IOException";
                                    resultMessage = "Corrupted archive.";
                                    this._isDone = true;
                                    this._dataStore.createObject(arg1, resultType, resultMessage);
                                    this._dataStore.refresh(arg1);
                                    var29_21 = this._miner.statusDone(status);
                                    var27_22 = null;
                                    break block27;
                                }
                                vChild = handler.getVirtualFile(vpath.getVirtualPart(), null);
                                file = vChild.getExtractedFile();
                            }
                            arg2 = this._miner.getCommandArgument(theElement, 2);
                            this._miner.getCommandArgument(theElement, 3);
                            mode = Integer.valueOf(arg1.getSource());
                            localPath = arg2.getName();
                            v2 = isText = mode == -1;
                            if (isText) {
                                arg2.getSource();
                            }
                            inputStream = new FileInputStream(file);
                            bufInputStream = new BufferedInputStream(inputStream, buffer_size);
                            totalBytes = (int)file.length();
                            totalWritten = 0;
                            first = true;
                            buffer = new byte[buffer_size];
                            numToRead = 0;
                            byteConverter = this._dataStore.getByteConverter();
                            byteConverter.setContext(file);
                            available = bufInputStream.available();
                            while (available > 0 && !this._isCancelled && (bytesRead = bufInputStream.read(buffer, 0, numToRead = available < buffer_size ? available : buffer_size)) != -1) {
                                if (isText) {
                                    convBytes = byteConverter.convertHostBytesToClientBytes(buffer, 0, bytesRead);
                                    if (first) {
                                        first = false;
                                        this._dataStore.updateFile(localPath, convBytes, convBytes.length, true);
                                    } else {
                                        this._dataStore.updateAppendFile(localPath, convBytes, convBytes.length, true);
                                    }
                                    totalWritten += convBytes.length;
                                } else {
                                    if (first) {
                                        first = false;
                                        this._dataStore.updateFile(localPath, buffer, bytesRead, true);
                                    } else {
                                        this._dataStore.updateAppendFile(localPath, buffer, bytesRead, true);
                                    }
                                    totalWritten += bytesRead;
                                }
                                status.setAttribute(4, "sent " + totalWritten + " of " + totalBytes);
                                this._dataStore.refresh(status);
                                available = bufInputStream.available();
                            }
                            resultType = "universal.download.success";
                            resultMessage = "successful";
                        }
                        catch (FileNotFoundException e) {
                            UniversalServerUtilities.logError("UniversalFileSystemMiner", "handleDownload: error reading file " + remotePath, e, this._dataStore);
                            resultType = "FileNotFoundException";
                            resultMessage = e.getLocalizedMessage();
                        }
                        catch (UnsupportedEncodingException e) {
                            UniversalServerUtilities.logError("UniversalFileSystemMiner", "handleDownload: error reading file " + remotePath, e, this._dataStore);
                            resultType = "UnsupportedEncodingException";
                            resultMessage = e.getLocalizedMessage();
                        }
                        catch (IOException e) {
                            UniversalServerUtilities.logError("UniversalFileSystemMiner", "handleDownload: error reading file " + remotePath, e, this._dataStore);
                            resultType = "IOException";
                            resultMessage = e.getLocalizedMessage();
                        }
                        catch (Exception e) {
                            UniversalServerUtilities.logError("UniversalFileSystemMiner", "handleDownload: error reading file " + remotePath, e, this._dataStore);
                            resultType = "Exception";
                            resultMessage = e.getLocalizedMessage();
                        }
                        break block26;
                    }
                    catch (Throwable var28_39) {
                        var27_23 = null;
                        try {
                            if (bufInputStream == null) throw var28_39;
                            bufInputStream.close();
                            throw var28_39;
                        }
                        catch (IOException e) {
                            UniversalServerUtilities.logError("UniversalFileSystemMiner", "handleDownload: error closing reader on " + remotePath, e, this._dataStore);
                            resultType = "IOException";
                            resultMessage = e.getMessage();
                        }
                        throw var28_39;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [15 : 855->868)] { 
lbl118:
                // 1 sources

                if (bufInputStream == null) return var29_21;
                bufInputStream.close();
                return var29_21;
lbl121:
                // 1 sources

                catch (IOException e) {
                    UniversalServerUtilities.logError("UniversalFileSystemMiner", "handleDownload: error closing reader on " + remotePath, e, this._dataStore);
                    resultType = "IOException";
                    resultMessage = e.getMessage();
                }
                return var29_21;
            }
            var27_24 = null;
            ** try [egrp 3[TRYBLOCK] [15 : 855->868)] { 
lbl129:
            // 1 sources

            if (bufInputStream != null) {
                bufInputStream.close();
            }
            break block28;
lbl132:
            // 1 sources

            catch (IOException e) {
                UniversalServerUtilities.logError("UniversalFileSystemMiner", "handleDownload: error closing reader on " + remotePath, e, this._dataStore);
                resultType = "IOException";
                resultMessage = e.getMessage();
            }
        }
        this._isDone = true;
        this._dataStore.createObject(arg1, resultType, resultMessage);
        this._dataStore.refresh(arg1);
        return this._miner.statusDone(status);
    }
}

