/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnipmatchRcpPreferences;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.LogMessages;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.model.SnippetRepositoryConfigurations;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Openable;

public class Repositories
extends AbstractIdleService
implements IRcpService,
Openable,
Closeable {
    private final SnippetRepositoryConfigurations configurations;
    private final SnipmatchRcpPreferences prefs;
    private Set<ISnippetRepository> repositories = new HashSet<ISnippetRepository>();

    @Inject
    public Repositories(EventBus bus, SnippetRepositoryConfigurations configurations, SnipmatchRcpPreferences prefs) {
        bus.register((Object)this);
        this.prefs = prefs;
        this.configurations = configurations;
    }

    @PostConstruct
    public void open() throws IOException {
        this.startAsync();
    }

    protected void startUp() throws Exception {
        this.repositories.clear();
        for (SnippetRepositoryConfiguration config : this.configurations.getRepos()) {
            if (!this.prefs.isRepositoryEnabled(config)) continue;
            ISnippetRepository repo = config.createRepositoryInstance();
            repo.open();
            this.repositories.add(repo);
        }
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        this.stopAsync();
    }

    protected void shutDown() throws Exception {
        for (ISnippetRepository repo : this.repositories) {
            repo.close();
        }
        this.repositories.clear();
    }

    public void reload() throws Exception {
        if (!this.isRunning()) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_SERVICE_NOT_RUNNING);
        }
        this.shutDown();
        this.startUp();
    }

    public Set<ISnippetRepository> getRepositories() {
        if (!this.isRunning()) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_SERVICE_NOT_RUNNING);
            return ImmutableSet.of();
        }
        return this.repositories;
    }

    public Optional<ISnippetRepository> getRepository(String id) {
        if (!this.isRunning()) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_SERVICE_NOT_RUNNING);
            return Optional.absent();
        }
        for (ISnippetRepository repo : this.repositories) {
            if (!repo.getId().equals(id)) continue;
            return Optional.of((Object)repo);
        }
        return Optional.absent();
    }

    @Subscribe
    public void onEvent(SnippetRepositoryConfigurationChangedEvent e) throws Exception {
        this.reload();
    }

    public static class SnippetRepositoryConfigurationChangedEvent {
    }
}

