/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.model.PHPUnitSearchEngine;

public class PHPUnitTestElementFinder {
    private IType[] PHP_UNIT_CASE_CACHED;
    private IType[] PHP_UNIT_SUITE_CACHED;
    private IType[] PHP_UNIT_CASES_AND_SUITES;

    public IRunnableWithProgress search(IScriptProject phpProject) {
        return pm -> {
            PHPUnitSearchEngine searchEngine = new PHPUnitSearchEngine(phpProject);
            pm.beginTask(PHPUnitMessages.PHPUnitSearchEngine_Searching, -1);
            if (this.PHP_UNIT_CASE_CACHED == null) {
                List<IType> cases = searchEngine.findTestCaseBaseClasses((IModelElement)phpProject, false, (IProgressMonitor)new SubProgressMonitor(pm, -1));
                this.updateCasesCache(cases);
            }
            if (this.PHP_UNIT_SUITE_CACHED == null) {
                List<IType> suites = searchEngine.findTestSuiteBaseClasses((IModelElement)phpProject, false, (IProgressMonitor)new SubProgressMonitor(pm, -1));
                this.updateSuitesCache(suites);
            }
            pm.done();
        };
    }

    private void updateCasesCache(List<IType> types) {
        if (this.PHP_UNIT_CASE_CACHED == null) {
            this.PHP_UNIT_CASE_CACHED = types.toArray(new IType[0]);
            List<IType> casesList = Arrays.asList(this.PHP_UNIT_CASE_CACHED);
            ArrayList<IType> casesAndSuitesList = new ArrayList<IType>();
            if (this.PHP_UNIT_SUITE_CACHED != null) {
                List<IType> suitesList = Arrays.asList(this.PHP_UNIT_SUITE_CACHED);
                casesAndSuitesList.addAll(suitesList);
            }
            casesAndSuitesList.addAll(casesList);
            this.PHP_UNIT_CASES_AND_SUITES = casesAndSuitesList.toArray(new IType[casesAndSuitesList.size()]);
        }
    }

    private void updateSuitesCache(List<IType> types) {
        if (this.PHP_UNIT_SUITE_CACHED == null) {
            this.PHP_UNIT_SUITE_CACHED = types.toArray(new IType[0]);
            List<IType> suitesList = Arrays.asList(this.PHP_UNIT_SUITE_CACHED);
            ArrayList<IType> casesAndSuitesList = new ArrayList<IType>();
            if (this.PHP_UNIT_CASE_CACHED != null) {
                List<IType> casesList = Arrays.asList(this.PHP_UNIT_CASE_CACHED);
                casesAndSuitesList.addAll(casesList);
            }
            casesAndSuitesList.addAll(suitesList);
            this.PHP_UNIT_CASES_AND_SUITES = casesAndSuitesList.toArray(new IType[casesAndSuitesList.size()]);
        }
    }

    protected void cleareCaches() {
        this.PHP_UNIT_SUITE_CACHED = null;
        this.PHP_UNIT_CASE_CACHED = null;
        this.PHP_UNIT_CASES_AND_SUITES = null;
    }

    public IType[] getPHP_UNIT_CASE_CACHED() {
        return this.PHP_UNIT_CASE_CACHED;
    }

    public IType[] getPHP_UNIT_SUITE_CACHED() {
        return this.PHP_UNIT_SUITE_CACHED;
    }

    public IType[] getPHP_UNIT_CASES_AND_SUITES() {
        return this.PHP_UNIT_CASES_AND_SUITES;
    }
}

