/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.policies;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.SideAffixedNodesCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomFirstRegionInCompositeStateCreateElementCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.edit.part.CustomStateEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.RegionEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Vertex;

public class CustomStateCreationEditPolicy
extends SideAffixedNodesCreationEditPolicy {
    public static final String NOTATION_VIEW_VISIBLE = "notation.View.visible";
    public static final String VISIBILITY = "Visibility";
    public static final Rectangle defaultLocation = new Rectangle(20, 20, -1, -1);
    public static final String dropLocation = "";
    public static final int REGION_OFFSET = 20;

    public Command getCommand(Request request) {
        if (this.understandsRequest(request)) {
            if (request instanceof CreateViewRequest) {
                CreateViewRequest createViewRequest = (CreateViewRequest)request;
                for (CreateViewRequest.ViewDescriptor vd : createViewRequest.getViewDescriptors()) {
                    Command cmd = this.getCustomCreateCommand(request, null, (IElementType)vd.getElementAdapter().getAdapter(IElementType.class), vd.getSemanticHint());
                    if (cmd == null) continue;
                    return cmd;
                }
            } else if (request instanceof CreateUnspecifiedTypeRequest) {
                CreateUnspecifiedTypeRequest unspecReq = (CreateUnspecifiedTypeRequest)request;
                for (Object elementTypeObj : unspecReq.getElementTypes()) {
                    IElementType elementType = (IElementType)elementTypeObj;
                    CreateRequest createRequest = unspecReq.getRequestForType(elementType);
                    Command cmd = this.getCustomCreateCommand(request, createRequest, elementType, ((IHintedType)elementType).getSemanticHint());
                    if (cmd == null) continue;
                    return cmd;
                }
            } else if (request instanceof ChangeBoundsRequest) {
                ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
                Point mouseLocation = changeBoundsRequest.getLocation();
                DropObjectsRequest dropRequest = new DropObjectsRequest();
                dropRequest.setLocation(mouseLocation);
                ArrayList<View> list = new ArrayList<View>();
                for (Object epObj : changeBoundsRequest.getEditParts()) {
                    if (!(epObj instanceof RegionEditPart)) continue;
                    EditPart ep = (EditPart)epObj;
                    View regionToDrag = (View)ep.getModel();
                    list.add(regionToDrag);
                }
                dropRequest.setObjects(list);
                return this.getHost().getCommand((Request)dropRequest);
            }
            return super.getCommand(request);
        }
        return null;
    }

    public Command getCustomCreateCommand(Request request, CreateRequest createReq, IElementType elementType, String semanticHint) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        View stateView = (View)this.getHost().getModel();
        View stateCompartmentView = CustomStateEditPart.getStateCompartmentView(stateView);
        View existingRegionView = null;
        if (!stateCompartmentView.getChildren().isEmpty()) {
            if (stateCompartmentView.getChildren().size() == 1) {
                existingRegionView = (View)stateCompartmentView.getChildren().get(0);
            } else {
                return null;
            }
        }
        if (semanticHint.equals(((IHintedType)UMLElementTypes.Region_Shape).getSemanticHint())) {
            SemanticAdapter adaptableForStateCompartmentView = new SemanticAdapter(null, (Object)stateCompartmentView);
            CustomFirstRegionInCompositeStateCreateElementCommand createNewRegion = new CustomFirstRegionInCompositeStateCreateElementCommand((IAdaptable)adaptableForStateCompartmentView, null, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), editingDomain, DiagramUIMessages.CreateCommand_Label, dropLocation);
            SetPropertyCommand showCompartment = new SetPropertyCommand(editingDomain, (IAdaptable)adaptableForStateCompartmentView, NOTATION_VIEW_VISIBLE, VISIBILITY, (Object)true);
            cc.compose((IUndoableOperation)showCompartment);
            cc.compose((IUndoableOperation)createNewRegion);
            return new ICommandProxy(cc.reduce());
        }
        if (semanticHint.equals(((IHintedType)UMLElementTypes.Pseudostate_InitialShape).getSemanticHint()) || semanticHint.equals(((IHintedType)UMLElementTypes.Pseudostate_JoinShape).getSemanticHint()) || semanticHint.equals(((IHintedType)UMLElementTypes.Pseudostate_ForkShape).getSemanticHint()) || semanticHint.equals(((IHintedType)UMLElementTypes.Pseudostate_ChoiceShape).getSemanticHint()) || semanticHint.equals(((IHintedType)UMLElementTypes.Pseudostate_JunctionShape).getSemanticHint()) || semanticHint.equals(((IHintedType)UMLElementTypes.Pseudostate_ShallowHistoryShape).getSemanticHint()) || semanticHint.equals(((IHintedType)UMLElementTypes.Pseudostate_DeepHistoryShape).getSemanticHint()) || semanticHint.equals(((IHintedType)UMLElementTypes.Pseudostate_TerminateShape).getSemanticHint()) || semanticHint.equals(((IHintedType)UMLElementTypes.State_Shape).getSemanticHint()) || semanticHint.equals(((IHintedType)UMLElementTypes.FinalState_Shape).getSemanticHint())) {
            CreateViewRequest.ViewDescriptor viewDescriptor;
            SemanticAdapter adaptableForStateCompartmentView = new SemanticAdapter(null, (Object)stateCompartmentView);
            if (existingRegionView == null) {
                CustomFirstRegionInCompositeStateCreateElementCommand createNewRegion = new CustomFirstRegionInCompositeStateCreateElementCommand((IAdaptable)adaptableForStateCompartmentView, null, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), editingDomain, DiagramUIMessages.CreateCommand_Label, dropLocation);
                EList regions = ((State)stateView.getElement()).getRegions();
                if (!regions.isEmpty()) {
                    createNewRegion.useExistingRegion((Region)regions.get(0));
                }
                SetPropertyCommand showCompartment = new SetPropertyCommand(editingDomain, (IAdaptable)adaptableForStateCompartmentView, NOTATION_VIEW_VISIBLE, VISIBILITY, (Object)true);
                viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)createNewRegion.getCommandResult().getReturnValue(), Node.class, semanticHint, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
                CustomVertexCreateElementCommand createVertex = new CustomVertexCreateElementCommand(editingDomain, viewDescriptor, elementType, (IAdaptable)createNewRegion.getCommandResult().getReturnValue(), DiagramUIMessages.CreateCommand_Label);
                cc.compose((IUndoableOperation)showCompartment);
                cc.compose((IUndoableOperation)createNewRegion);
                cc.compose((IUndoableOperation)createVertex);
            } else {
                viewDescriptor = new CreateViewRequest.ViewDescriptor(null, Node.class, semanticHint, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
                SemanticAdapter adapter = new SemanticAdapter(null, (Object)existingRegionView);
                CustomVertexCreateElementCommand createVertex = new CustomVertexCreateElementCommand(editingDomain, viewDescriptor, elementType, (IAdaptable)adapter, DiagramUIMessages.CreateCommand_Label);
                cc.compose((IUndoableOperation)createVertex);
            }
            if (request instanceof CreateRequest) {
                CreateRequest req = (CreateRequest)request;
                Point parentLocation = this.getHostFigure().getBounds().getLocation().getCopy();
                Point requestedLocation = req.getLocation().getCopy();
                this.getHostFigure().translateToRelative((Translatable)requestedLocation);
                Rectangle proposedBounds = new Rectangle(requestedLocation.x, requestedLocation.y - 20, -1, -1);
                Rectangle creationBounds = request instanceof CreateUnspecifiedTypeRequest ? proposedBounds.getTranslated(parentLocation.getNegated()) : defaultLocation;
                cc.compose((IUndoableOperation)new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, creationBounds));
            }
            return new ICommandProxy(cc.reduce());
        }
        return null;
    }

    public static class CustomVertexCreateElementCommand
    extends AbstractTransactionalCommand {
        IAdaptable adaptable;
        CreateViewRequest.ViewDescriptor viewDescriptor;
        IElementType elementType;

        public CustomVertexCreateElementCommand(TransactionalEditingDomain domain, CreateViewRequest.ViewDescriptor viewDescriptor, IElementType elementType, IAdaptable adaptable, String label) {
            super(domain, label, null);
            this.adaptable = adaptable;
            this.viewDescriptor = viewDescriptor;
            this.elementType = elementType;
            this.setResult(CommandResult.newOKCommandResult((Object)viewDescriptor));
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            View regionView = (View)this.adaptable.getAdapter(View.class);
            View compartment = (View)regionView.getChildren().get(0);
            CreateElementRequest createElementRequest = new CreateElementRequest(regionView.getElement(), this.elementType);
            ICommand createElementCommand = this.elementType.getEditCommand((IEditCommandRequest)createElementRequest);
            if (createElementCommand != null && createElementCommand.canExecute()) {
                createElementCommand.execute(monitor, info);
            }
            Vertex newVertex = (Vertex)createElementRequest.getNewElement();
            View view = ViewService.getInstance().createView(this.viewDescriptor.getViewKind(), (IAdaptable)new SemanticAdapter((EObject)newVertex, null), compartment, this.viewDescriptor.getSemanticHint(), this.viewDescriptor.getIndex(), this.viewDescriptor.isPersisted(), this.viewDescriptor.getPreferencesHint());
            Assert.isNotNull((Object)view, (String)"failed to create a view");
            this.viewDescriptor.setView(view);
            return CommandResult.newOKCommandResult((Object)this.viewDescriptor);
        }
    }
}

