/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.cell;

import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.nattable.manager.cell.ICellManager;
import org.eclipse.papyrus.infra.nattable.manager.cell.IUnsetValueCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;
import org.eclipse.papyrus.infra.ui.converter.ConvertedValueContainer;

public abstract class AbstractCellManager
implements ICellManager,
IUnsetValueCellManager {
    @Override
    public final Object getValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return this.doGetValue(columnElement, rowElement, tableManager);
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return null;
    }

    @Override
    public void setValue(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        Command cmd = this.getSetValueCommand(domain, columnElement, rowElement, newValue, tableManager);
        if (cmd != null && cmd.canExecute()) {
            domain.getCommandStack().execute(cmd);
        }
    }

    @Override
    public boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return false;
    }

    @Override
    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        return null;
    }

    @Override
    public Command getSetStringValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, String newValue, AbstractStringValueConverter valueSolver, INattableModelManager tableManager) {
        return null;
    }

    @Override
    public AbstractStringValueConverter getOrCreateStringValueConverterClass(Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters, String multiValueSeparator, INattableModelManager tableManager) {
        AbstractStringValueConverter converter = existingConverters.get(this.getClass());
        if (converter == null) {
            converter = new AbstractStringValueConverter(){

                public void dispose() {
                }

                protected ConvertedValueContainer<?> doDeduceValueFromString(Object type, String valueAsString) {
                    return null;
                }
            };
            existingConverters.put(converter.getClass(), converter);
        }
        return converter;
    }

    @Override
    public boolean isCellEditable(Object columnElement, Object rowElement, Map<?, ?> sharedMap, INattableModelManager tableManager) {
        return this.isCellEditable(columnElement, rowElement, tableManager);
    }

    @Override
    public void setStringValue(Object columnElement, Object rowElement, String valueAsString, AbstractStringValueConverter valueConverter, Map<?, ?> sharedMap, INattableModelManager tableManager) {
    }

    @Override
    public void unsetCellValue(TransactionalEditingDomain domain, Object columnElement, Object rowElement, INattableModelManager tableManager) {
    }

    @Override
    public Command getUnsetCellValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return null;
    }
}

