/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.fillhandle.command;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.fillhandle.command.FillHandlePasteCommand;
import org.eclipse.nebula.widgets.nattable.fillhandle.command.FillHandlePasteCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.fillhandle.command.PapyrusFillHandlePasteCommand;
import org.eclipse.papyrus.infra.nattable.fillhandle.utils.PapyrusFillHandleUtils;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;

public class PapyrusFillHandlePasteCommandHandler
extends FillHandlePasteCommandHandler {
    protected INattableModelManager tableManager;
    protected FillHandlePasteCommand command;

    public PapyrusFillHandlePasteCommandHandler(SelectionLayer selectionLayer, InternalCellClipboard clipboard, INattableModelManager tableManager) {
        super(selectionLayer, clipboard);
        this.tableManager = tableManager;
    }

    public boolean doCommand(final ILayer targetLayer, final FillHandlePasteCommand command) {
        TransactionalEditingDomain domain = TableEditingDomainUtils.getTableContextEditingDomain(this.tableManager.getTable());
        AbstractTransactionalCommand transactionalCommand = new AbstractTransactionalCommand(domain, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                boolean result = PapyrusFillHandlePasteCommandHandler.super.doCommand(targetLayer, command);
                return CommandResult.newOKCommandResult((Object)result);
            }
        };
        domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)transactionalCommand));
        return (Boolean)transactionalCommand.getCommandResult().getReturnValue();
    }

    protected Object getPasteValue(ILayerCell cell, FillHandlePasteCommand command, int toColumn, int toRow) {
        boolean isEditable;
        Object value;
        String result = null;
        this.command = command;
        if (command instanceof PapyrusFillHandlePasteCommand && (value = cell.getDataValue()) instanceof String && FillHandlePasteCommand.FillHandleOperation.SERIES.equals((Object)command.operation)) {
            String stringValue;
            result = stringValue = (String)value;
            String templateString = "";
            String numberString = "";
            String templateStringWithoutBeginningNumber = PapyrusFillHandleUtils.getTemplateWithoutBeginningNumber(stringValue);
            String templateStringWithoutEndingNumber = PapyrusFillHandleUtils.getTemplateWithoutEndingNumber(stringValue);
            String beginningNumberString = stringValue.replace(templateStringWithoutBeginningNumber, "");
            String endingNumberString = stringValue.replace(templateStringWithoutEndingNumber, "");
            boolean isBeginningByNumber = PapyrusFillHandleUtils.isBeginningByNumber(stringValue, beginningNumberString);
            boolean isEndingByNumber = PapyrusFillHandleUtils.isEndingByNumber(stringValue, endingNumberString);
            if (isBeginningByNumber && isEndingByNumber) {
                isBeginningByNumber = ((PapyrusFillHandlePasteCommand)command).isPrefix();
                boolean bl = isEndingByNumber = !isBeginningByNumber;
                if (isBeginningByNumber) {
                    templateString = PapyrusFillHandleUtils.getTemplateWithoutBeginningNumber(stringValue);
                    numberString = beginningNumberString;
                } else {
                    templateString = PapyrusFillHandleUtils.getTemplateWithoutEndingNumber(stringValue);
                    numberString = endingNumberString;
                }
            }
            if (templateString.isEmpty() && numberString.isEmpty()) {
                if (isBeginningByNumber) {
                    templateString = PapyrusFillHandleUtils.getTemplateWithoutBeginningNumber(stringValue);
                    numberString = beginningNumberString;
                } else {
                    templateString = PapyrusFillHandleUtils.getTemplateWithoutEndingNumber(stringValue);
                    numberString = endingNumberString;
                }
            }
            if (!numberString.isEmpty()) {
                int intValue = Integer.parseInt(numberString);
                Number diff = 0;
                if (SelectionLayer.MoveDirectionEnum.LEFT == command.direction || SelectionLayer.MoveDirectionEnum.RIGHT == command.direction) {
                    diff = this.calculateVerticalStringDiff(templateString, cell, toColumn);
                } else if (SelectionLayer.MoveDirectionEnum.UP == command.direction || SelectionLayer.MoveDirectionEnum.DOWN == command.direction) {
                    diff = this.calculateHorizontalStringDiff(templateString, cell, toRow);
                }
                if (diff != null) {
                    int newValue = 0;
                    newValue = ((PapyrusFillHandlePasteCommand)command).isIncrement() ? intValue + (Integer)diff : intValue - (Integer)diff;
                    String numDigitsFormat = PapyrusFillHandleUtils.getZeroLeadingFormatString(numberString.length(), newValue);
                    String newValueString = String.format(numDigitsFormat, newValue);
                    if (isBeginningByNumber) {
                        result = String.valueOf(newValueString) + templateString;
                    } else if (isEndingByNumber) {
                        result = String.valueOf(templateString) + newValueString;
                    }
                }
            }
        }
        return !(isEditable = EditUtils.isCellEditable((ILayer)this.selectionLayer, (IConfigRegistry)command.configRegistry, (PositionCoordinate)new PositionCoordinate((ILayer)this.selectionLayer, cell.getColumnIndex(), cell.getRowIndex()))) || result != null ? result : super.getPasteValue(cell, command, toColumn, toRow);
    }

    protected Number calculateHorizontalDiff(ILayerCell cell, int toRow, IConfigRegistry configRegistry) {
        Number diff = super.calculateHorizontalDiff(cell, toRow, configRegistry);
        if (this.command instanceof PapyrusFillHandlePasteCommand && (SelectionLayer.MoveDirectionEnum.UP == this.command.direction && !((PapyrusFillHandlePasteCommand)this.command).isIncrement() || SelectionLayer.MoveDirectionEnum.DOWN == this.command.direction && !((PapyrusFillHandlePasteCommand)this.command).isIncrement())) {
            if (diff instanceof Byte) {
                diff = 0 - diff.byteValue();
            } else if (diff instanceof Short) {
                diff = 0 - diff.shortValue();
            } else if (diff instanceof Integer) {
                diff = 0 - diff.intValue();
            } else if (diff instanceof Long) {
                diff = 0L - diff.longValue();
            } else if (diff instanceof Float) {
                diff = Float.valueOf(0.0f - diff.floatValue());
            } else if (diff instanceof Double) {
                diff = 0.0 - diff.doubleValue();
            } else if (diff instanceof BigInteger) {
                diff = BigInteger.ZERO.subtract((BigInteger)diff);
            } else if (diff instanceof BigDecimal) {
                diff = BigDecimal.ZERO.subtract((BigDecimal)diff);
            }
        }
        return diff;
    }

    protected Number calculateVerticalDiff(ILayerCell cell, int toColumn, IConfigRegistry configRegistry) {
        Number diff = super.calculateVerticalDiff(cell, toColumn, configRegistry);
        if (this.command instanceof PapyrusFillHandlePasteCommand && (SelectionLayer.MoveDirectionEnum.LEFT == this.command.direction && !((PapyrusFillHandlePasteCommand)this.command).isIncrement() || SelectionLayer.MoveDirectionEnum.RIGHT == this.command.direction && !((PapyrusFillHandlePasteCommand)this.command).isIncrement())) {
            if (diff instanceof Byte) {
                diff = 0 - diff.byteValue();
            } else if (diff instanceof Short) {
                diff = 0 - diff.shortValue();
            } else if (diff instanceof Integer) {
                diff = 0 - diff.intValue();
            } else if (diff instanceof Long) {
                diff = 0L - diff.longValue();
            } else if (diff instanceof Float) {
                diff = Float.valueOf(0.0f - diff.floatValue());
            } else if (diff instanceof Double) {
                diff = 0.0 - diff.doubleValue();
            } else if (diff instanceof BigInteger) {
                diff = BigInteger.ZERO.subtract((BigInteger)diff);
            } else if (diff instanceof BigDecimal) {
                diff = BigDecimal.ZERO.subtract((BigDecimal)diff);
            }
        }
        return diff;
    }

    protected Number calculateVerticalStringDiff(String templateString, ILayerCell cell, int toColumn) {
        ILayerCell[][] cells = this.clipboard.getCopiedCells();
        int columnDiff = this.getColumnDiff(cell, toColumn);
        int rowArrayIndex = cell.getRowIndex() - this.clipboard.getCopiedCells()[0][0].getRowIndex();
        if (1 == cells[rowArrayIndex].length) {
            return columnDiff;
        }
        Integer diff = this.calculateStringDiff(cells[rowArrayIndex][1], cells[rowArrayIndex][0], templateString);
        if (diff == null) {
            return null;
        }
        Integer temp = diff;
        int i = 1;
        while (i < cells.length) {
            temp = this.calculateStringDiff(cells[rowArrayIndex][i], cells[rowArrayIndex][i - 1], templateString);
            if (temp == null || !temp.equals(diff)) {
                return null;
            }
            ++i;
        }
        return diff * columnDiff;
    }

    protected Number calculateHorizontalStringDiff(String templateString, ILayerCell cell, int toRow) {
        ILayerCell[][] cells = this.clipboard.getCopiedCells();
        int rowDiff = this.getRowDiff(cell, toRow);
        if (cells.length == 1) {
            return rowDiff;
        }
        int columnArrayIndex = cell.getColumnIndex() - this.clipboard.getCopiedCells()[0][0].getColumnIndex();
        Integer diff = this.calculateStringDiff(cells[1][columnArrayIndex], cells[0][columnArrayIndex], templateString);
        if (diff == null) {
            return null;
        }
        Integer temp = diff;
        int i = 1;
        while (i < cells.length) {
            temp = this.calculateStringDiff(cells[i][columnArrayIndex], cells[i - 1][columnArrayIndex], templateString);
            if (temp == null || !temp.equals(diff)) {
                return null;
            }
            ++i;
        }
        return diff * rowDiff;
    }

    protected Integer calculateStringDiff(ILayerCell c1, ILayerCell c2, String templateString) {
        Integer diff = null;
        if (c1.getDataValue() != null && c2.getDataValue() != null && c1.getDataValue() instanceof String && c2.getDataValue() instanceof String && ((String)c1.getDataValue()).contains(templateString) && ((String)c2.getDataValue()).contains(templateString)) {
            try {
                diff = new Integer(Integer.parseInt(((String)c1.getDataValue()).replace(templateString, "")) - Integer.parseInt(((String)c2.getDataValue()).replace(templateString, "")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return diff;
    }

    protected int getRowDiff(ILayerCell currentCell, int toRow) {
        int rowDiff = 0;
        int lower = 0;
        int upper = 0;
        if (toRow > currentCell.getRowIndex()) {
            lower = currentCell.getRowIndex();
            upper = toRow;
        } else {
            lower = toRow;
            upper = currentCell.getRowIndex();
        }
        int index = lower;
        while (index < upper) {
            Object rowElement = AxisUtils.getRepresentedElement(this.tableManager.getRowElement(index));
            Object columnElement = AxisUtils.getRepresentedElement(this.tableManager.getColumnElement(currentCell.getColumnIndex()));
            boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnElement, rowElement, this.tableManager);
            if (isEditable) {
                ++rowDiff;
            }
            ++index;
        }
        return rowDiff;
    }

    protected int getColumnDiff(ILayerCell currentCell, int toColumn) {
        int columnDiff = 0;
        int lower = 0;
        int upper = 0;
        if (toColumn > currentCell.getColumnIndex()) {
            lower = currentCell.getColumnIndex();
            upper = toColumn;
        } else {
            lower = toColumn;
            upper = currentCell.getColumnIndex();
        }
        int index = lower;
        while (index < upper) {
            Object rowElement = AxisUtils.getRepresentedElement(this.tableManager.getRowElement(currentCell.getRowIndex()));
            Object columnElement = AxisUtils.getRepresentedElement(this.tableManager.getColumnElement(index));
            boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnElement, rowElement, this.tableManager);
            if (isEditable) {
                ++columnDiff;
            }
            ++index;
        }
        return columnDiff;
    }
}

