/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.preferences.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConstraint;
import org.eclipse.papyrus.extensionpoints.editors.definition.IDirectEditorExtensionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectEditorTreeItem {
    private String metaClassToEdit;
    private List<IDirectEditorExtensionPoint> configurationsList;

    public DirectEditorTreeItem(List<IDirectEditorExtensionPoint> configurations) {
        this.metaClassToEdit = configurations.get(0).getObjectToEdit();
        this.configurationsList = configurations;
    }

    public List<IDirectEditorConstraint> getMetaClassConstraints() {
        ArrayList<IDirectEditorConstraint> constraintsList = new ArrayList<IDirectEditorConstraint>();
        for (IDirectEditorExtensionPoint configuration : this.configurationsList) {
            IDirectEditorConstraint constraint = configuration.getAdditionalConstraint();
            if (constraint == null) continue;
            constraintsList.add(constraint);
        }
        return constraintsList;
    }

    public String getMetaClassToEdit() {
        return this.metaClassToEdit;
    }

    public List<IDirectEditorExtensionPoint> getConfigurations() {
        ArrayList<IDirectEditorExtensionPoint> nonConstraintCopnfiguration = new ArrayList<IDirectEditorExtensionPoint>();
        for (IDirectEditorExtensionPoint configuration : this.configurationsList) {
            if (configuration.getAdditionalConstraint() != null) continue;
            nonConstraintCopnfiguration.add(configuration);
        }
        return nonConstraintCopnfiguration;
    }

    public List<IDirectEditorExtensionPoint> getConstrainedEditor(IDirectEditorConstraint selectedElement) {
        ArrayList<IDirectEditorExtensionPoint> constrainedDirectEditorsList = new ArrayList<IDirectEditorExtensionPoint>();
        if (selectedElement != null) {
            for (IDirectEditorExtensionPoint configuration : this.configurationsList) {
                IDirectEditorConstraint additionalConstraint = configuration.getAdditionalConstraint();
                if (additionalConstraint == null || !selectedElement.equals(additionalConstraint)) continue;
                constrainedDirectEditorsList.add(configuration);
            }
        }
        return constrainedDirectEditorsList;
    }
}

