/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.ConditionChecker;
import org.eclipse.ocl.examples.debug.vm.IVMDebuggerShell;
import org.eclipse.ocl.examples.debug.vm.IVMVirtualMachineShell;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.VMBreakpoint;
import org.eclipse.ocl.examples.debug.vm.VMBreakpointManager;
import org.eclipse.ocl.examples.debug.vm.VariableFinder;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugTarget;
import org.eclipse.ocl.examples.debug.vm.core.VMLocalValue;
import org.eclipse.ocl.examples.debug.vm.data.VMBreakpointData;
import org.eclipse.ocl.examples.debug.vm.data.VMNewBreakpointData;
import org.eclipse.ocl.examples.debug.vm.data.VMStackFrameData;
import org.eclipse.ocl.examples.debug.vm.evaluator.IDebuggableRunnerFactory;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMEvaluationStepper;
import org.eclipse.ocl.examples.debug.vm.event.VMEvent;
import org.eclipse.ocl.examples.debug.vm.event.VMStartEvent;
import org.eclipse.ocl.examples.debug.vm.event.VMTerminateEvent;
import org.eclipse.ocl.examples.debug.vm.launching.DebuggableRunner;
import org.eclipse.ocl.examples.debug.vm.launching.VMDebuggableExecutorAdapter;
import org.eclipse.ocl.examples.debug.vm.request.VMBreakpointRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMDetailRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMStackFrameRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMStartRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMVariableRequest;
import org.eclipse.ocl.examples.debug.vm.response.VMBreakpointResponse;
import org.eclipse.ocl.examples.debug.vm.response.VMDetailResponse;
import org.eclipse.ocl.examples.debug.vm.response.VMResponse;
import org.eclipse.ocl.examples.debug.vm.response.VMStackFrameResponse;
import org.eclipse.ocl.examples.debug.vm.utils.DebugOptions;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;

public abstract class VMVirtualMachine
implements IVMVirtualMachineShell {
    public static final @NonNull TracingOption LOCATION = new TracingOption("org.eclipse.ocl.examples.debug.vm", "location");
    public static final @NonNull TracingOption PRE_VISIT = new TracingOption("org.eclipse.ocl.examples.debug.vm", "pre-visit");
    public static final @NonNull TracingOption POST_VISIT = new TracingOption("org.eclipse.ocl.examples.debug.vm", "post-visit");
    public static final @NonNull TracingOption VISITOR_STACK = new TracingOption("org.eclipse.ocl.examples.debug.vm", "visitorStack");
    public static final @NonNull TracingOption VM_EVENT = new TracingOption("org.eclipse.ocl.examples.debug.vm", "vmEvent");
    public static final @NonNull TracingOption VM_REQUEST = new TracingOption("org.eclipse.ocl.examples.debug.vm", "vmRequest");
    public static final @NonNull TracingOption VM_RESPONSE = new TracingOption("org.eclipse.ocl.examples.debug.vm", "vmResponse");
    private final List<VMRequest> fRequests = new ArrayList<VMRequest>();
    private final BlockingQueue<VMEvent> fEvents = new ArrayBlockingQueue<VMEvent>(50);
    private DebuggableRunner runner;
    private final @NonNull IVMDebuggerShell fDebuggerShell;
    private final @NonNull VMBreakpointManager fBreakpointManager;
    private @Nullable VMEvaluationStepper fInterpreter;
    private VMDebuggableExecutorAdapter fExecutor;
    private boolean fRunning;
    private boolean fTerminated;
    private int fExitCode = -3;
    private Object fStateMonitor = new Object();
    private final Object fLock = new Object();

    private static int execute(@NonNull VMDebuggableExecutorAdapter executorAdapter, @NonNull VMStartRequest startRequest) {
        int exitCode = 0;
        try {
            Diagnostic diagnostic = executorAdapter.execute(startRequest);
            int severity = diagnostic.getSeverity();
            if (severity == 4 || severity == 8) {
                System.err.println(diagnostic.toString());
                exitCode = -1;
            }
        }
        catch (Throwable e) {
            exitCode = -2;
            e.printStackTrace();
        }
        return exitCode;
    }

    public static @Nullable UnitLocation lookupEnvironmentByID(long id, @NonNull List<UnitLocation> stack) {
        for (UnitLocation location : stack) {
            VMEvaluationEnvironment evalEnv = location.getEvalEnv();
            if (evalEnv.getID() != id) continue;
            return location;
        }
        return null;
    }

    protected VMVirtualMachine(@NonNull DebuggableRunner runner, @NonNull VMDebuggableExecutorAdapter executorAdapter) {
        this.runner = runner;
        this.fExecutor = executorAdapter;
        this.fDebuggerShell = new DebuggerShell();
        this.fBreakpointManager = new VMBreakpointManager(this, executorAdapter.getUnit());
        this.fTerminated = false;
    }

    private @NonNull Runnable createVMRunnable(final @NonNull VMStartRequest startRequest) {
        return new Runnable(){

            @Override
            public void run() {
                int exitCode = -1;
                try {
                    try {
                        VMVirtualMachine.this.fExecutor.connect(VMVirtualMachine.this.fDebuggerShell);
                        exitCode = VMVirtualMachine.execute((VMDebuggableExecutorAdapter)ClassUtil.nonNullState((Object)VMVirtualMachine.this.fExecutor), startRequest);
                    }
                    catch (Throwable e) {
                        VMVirtualMachine.this.getDebugCore().log(e);
                        VMVirtualMachine.this.fDebuggerShell.handleVMEvent(new VMTerminateEvent(exitCode));
                    }
                }
                finally {
                    VMVirtualMachine.this.fDebuggerShell.handleVMEvent(new VMTerminateEvent(exitCode));
                }
            }
        };
    }

    public abstract @NonNull VMBreakpoint createBreakpoint(@NonNull Element var1, @NonNull VMNewBreakpointData var2, boolean var3);

    public abstract @NonNull VMBreakpoint createBreakpoint(@NonNull Element var1, long var2, int var4, @NonNull String var5, boolean var6);

    public @Nullable VMStackFrameData createStackFrame(long frameID, @NonNull List<UnitLocation> stack) {
        UnitLocation location = VMVirtualMachine.lookupEnvironmentByID(frameID, stack);
        if (location != null) {
            return this.createStackFrame(location);
        }
        return null;
    }

    protected abstract @Nullable VMStackFrameData createStackFrame(@NonNull UnitLocation var1);

    public IValue evaluate(@NonNull String expressionText, VMDebugTarget debugTarget, long frameID) throws CoreException {
        VMEvaluationStepper fInterpreter2 = this.fInterpreter;
        if (fInterpreter2 == null) {
            return null;
        }
        Element astNode = fInterpreter2.getCurrentLocation().getElement();
        if (astNode == null) {
            return null;
        }
        ConditionChecker localChecker = new ConditionChecker(expressionText, astNode);
        VMLocalValue.LocalValue lv = new VMLocalValue.LocalValue();
        lv.valueObject = localChecker.evaluate(fInterpreter2);
        lv.valueType = localChecker.getConditionType();
        return new VMLocalValue(debugTarget, frameID, new String[]{expressionText}, lv, fInterpreter2.getVMEvaluationEnvironment());
    }

    public @Nullable EvaluationEnvironment getEvaluationEnv() {
        VMEvaluationStepper fInterpreter2 = this.fInterpreter;
        if (fInterpreter2 == null) {
            return null;
        }
        return fInterpreter2.getVMEvaluationEnvironment();
    }

    public int getExitCode() {
        return this.fExitCode;
    }

    public @NonNull DebuggableRunner getRunner() {
        return (DebuggableRunner)ClassUtil.nonNullState((Object)this.runner);
    }

    public @NonNull IDebuggableRunnerFactory getRunnerFactory() {
        return this.runner.getRunnerFactory();
    }

    private @NonNull VMBreakpointResponse handleBreakPointRequest(@NonNull VMBreakpointRequest request) {
        VMBreakpointRequest.ActionKind actionKind = request.getActionKind();
        if (actionKind == VMBreakpointRequest.ActionKind.ADD) {
            List<VMBreakpointData> allBpData = request.getBreakpointData();
            if (allBpData != null) {
                ArrayList<Long> addedBpIDs = new ArrayList<Long>();
                for (VMBreakpointData bpData : allBpData) {
                    if (!(bpData instanceof VMNewBreakpointData)) continue;
                    VMNewBreakpointData newBreakpoint = (VMNewBreakpointData)bpData;
                    VMBreakpoint breakpoint = this.fBreakpointManager.createBreakpoint(newBreakpoint);
                    if (breakpoint != null) {
                        addedBpIDs.add(new Long(newBreakpoint.getID()));
                        this.getDebugCore().getTrace().trace(DebugOptions.VM, "Installing breakpoint:  line:" + newBreakpoint.getLine() + " " + newBreakpoint.getTargetURI());
                        continue;
                    }
                    this.getDebugCore().getTrace().trace(DebugOptions.VM, "Failed to create breakpoint:  line:" + newBreakpoint.getLine() + " " + newBreakpoint.getTargetURI());
                }
                return new VMBreakpointResponse(addedBpIDs);
            }
        } else if (actionKind == VMBreakpointRequest.ActionKind.REMOVE) {
            this.fBreakpointManager.removeBreakpoint(request.getBreakpointID());
        } else if (actionKind == VMBreakpointRequest.ActionKind.CHANGE) {
            this.fBreakpointManager.changeBreakpoint(request.getBreakpointID(), request.getFirstBreakpointData());
        }
        return new VMBreakpointResponse();
    }

    private @NonNull VMResponse handleStackFrameRequest(@NonNull VMStackFrameRequest request) {
        List<UnitLocation> locationStack;
        VMStackFrameData frame;
        VMEvaluationStepper fInterpreter2 = this.fInterpreter;
        if (fInterpreter2 != null && (frame = this.createStackFrame(request.frameID, locationStack = fInterpreter2.getLocationStack())) != null) {
            VMStackFrameResponse response = new VMStackFrameResponse(frame);
            if (!locationStack.isEmpty()) {
                UnitLocation topLocation = locationStack.get(0);
                response.isDeferredExecution = topLocation.isDeferredExecution();
            }
            return response;
        }
        return VMResponse.createERROR();
    }

    private @Nullable VMResponse handleValueDetailRequest(@NonNull VMDetailRequest request) {
        VMEvaluationStepper fInterpreter2 = this.fInterpreter;
        if (fInterpreter2 != null) {
            VMEvaluationEnvironment vmEvaluationEnvironment = fInterpreter2.getCurrentLocation().getEvalEnv();
            VariableFinder variableFinder = VariableFinder.newInstance(vmEvaluationEnvironment, true);
            String detail = variableFinder.computeDetail(request.getVariableURI());
            return new VMDetailResponse(detail != null ? detail : "");
        }
        return null;
    }

    private @Nullable VMResponse handleVariableRequest(@NonNull VMVariableRequest request) {
        VMEvaluationStepper fInterpreter2 = this.fInterpreter;
        if (fInterpreter2 != null) {
            VMEvaluationEnvironment vmEvaluationEnvironment = fInterpreter2.getCurrentLocation().getEvalEnv();
            VariableFinder variableFinder = VariableFinder.newInstance(vmEvaluationEnvironment, true);
            return variableFinder.process(request, fInterpreter2.getLocationStack());
        }
        return null;
    }

    @Override
    public boolean isTerminated() {
        return this.fTerminated;
    }

    @Override
    public VMEvent readVMEvent() throws IOException {
        try {
            return this.fEvents.take();
        }
        catch (InterruptedException e) {
            throw new IOException("Waiting for event interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull VMResponse sendRequest(@NonNull VMRequest request) throws IOException {
        VMResponse response = null;
        try {
            if (request instanceof VMStartRequest) {
                if (VM_REQUEST.isActive()) {
                    VM_REQUEST.println(">[" + Thread.currentThread().getName() + "] " + request);
                }
                response = this.start((VMStartRequest)request);
            } else if (request instanceof VMBreakpointRequest) {
                if (VM_REQUEST.isActive()) {
                    VM_REQUEST.println(">[" + Thread.currentThread().getName() + "] " + request);
                }
                response = this.handleBreakPointRequest((VMBreakpointRequest)request);
            } else if (request instanceof VMStackFrameRequest) {
                if (VM_REQUEST.isActive()) {
                    VM_REQUEST.println(">[" + Thread.currentThread().getName() + "] " + request);
                }
                response = this.handleStackFrameRequest((VMStackFrameRequest)request);
            } else if (request instanceof VMVariableRequest) {
                if (VM_REQUEST.isActive()) {
                    VM_REQUEST.println(">[" + Thread.currentThread().getName() + "] " + request);
                }
                response = this.handleVariableRequest((VMVariableRequest)request);
            } else if (request instanceof VMDetailRequest) {
                if (VM_REQUEST.isActive()) {
                    VM_REQUEST.println(">[" + Thread.currentThread().getName() + "] " + request);
                }
                response = this.handleValueDetailRequest((VMDetailRequest)request);
            }
        }
        catch (RuntimeException e) {
            this.getDebugCore().log(e);
            response = VMResponse.createERROR();
        }
        if (response != null) {
            if (VM_RESPONSE.isActive()) {
                VM_RESPONSE.println("<[" + Thread.currentThread().getName() + "] " + response);
            }
            return response;
        }
        if (VM_REQUEST.isActive()) {
            VM_REQUEST.println("?[" + Thread.currentThread().getName() + "] " + request);
        }
        Object object = this.fLock;
        synchronized (object) {
            this.fRequests.add(request);
            this.fLock.notifyAll();
        }
        response = VMResponse.createOK();
        if (VM_RESPONSE.isActive()) {
            VM_RESPONSE.println("<[" + Thread.currentThread().getName() + "] " + response);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @NonNull VMResponse start(@NonNull VMStartRequest startRequest) {
        Thread executorThread = new Thread(this.createVMRunnable(startRequest), this.getDebugCore().getVMThreadName());
        Object object = this.fStateMonitor;
        synchronized (object) {
            if (this.fRunning) {
                return VMResponse.createERROR();
            }
            executorThread.start();
            while (!this.fRunning && !this.fTerminated) {
                try {
                    this.fStateMonitor.wait();
                }
                catch (InterruptedException e) {
                    this.getDebugCore().log(this.getDebugCore().createStatus(4, "VM startup process interrupted"));
                }
            }
        }
        return VMResponse.createOK();
    }

    private class DebuggerShell
    implements IVMDebuggerShell {
        private DebuggerShell() {
        }

        @Override
        public @NonNull VMBreakpointManager getBreakPointManager() {
            return VMVirtualMachine.this.fBreakpointManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleVMEvent(@NonNull VMEvent event) {
            if (VM_EVENT.isActive()) {
                VM_EVENT.println("?[" + Thread.currentThread().getName() + "] " + event.toString());
            }
            if (event instanceof VMStartEvent) {
                Object object = VMVirtualMachine.this.fStateMonitor;
                synchronized (object) {
                    VMVirtualMachine.this.fRunning = true;
                    VMVirtualMachine.this.fStateMonitor.notify();
                }
            }
            if (event instanceof VMTerminateEvent) {
                Object object = VMVirtualMachine.this.fStateMonitor;
                synchronized (object) {
                    VMVirtualMachine.this.fRunning = false;
                    VMVirtualMachine.this.fTerminated = true;
                    VMVirtualMachine.this.fExitCode = ((VMTerminateEvent)event).getExitCode();
                    VMVirtualMachine.this.fInterpreter = null;
                    VMVirtualMachine.this.fExecutor = null;
                    VMVirtualMachine.this.runner = null;
                    VMVirtualMachine.this.fStateMonitor.notify();
                }
            }
            try {
                VMVirtualMachine.this.fEvents.add(event);
            }
            catch (IllegalStateException e) {
                System.err.println("Event queue full!!!!");
            }
        }

        @Override
        public boolean isSessionStarted() {
            return VMVirtualMachine.this.fInterpreter != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VMRequest peekRequest() {
            Object object = VMVirtualMachine.this.fLock;
            synchronized (object) {
                return VMVirtualMachine.this.fRequests.isEmpty() ? null : (VMRequest)VMVirtualMachine.this.fRequests.get(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @Nullable VMRequest popRequest() {
            Object object = VMVirtualMachine.this.fLock;
            synchronized (object) {
                return VMVirtualMachine.this.fRequests.isEmpty() ? null : (VMRequest)VMVirtualMachine.this.fRequests.remove(0);
            }
        }

        @Override
        public void sessionStarted(@NonNull VMEvaluationStepper evaluator) {
            VMVirtualMachine.this.fInterpreter = evaluator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @Nullable VMRequest waitAndPopRequest(@NonNull VMEvent suspend) throws InterruptedException {
            this.handleVMEvent(suspend);
            Object object = VMVirtualMachine.this.fLock;
            synchronized (object) {
                while (VMVirtualMachine.this.fRequests.isEmpty()) {
                    VMVirtualMachine.this.fLock.wait();
                }
                VMRequest request = (VMRequest)VMVirtualMachine.this.fRequests.remove(0);
                if (VM_REQUEST.isActive()) {
                    VM_REQUEST.println(">[" + Thread.currentThread().getName() + "] " + request);
                }
                return request;
            }
        }
    }
}

