/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.ui.launching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.launching.OCLLaunchConstants;
import org.eclipse.ocl.examples.debug.ui.OCLDebugUIPlugin;
import org.eclipse.ocl.examples.debug.ui.launching.AbstractMainTab;
import org.eclipse.ocl.examples.debug.vm.ui.launching.LaunchingUtils;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MainTab
extends AbstractMainTab
implements OCLLaunchConstants {
    protected Text oclPath;
    protected Button oclBrowseWS;
    protected Button oclBrowseFile;
    protected Button modelBrowseWS;
    protected Button modelBrowseFile;
    protected Group modelGroup;
    protected Group elementGroup;
    protected Combo expressionCombo;
    protected Combo elementCombo;
    private Group expressionGroup;
    private Text modelPath;
    private Map<String, URI> expression2uri = new HashMap<String, URI>();
    private Map<String, URI> element2uri = new HashMap<String, URI>();

    public boolean canSave() {
        String oclName;
        URI oclURI;
        assert (!this.initializing);
        ResourceSet resourceSet = this.getEnvironmentFactory().getResourceSet();
        URIConverter uriConverter = resourceSet.getURIConverter();
        boolean oclExists = uriConverter.exists(oclURI = URI.createURI((String)(oclName = this.oclPath.getText()), (boolean)true), null);
        if (!oclExists) {
            this.setErrorMessage("Selected OCL file '" + oclName + "' does not exist");
            return false;
        }
        String modelName = this.oclPath.getText();
        URI modelURI = URI.createURI((String)modelName, (boolean)true);
        boolean modelExists = uriConverter.exists(modelURI, null);
        if (!modelExists) {
            this.setErrorMessage("Selected Model file '" + modelName + "' does not exist");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void createControl(Composite parent) {
        Composite control = this.createForm(parent);
        this.oclPath.addModifyListener((ModifyListener)new ExpressionPathModifyListener());
        this.expressionCombo.addModifyListener((ModifyListener)new ExpressionModifyListener());
        this.modelPath.addModifyListener((ModifyListener)new ContextPathModifyListener());
        this.elementCombo.addModifyListener((ModifyListener)new ContextModifyListener());
        LaunchingUtils.prepareBrowseWorkspaceButton((Button)this.oclBrowseWS, (Text)this.oclPath, (boolean)false);
        LaunchingUtils.prepareBrowseFileSystemButton((Button)this.oclBrowseFile, (Text)this.oclPath, (boolean)false);
        LaunchingUtils.prepareBrowseWorkspaceButton((Button)this.modelBrowseWS, (Text)this.modelPath, (boolean)false);
        LaunchingUtils.prepareBrowseFileSystemButton((Button)this.modelBrowseFile, (Text)this.modelPath, (boolean)false);
        control.setBounds(0, 0, 300, 300);
        control.layout();
        control.pack();
    }

    public Composite createForm(Composite parent) {
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Group oclGroup = new Group(control, 0);
        oclGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        oclGroup.setText("OCL");
        oclGroup.setLayout((Layout)new GridLayout(3, false));
        this.oclPath = new Text((Composite)oclGroup, 2048);
        GridData gd_oclPath = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_oclPath.minimumWidth = 100;
        this.oclPath.setLayoutData((Object)gd_oclPath);
        this.oclBrowseWS = new Button((Composite)oclGroup, 0);
        this.oclBrowseWS.setText("Browse Workspace...");
        this.oclBrowseFile = new Button((Composite)oclGroup, 0);
        this.oclBrowseFile.setText("Browse File...");
        this.expressionGroup = new Group(control, 0);
        this.expressionGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_expressionGroup = new GridLayout(2, false);
        gl_expressionGroup.marginWidth = 0;
        gl_expressionGroup.marginHeight = 0;
        this.expressionGroup.setLayout((Layout)gl_expressionGroup);
        Label expressionLabel = new Label((Composite)this.expressionGroup, 8);
        expressionLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        expressionLabel.setText("Expression");
        this.expressionCombo = new Combo((Composite)this.expressionGroup, 0);
        this.expressionCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(control, 0);
        this.modelGroup = new Group(control, 0);
        this.modelGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.modelGroup.setText("Model");
        this.modelGroup.setLayout((Layout)new GridLayout(4, false));
        new Label((Composite)this.modelGroup, 0);
        this.modelPath = new Text((Composite)this.modelGroup, 2048);
        this.modelPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.modelBrowseWS = new Button((Composite)this.modelGroup, 0);
        this.modelBrowseWS.setText("Browse Workspace...");
        this.modelBrowseFile = new Button((Composite)this.modelGroup, 0);
        this.modelBrowseFile.setText("Browse File...");
        this.elementGroup = new Group(control, 0);
        this.elementGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout gl_elementGroup = new GridLayout(2, false);
        gl_elementGroup.marginWidth = 0;
        gl_elementGroup.marginHeight = 0;
        this.elementGroup.setLayout((Layout)gl_elementGroup);
        Label elementLabel = new Label((Composite)this.elementGroup, 0);
        elementLabel.setText("Element");
        this.elementCombo = new Combo((Composite)this.elementGroup, 8);
        this.elementCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        return control;
    }

    protected String getDisplayString(@NonNull ExpressionInOCL expressionInOCL) {
        String typeString = expressionInOCL.getOwnedContext().getType().toString();
        String expressionString = expressionInOCL.toString();
        String displayString = String.valueOf(typeString) + ": " + expressionString;
        return displayString;
    }

    public Image getImage() {
        return OCLDebugUIPlugin.getDefault().createImage("icons/OCLModelFile.gif");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        block13: {
            assert (!this.initializing);
            try {
                try {
                    String contextUri;
                    this.initializing = true;
                    String constraintUri = configuration.getAttribute("constraint", "");
                    if (constraintUri.length() > 0) {
                        LanguageExpression specification;
                        URI constraintURI = URI.createURI((String)constraintUri);
                        @NonNull URI oclASURI = constraintURI.trimFragment();
                        URI oclNonASURI = PivotUtilInternal.getNonASURI((URI)oclASURI);
                        this.oclPath.setText(String.valueOf(oclNonASURI));
                        EObject eObject = this.getEnvironmentFactory().getMetamodelManager().getASResourceSet().getEObject(constraintURI, true);
                        if (eObject instanceof Constraint && (specification = ((Constraint)eObject).getOwnedSpecification()) != null) {
                            try {
                                ExpressionInOCL query = this.getEnvironmentFactory().getMetamodelManager().parseSpecification(specification);
                                String displayString = this.getDisplayString(query);
                                int index = this.expressionCombo.indexOf(displayString);
                                this.expressionCombo.select(index);
                            }
                            catch (ParserException parserException) {}
                        }
                    } else {
                        this.oclPath.setText((String)ClassUtil.nonNullState((Object)configuration.getAttribute("ocl", "")));
                    }
                    if ((contextUri = configuration.getAttribute("context", "")).length() > 0) {
                        URI contextURI = URI.createURI((String)contextUri);
                        this.modelPath.setText(String.valueOf(contextURI.trimFragment()));
                        EObject eObject = this.getEnvironmentFactory().getResourceSet().getEObject(contextURI, true);
                        if (eObject != null) {
                            String displayString = LabelUtil.getLabel((Object)eObject);
                            int index = this.elementCombo.indexOf(displayString);
                            this.elementCombo.select(index);
                        }
                        break block13;
                    }
                    this.modelPath.setText((String)ClassUtil.nonNullState((Object)configuration.getAttribute("model", "")));
                }
                catch (CoreException coreException) {
                    this.initializing = false;
                    this.updateLaunchConfigurationDialog();
                }
            }
            finally {
                this.initializing = false;
                this.updateLaunchConfigurationDialog();
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int expressionIndex = this.expressionCombo.getSelectionIndex();
        if (expressionIndex >= 0 && expressionIndex < this.expressionCombo.getItemCount()) {
            String expressionText = this.expressionCombo.getItem(expressionIndex);
            URI expressionURI = this.expression2uri.get(expressionText);
            configuration.setAttribute("constraint", String.valueOf(expressionURI));
            configuration.removeAttribute("ocl");
        } else {
            configuration.setAttribute("ocl", this.oclPath.getText());
            configuration.setAttribute("constraint", "");
        }
        int elementIndex = this.elementCombo.getSelectionIndex();
        if (elementIndex >= 0 && elementIndex < this.elementCombo.getItemCount()) {
            String contextText = this.elementCombo.getItem(elementIndex);
            URI contextURI = this.element2uri.get(contextText);
            configuration.setAttribute("context", String.valueOf(contextURI));
            configuration.removeAttribute("model");
        } else {
            configuration.setAttribute("model", this.modelPath.getText());
            configuration.setAttribute("context", "");
        }
    }

    @Override
    protected void setDefaults(@NonNull ILaunchConfigurationWorkingCopy configuration, @NonNull IFile iFile) {
        configuration.setAttribute("ocl", iFile.getFullPath().toString());
    }

    protected class ContextModifyListener
    implements ModifyListener {
        protected ContextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (MainTab.this.elementCombo.isDisposed()) {
                return;
            }
            MainTab.this.updateLaunchConfigurationDialog();
        }
    }

    protected class ContextPathModifyListener
    implements ModifyListener {
        protected ContextPathModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (MainTab.this.modelPath.isDisposed()) {
                return;
            }
            String modelName = MainTab.this.modelPath.getText();
            URI contextURI = URI.createURI((String)modelName, (boolean)true);
            URI elementsURI = contextURI.trimFragment();
            try {
                Resource resource = MainTab.this.getEnvironmentFactory().getResourceSet().getResource(elementsURI, true);
                if (resource == null) {
                    throw new IOException("There was an error loading the model file. ");
                }
                ArrayList<String> elements = new ArrayList<String>();
                TreeIterator tit = resource.getAllContents();
                while (tit.hasNext()) {
                    EObject eObject = (EObject)tit.next();
                    String displayString = LabelUtil.getLabel((Object)eObject);
                    URI uri = EcoreUtil.getURI((EObject)eObject);
                    elements.add(displayString);
                    MainTab.this.element2uri.put(displayString, uri);
                }
                Collections.sort(elements);
                MainTab.this.elementCombo.setItems(elements.toArray(new String[elements.size()]));
            }
            catch (Exception ex) {
                MainTab.this.setErrorMessage("Failed to load '" + elementsURI + "': " + ex.toString());
            }
            MainTab.this.updateLaunchConfigurationDialog();
        }
    }

    protected class ExpressionModifyListener
    implements ModifyListener {
        protected ExpressionModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (MainTab.this.expressionCombo.isDisposed()) {
                return;
            }
            MainTab.this.updateLaunchConfigurationDialog();
        }
    }

    protected class ExpressionPathModifyListener
    implements ModifyListener {
        protected ExpressionPathModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (MainTab.this.oclPath.isDisposed()) {
                return;
            }
            String oclName = MainTab.this.oclPath.getText();
            URI oclURI = URI.createURI((String)oclName, (boolean)true);
            try {
                ASResource asResource;
                Iterator iterator;
                Model root = null;
                BaseCSResource xtextResource = null;
                xtextResource = (BaseCSResource)MainTab.this.getEnvironmentFactory().getResourceSet().getResource(oclURI, true);
                if (xtextResource != null && (iterator = (asResource = xtextResource.getASResource()).getContents().iterator()).hasNext()) {
                    EObject eContent = (EObject)iterator.next();
                    root = (Model)eContent;
                }
                if (root == null) {
                    throw new IOException("There was an error loading the OCL file. ");
                }
                ArrayList<String> expressions = new ArrayList<String>();
                TreeIterator tit = root.eAllContents();
                while (tit.hasNext()) {
                    EObject eObject = (EObject)tit.next();
                    if (!(eObject instanceof ExpressionInOCL)) continue;
                    ExpressionInOCL expressionInOCL = (ExpressionInOCL)eObject;
                    String displayString = MainTab.this.getDisplayString(expressionInOCL);
                    URI uri = EcoreUtil.getURI((EObject)expressionInOCL.eContainer());
                    expressions.add(displayString);
                    MainTab.this.expression2uri.put(displayString, uri);
                }
                Collections.sort(expressions);
                MainTab.this.expressionCombo.setItems(expressions.toArray(new String[expressions.size()]));
            }
            catch (Exception ex) {
                MainTab.this.setErrorMessage("Failed to load '" + oclName + "': " + ex.toString());
            }
            MainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

