/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.outline.SymbolsLabelProvider;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class LSPSymbolInWorkspaceDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = LSPSymbolInWorkspaceDialog.class.getName();
    private List<LanguageServiceAccessor.LSPServerInfo> infos;
    private InternalSymbolsLabelProvider labelProvider;

    public LSPSymbolInWorkspaceDialog(Shell shell, List<LanguageServiceAccessor.LSPServerInfo> infos) {
        super(shell);
        this.infos = infos;
        this.labelProvider = new InternalSymbolsLabelProvider(new BoldStylerProvider(shell.getFont()));
        this.setMessage(Messages.LSPSymbolInWorkspaceDialog_DialogLabel);
        this.setTitle(Messages.LSPSymbolInWorkspaceDialog_DialogTitle);
        this.setListLabelProvider((ILabelProvider)this.labelProvider);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        InternalItemsFilter itemsFilter = new InternalItemsFilter();
        this.labelProvider.setPattern(itemsFilter.getPattern());
        return itemsFilter;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
        if (itemsFilter.getPattern().isEmpty()) {
            return;
        }
        for (LanguageServiceAccessor.LSPServerInfo info : this.infos) {
            if (monitor.isCanceled()) {
                return;
            }
            WorkspaceSymbolParams params = new WorkspaceSymbolParams(itemsFilter.getPattern());
            CompletableFuture symbols = info.getLanguageServer().getWorkspaceService().symbol(params);
            try {
                List items = (List)symbols.get(1L, TimeUnit.SECONDS);
                for (Object item : items) {
                    if (item == null) continue;
                    contentProvider.add(item, itemsFilter);
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    public String getElementName(Object item) {
        SymbolInformation info = (SymbolInformation)item;
        return info.getName();
    }

    protected Comparator<SymbolInformation> getItemsComparator() {
        return new Comparator<SymbolInformation>(){

            @Override
            public int compare(SymbolInformation o1, SymbolInformation o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = LanguageServerPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = LanguageServerPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    private class InternalItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private InternalItemsFilter() {
            super((FilteredItemsSelectionDialog)LSPSymbolInWorkspaceDialog.this);
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof SymbolInformation)) {
                return false;
            }
            SymbolInformation info = (SymbolInformation)item;
            return info.getName().toLowerCase().indexOf(this.getPattern().toLowerCase()) != -1;
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }
    }

    private static class InternalSymbolsLabelProvider
    extends SymbolsLabelProvider {
        private String pattern;
        private BoldStylerProvider stylerProvider;

        public InternalSymbolsLabelProvider(BoldStylerProvider stylerProvider) {
            super(true);
            this.stylerProvider = stylerProvider;
        }

        @Override
        public StyledString getStyledText(Object element) {
            StyledString styledString = super.getStyledText(element);
            int index = styledString.getString().toLowerCase().indexOf(this.pattern);
            if (index != -1) {
                styledString.setStyle(index, this.pattern.length(), this.stylerProvider.getBoldStyler());
            }
            return styledString;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }
}

