/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.debug.core.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.ldt.core.LuaUtils;

public class LuaAbsoluteFileURIBuildpathSourceContainer
extends AbstractSourceContainer {
    public Object[] findSourceElements(String name) throws CoreException {
        URI sourceURI;
        if (name == null || !name.startsWith("file:///")) {
            return new Object[0];
        }
        try {
            sourceURI = new URI(name);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new Object[0];
        }
        ILaunchConfiguration configuration = this.getDirector().getLaunchConfiguration();
        String projectName = configuration.getAttribute("project", null);
        if (projectName == null) {
            return new Object[0];
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        IModuleSource moduleSource = LuaUtils.getModuleSourceFromAbsoluteURI((URI)sourceURI, (IScriptProject)scriptProject);
        if (moduleSource != null && moduleSource.getModelElement() != null && moduleSource.getModelElement().getResource() instanceof IStorage) {
            return new Object[]{moduleSource.getModelElement().getResource()};
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(sourceURI);
        Object[] result = Arrays.copyOf(files, files.length, Object[].class);
        return result;
    }

    public String getName() {
        return "Lua Absolute File URI in Buildpath Source Container";
    }

    public ISourceContainerType getType() {
        return null;
    }
}

