/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.utils.generator;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;
import org.eclipse.jubula.tools.internal.xml.businessprocess.ConfigVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ToolkitPluginParser {
    public static final String TOOLKIT_ELEMENT = "toolkit";
    private String m_xmlFile;
    private CompSystem m_compSystem;

    public ToolkitPluginParser(String filename, CompSystem compSystem) {
        this.m_xmlFile = filename;
        this.m_compSystem = compSystem;
    }

    public ToolkitDescriptor getToolkitDescriptor() {
        DocumentBuilder db = null;
        Document xmlDom = null;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        try {
            xmlDom = db.parse(this.m_xmlFile);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        NodeList toolkitElements = xmlDom.getElementsByTagName(TOOLKIT_ELEMENT);
        Element toolkitElement = (Element)toolkitElements.item(0);
        String toolkitName = toolkitElement.getAttribute("name");
        String toolkitID = toolkitElement.getAttribute("toolkitID");
        String level = toolkitElement.getAttribute("level");
        boolean isUserToolkit = Boolean.valueOf(toolkitElement.getAttribute("isUserToolkit"));
        String includes = toolkitElement.getAttribute("includes");
        String depends = toolkitElement.getAttribute("depends");
        int order = Integer.parseInt(toolkitElement.getAttribute("order"));
        ConfigVersion configVersion = this.m_compSystem.getConfigVersion();
        int majorVersion = configVersion.getMajorVersion();
        int minorVersion = configVersion.getMinorVersion();
        ToolkitDescriptor descr = new ToolkitDescriptor(toolkitID, toolkitName, includes, depends, level, order, isUserToolkit, majorVersion, minorVersion);
        return descr;
    }
}

