/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.properties.nodes;

import javax.persistence.EntityManager;
import org.eclipse.jubula.client.core.model.ICheckConfPO;
import org.eclipse.jubula.client.teststyle.checks.BaseCheck;
import org.eclipse.jubula.client.teststyle.checks.CheckConfMock;
import org.eclipse.jubula.client.teststyle.checks.DecoratingCheck;
import org.eclipse.jubula.client.teststyle.checks.Severity;
import org.eclipse.jubula.client.teststyle.properties.nodes.INode;

public class CheckNode
implements INode {
    private BaseCheck m_checkCopy;
    private BaseCheck m_check;
    private INode m_parent;

    public CheckNode(INode parent, BaseCheck check) {
        this.m_parent = parent;
        this.m_check = check;
        this.m_checkCopy = check.clone();
    }

    public INode[] getChildren() {
        return null;
    }

    public INode getParent() {
        return this.m_parent;
    }

    public void save(EntityManager s) {
        if (this.m_check.getConf() instanceof CheckConfMock) {
            return;
        }
        this.m_check.setConf((ICheckConfPO)s.merge((Object)this.m_check.getConf()));
        this.m_check.setActive(this.m_checkCopy.isActive());
        this.m_check.setAttributes(this.m_checkCopy.getAttributes());
        this.m_check.setContexts(this.m_checkCopy.getContexts());
        this.m_check.setSeverity(this.m_checkCopy.getSeverity());
    }

    public void setState(INode.TreeState state) {
        this.m_checkCopy.setActive(state == INode.TreeState.CHECKED);
    }

    public String getText() {
        return this.m_checkCopy.getName();
    }

    public INode.TreeState getState() {
        return this.m_checkCopy.isActive() ? INode.TreeState.CHECKED : INode.TreeState.EMPTY;
    }

    public BaseCheck getCheck() {
        return this.m_checkCopy;
    }

    public Severity getSeverity() {
        return this.m_checkCopy.getSeverity();
    }

    public void setSeverity(Severity sev) {
        this.m_checkCopy.setSeverity(sev);
    }

    public int compareTo(INode o) {
        return this.getText().toLowerCase().compareTo(o.getText().toLowerCase());
    }

    public boolean hasSeverity() {
        return !(this.m_check instanceof DecoratingCheck);
    }

    public boolean isEditable() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CheckNode) {
            CheckNode other = (CheckNode)obj;
            return this.m_check.equals(other.m_check);
        }
        return false;
    }

    public int hashCode() {
        return this.m_check.hashCode();
    }

    public String getTooltip() {
        return this.m_check.getFulltextDescription();
    }
}

