/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.core.internal.JSFCoreTraceOptions;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry.LibraryOperationFactory;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry.TLDTagRegistry;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexDelta;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexListener;

class TagIndexListener
implements ITaglibIndexListener {
    private final TLDTagRegistry _registry;
    private final LibraryOperationFactory _factory;

    TagIndexListener(TLDTagRegistry registry) {
        this._registry = registry;
        this._factory = new LibraryOperationFactory(this._registry);
    }

    public void indexChanged(ITaglibIndexDelta delta) {
        if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY_CHANGES) {
            JSFCoreTraceOptions.log("TagIndexListener.indexChanged: start");
        }
        this.visitDelta(delta);
        if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY_CHANGES) {
            JSFCoreTraceOptions.log("TagIndexListener.indexChanged: finish");
        }
    }

    private void visitDelta(ITaglibIndexDelta delta) {
        IProject project = delta.getProject();
        if (this._registry != null && !this._registry.isDisposed() && delta.getTaglibRecord() != null) {
            switch (delta.getKind()) {
                case 1: {
                    if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY_CHANGES) {
                        JSFCoreTraceOptions.log(String.format("Processing add change: project=%s", project.getName()));
                    }
                    this._registry.addLibraryOperation(this._factory.createAddOperation(delta.getTaglibRecord()));
                    break;
                }
                case 2: {
                    if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY_CHANGES) {
                        JSFCoreTraceOptions.log(String.format("Processing remove change: project=%s, tagrecord=%s", project.getName()));
                    }
                    this._registry.addLibraryOperation(this._factory.createRemoveOperation(delta.getTaglibRecord()));
                    break;
                }
                case 4: {
                    if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY_CHANGES) {
                        JSFCoreTraceOptions.log(String.format("Processing change: project=%s, tagrecord=%s", project.getName()));
                    }
                    this._registry.addLibraryOperation(this._factory.createChangeOperation(delta.getTaglibRecord()));
                }
            }
        }
        ITaglibIndexDelta[] iTaglibIndexDeltaArray = delta.getAffectedChildren();
        int n = iTaglibIndexDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITaglibIndexDelta child = iTaglibIndexDeltaArray[n2];
            this.visitDelta(child);
            ++n2;
        }
    }
}

