/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.attributes.FilterCommandFactory;
import org.eclipse.jgit.attributes.FilterCommandRegistry;
import org.eclipse.jgit.lfs.Lfs;
import org.eclipse.jgit.lfs.LfsPointer;
import org.eclipse.jgit.lib.Repository;

public class SmudgeFilter
extends FilterCommand {
    public static final FilterCommandFactory FACTORY = new FilterCommandFactory(){

        public FilterCommand create(Repository db, InputStream in, OutputStream out) throws IOException {
            return new SmudgeFilter(db, in, out);
        }
    };
    private Lfs lfs;

    public static final void register() {
        FilterCommandRegistry.register((String)"jgit://builtin/lfs/smudge", (FilterCommandFactory)FACTORY);
    }

    public SmudgeFilter(Repository db, InputStream in, OutputStream out) throws IOException {
        super(in, out);
        Path mediaFile;
        this.lfs = new Lfs(db.getDirectory().toPath().resolve("lfs"));
        LfsPointer res = LfsPointer.parseLfsPointer(in);
        if (res != null && Files.exists(mediaFile = this.lfs.getMediaFile(res.getOid()), new LinkOption[0])) {
            this.in = Files.newInputStream(mediaFile, new OpenOption[0]);
        }
    }

    public int run() throws IOException {
        if (this.in != null) {
            int b;
            while ((b = this.in.read()) != -1) {
                this.out.write(b);
            }
            this.in.close();
        }
        this.out.close();
        return -1;
    }
}

