/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.TableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.presentable.PresentableService;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.utils.EditingDomainUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropService {
    private final PresentableService presentableS;
    private final TableCommandFactory tableCmdFactory;
    private final EditingDomain editingdomain;

    public DropService(PresentableService presentableS, EditingDomain editingDomain, TableCommandFactory tableCmdFactory) {
        this.presentableS = presentableS;
        this.tableCmdFactory = tableCmdFactory;
        this.editingdomain = editingDomain;
    }

    public final void drop(StructuredSelection selection, Object element, EStructuralFeature feature) {
        Command cmd = this.tableCmdFactory.createDropCommand((IStructuredSelection)selection, element, feature);
        EditingDomainUtils.executeCommand(cmd, this.editingdomain);
    }

    public void drop(StructuredSelection selection) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        for (Object selectedElement : selection) {
            if (!(selectedElement instanceof EObject)) continue;
            EObject selectedEObject = (EObject)selectedElement;
            if (!this.presentableS.acceptsElement(selectedEObject)) {
                String uri = EditingDomainUtils.getStringURI((EObject)selectedEObject.eClass());
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.wrongEObjectType, (String)(String.valueOf(Messages.wrongEObjectTypeLong) + uri));
                return;
            }
            list.add(selectedEObject);
        }
        this.addRows(list);
    }

    public final boolean canBeDropped(IStructuredSelection selection, EStructuralFeature feature, Object element) {
        Command cmd = this.tableCmdFactory.createDropCommand(selection, element, feature);
        return cmd.canExecute();
    }

    public final void addRows(List<? extends EObject> newElements) {
        Command cmd = this.tableCmdFactory.createAddRowsCommand(newElements);
        EditingDomainUtils.executeCommand(cmd, this.editingdomain);
    }
}

