/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCRoutineLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCUserDefinedTypeLoader;
import org.eclipse.datatools.enablement.ase.ISybaseASECatalogTable;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogDefault;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogIndex;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogProcedure;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogProxyTable;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogRule;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogTable;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogTempTable;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogTrigger;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUserDefinedType;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogView;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogWebServiceTable;
import org.eclipse.datatools.enablement.ase.catalog.WebServiceTableWrapper;
import org.eclipse.datatools.enablement.sybase.VirtualNodeAdapter;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASECatalogType;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEDatabase;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEDefault;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASERule;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEUserDefinedType;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseasesqlmodelPackage;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASESchemaImpl;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.internal.refresh.ICatalogObject2;
import org.eclipse.datatools.sqltools.internal.refresh.RefreshManager2;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogSchema
extends SybaseASESchemaImpl
implements ICatalogObject2,
IAdaptable {
    private static final long serialVersionUID = 7099250751727189699L;
    private Boolean tablesLoaded = Boolean.FALSE;
    private SoftReference tableLoaderRef;
    private Boolean routinesLoaded = Boolean.FALSE;
    private SoftReference routineLoaderRef;
    private Boolean udtsLoaded = Boolean.FALSE;
    private SoftReference udtLoaderRef;
    private Boolean defaultsLoaded = Boolean.FALSE;
    private Boolean rulesLoaded = Boolean.FALSE;
    private Boolean ownerLoaded = Boolean.FALSE;

    protected static Object findElement(Object[] list, String name, EClass metaclass) {
        Object object = null;
        int i = 0;
        while (i < list.length) {
            SQLObject sqlObject = (SQLObject)list[i];
            if (sqlObject.getName().equals(name) && sqlObject.eClass() == metaclass) {
                object = list[i];
                break;
            }
            ++i;
        }
        return object;
    }

    public Database getCatalogDatabase() {
        return this.getCatalog().getDatabase();
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    public void refresh() {
        this.refresh(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String context) {
        Boolean bl;
        if (!this.needsRefresh(context)) {
            return;
        }
        if (context == null || context.equals("core.sql.tables.BaseTable") || context.equals("core.sybasease.ASEWebServiceTable") || context.equals("core.sql.tables.ViewTable") || context.equals("core.sql.tables.ProxyTable")) {
            bl = this.tablesLoaded;
            synchronized (bl) {
                if (this.tablesLoaded.booleanValue()) {
                    this.tablesLoaded = Boolean.FALSE;
                }
            }
        }
        if (context == null || context.equals("core.sql.routines.Procedure")) {
            bl = this.routinesLoaded;
            synchronized (bl) {
                if (this.routinesLoaded.booleanValue()) {
                    this.routinesLoaded = Boolean.FALSE;
                }
            }
        }
        if (context == null || context.equals("core.sql.datatypes.UserDefinedType") || context.equals("core.sybasease.ASEDataType")) {
            bl = this.udtsLoaded;
            synchronized (bl) {
                if (this.udtsLoaded.booleanValue()) {
                    this.udtsLoaded = Boolean.FALSE;
                }
            }
        }
        if (context == null || context.equals("core.sybasease.ASEDefault")) {
            bl = this.defaultsLoaded;
            synchronized (bl) {
                if (this.defaultsLoaded.booleanValue()) {
                    this.defaultsLoaded = Boolean.FALSE;
                }
            }
        }
        if (context == null || context.equals("core.sybasease.ASERule")) {
            bl = this.rulesLoaded;
            synchronized (bl) {
                if (this.rulesLoaded.booleanValue()) {
                    this.rulesLoaded = Boolean.FALSE;
                }
            }
        }
        if (context == null || context.equals("core.sybasease.owner")) {
            bl = this.ownerLoaded;
            synchronized (bl) {
                if (this.ownerLoaded.booleanValue()) {
                    this.ownerLoaded = Boolean.FALSE;
                }
            }
        }
        RefreshManager2.getInstance().referesh((ICatalogObject)this, context);
    }

    public boolean needsRefresh(String context) {
        if (context != null) {
            if (context.equals("core.sql.routines.Procedure")) {
                return this.routinesLoaded;
            }
            if (context.equals("core.sql.tables.BaseTable") || context.equals("core.sybasease.ASEWebServiceTable") || context.equals("core.sql.tables.ViewTable") || context.equals("core.sql.tables.ProxyTable")) {
                return this.tablesLoaded;
            }
            if (context.equals("core.sybasease.ASEDataType") || context.equals("core.sql.datatypes.UserDefinedType")) {
                return this.udtsLoaded;
            }
            if (context.equals("core.sybasease.ASEDefault")) {
                return this.defaultsLoaded;
            }
            if (context.equals("core.sybasease.ASERule")) {
                return this.rulesLoaded;
            }
            if (context.equals("core.sybasease.owner")) {
                return this.ownerLoaded;
            }
        }
        return this.tablesLoaded != false || this.routinesLoaded != false || this.udtsLoaded != false || this.defaultsLoaded != false || this.rulesLoaded != false || this.ownerLoaded != false;
    }

    public String getRefreshContext(Object obj) {
        if (obj instanceof IAdaptable) {
            VirtualNodeAdapter adapter = (VirtualNodeAdapter)((IAdaptable)obj).getAdapter(VirtualNodeAdapter.class);
            if (adapter != null) {
                return adapter.getGroupId();
            }
        } else {
            if (obj instanceof Integer) {
                int i = (Integer)obj;
                switch (i) {
                    case 10: {
                        return "core.sql.tables.BaseTable";
                    }
                    case 17: {
                        return "core.sql.routines.Procedure";
                    }
                    case 15: {
                        return "core.sybasease.ASEDataType";
                    }
                    case 19: {
                        return "core.sybasease.ASEDefault";
                    }
                    case 20: {
                        return "core.sybasease.ASERule";
                    }
                    case 18: {
                        return "core.sybasease.owner";
                    }
                }
                return null;
            }
            if (obj instanceof Table) {
                return "core.sql.tables.BaseTable";
            }
            if (obj instanceof Routine) {
                return "core.sql.routines.Procedure";
            }
            if (obj instanceof UserDefinedType) {
                return "core.sybasease.ASEDataType";
            }
            if (obj instanceof SybaseASEDefault) {
                return "core.sybasease.ASEDefault";
            }
            if (obj instanceof SybaseASERule) {
                return "core.sybasease.ASERule";
            }
            if (obj instanceof AuthorizationIdentifier) {
                return "core.sybasease.owner";
            }
        }
        return null;
    }

    public AuthorizationIdentifier getOwner() {
        if (!this.ownerLoaded.booleanValue()) {
            AuthorizationIdentifier authId = (AuthorizationIdentifier)ASEUtil.getSQLObject((Collection)((org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASECatalog)this.getCatalog()).getAuthorizationIds(), this.getName());
            super.setOwner(authId);
        }
        return super.getOwner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getTables() {
        Boolean bl = this.tablesLoaded;
        synchronized (bl) {
            if (!this.tablesLoaded.booleanValue()) {
                this.loadTables();
            }
        }
        return super.getTables();
    }

    protected JDBCTableLoader createTableLoader() {
        ASETableLoader tableLoader = new ASETableLoader((ICatalogObject)this);
        return tableLoader;
    }

    protected final JDBCTableLoader getTableLoader() {
        if (this.tableLoaderRef == null || this.tableLoaderRef.get() == null) {
            this.tableLoaderRef = new SoftReference<JDBCTableLoader>(this.createTableLoader());
        }
        return (JDBCTableLoader)this.tableLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTables() {
        Boolean bl = this.tablesLoaded;
        synchronized (bl) {
            try {
                boolean deliver = this.eDeliver();
                this.eSetDeliver(false);
                EList tableList = super.getTables();
                ArrayList existingTables = new ArrayList(tableList.size());
                existingTables.addAll(tableList);
                this.getTableLoader().clearTables((List)tableList);
                this.getTableLoader().loadTables((List)tableList, existingTables);
                this.eSetDeliver(deliver);
                this.tablesLoaded = Boolean.TRUE;
            }
            catch (Exception e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getRoutines() {
        Boolean bl = this.routinesLoaded;
        synchronized (bl) {
            if (!this.routinesLoaded.booleanValue()) {
                this.loadRoutines();
            }
        }
        return super.getRoutines();
    }

    protected JDBCRoutineLoader createRoutineLoader() {
        return new ASERoutineLoader((ICatalogObject)this);
    }

    protected final JDBCRoutineLoader getRoutineLoader() {
        if (this.routineLoaderRef == null || this.routineLoaderRef.get() == null) {
            this.routineLoaderRef = new SoftReference<JDBCRoutineLoader>(this.createRoutineLoader());
        }
        return (JDBCRoutineLoader)this.routineLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRoutines() {
        Boolean bl = this.routinesLoaded;
        synchronized (bl) {
            try {
                boolean deliver = this.eDeliver();
                this.eSetDeliver(false);
                EList routineList = super.getRoutines();
                ArrayList existingRoutines = new ArrayList(routineList.size());
                existingRoutines.addAll(routineList);
                this.getRoutineLoader().clearRoutines((List)routineList);
                this.getRoutineLoader().loadRoutines((List)routineList, existingRoutines);
                this.eSetDeliver(deliver);
                this.routinesLoaded = Boolean.TRUE;
            }
            catch (Exception e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getUserDefinedTypes() {
        Boolean bl = this.udtsLoaded;
        synchronized (bl) {
            if (!this.udtsLoaded.booleanValue()) {
                this.loadUserDefinedTypes();
            }
        }
        return super.getUserDefinedTypes();
    }

    protected JDBCUserDefinedTypeLoader createUDTLoader() {
        return new ASEUDTLoader((ICatalogObject)this);
    }

    protected final JDBCUserDefinedTypeLoader getUDTLoader() {
        if (this.udtLoaderRef == null || this.udtLoaderRef.get() == null) {
            this.udtLoaderRef = new SoftReference<JDBCUserDefinedTypeLoader>(this.createUDTLoader());
        }
        return (JDBCUserDefinedTypeLoader)this.udtLoaderRef.get();
    }

    private void loadUserDefinedTypes() {
        boolean deliver;
        block8: {
            if (this.udtsLoaded.booleanValue()) {
                return;
            }
            Connection conn = this.getConnection();
            String schemaName = this.getName();
            this.getCatalog().getName();
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            EList udtList = super.getUserDefinedTypes();
            ArrayList existingUdts = new ArrayList(udtList.size());
            existingUdts.addAll(udtList);
            udtList.clear();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT T.name udt_name FROM  systypes T, sysusers U, systypes PHY WHERE T.uid = U.uid AND PHY.usertype =(SELECT min(usertype) FROM systypes WHERE type = T.type )AND T.type = PHY.type AND T.usertype >= 100 AND U.name = ?  order by 1");
                    stmt.setString(1, schemaName);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String udtName = rs.getString(1);
                        Object udt = (SybaseASEUserDefinedType)ASEUtil.getSQLObject(existingUdts, udtName);
                        if (udt != null) {
                            udtList.add(udt);
                            if (!(udt instanceof ICatalogObject)) continue;
                            ((ICatalogObject)udt).refresh();
                            continue;
                        }
                        udt = new SybaseASECatalogUserDefinedType();
                        udt.setName(udtName);
                        udtList.add(udt);
                    }
                }
                catch (Exception e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.udtsLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 10: {
                this.getTables();
                break;
            }
            case 17: {
                this.getRoutines();
                break;
            }
            case 15: {
                this.getUserDefinedTypes();
                break;
            }
            case 19: {
                this.getDefaults();
                break;
            }
            case 20: {
                this.getRules();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getDefaults() {
        Boolean bl = this.defaultsLoaded;
        synchronized (bl) {
            if (!this.defaultsLoaded.booleanValue()) {
                this.loadDefault();
            }
        }
        return super.getDefaults();
    }

    private void loadDefault() {
        boolean deliver;
        block14: {
            if (this.defaultsLoaded.booleanValue()) {
                return;
            }
            Connection conn = this.getConnection();
            String schemaName = this.getName();
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            EList defaultList = super.getDefaults();
            ArrayList existingDefaults = new ArrayList(defaultList.size());
            existingDefaults.addAll(defaultList);
            defaultList.clear();
            Statement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getCatalog().getName());
                    stmt = conn.prepareStatement("select distinct O.name, U.name from dbo.sysobjects O, dbo.sysusers U, dbo.sysprocedures P where O.uid = U.uid and O.id = P.id and P.sequence = 0 and P.status & 4096 != 4096 and U.name = ? and O.type = ? order by 1");
                    stmt.setString(1, schemaName);
                    stmt.setString(2, "D");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String defaultName = rs.getString(1);
                        Object aseDefault = (SybaseASEDefault)ASEUtil.getSQLObject(existingDefaults, defaultName);
                        if (aseDefault != null) {
                            defaultList.add(aseDefault);
                            if (!(aseDefault instanceof ICatalogObject)) continue;
                            ((ICatalogObject)aseDefault).refresh();
                            continue;
                        }
                        aseDefault = new SybaseASECatalogDefault();
                        aseDefault.setName(defaultName);
                        defaultList.add(aseDefault);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    try {
                        rs.close();
                        stmt.close();
                        conn.setCatalog(oldCatalog);
                    }
                    catch (SQLException sQLException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    rs.close();
                    stmt.close();
                    conn.setCatalog(oldCatalog);
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            try {
                rs.close();
                stmt.close();
                conn.setCatalog(oldCatalog);
            }
            catch (SQLException sQLException) {}
        }
        this.defaultsLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getRules() {
        Boolean bl = this.rulesLoaded;
        synchronized (bl) {
            if (!this.rulesLoaded.booleanValue()) {
                this.loadRule();
            }
        }
        return super.getRules();
    }

    private void loadRule() {
        boolean deliver;
        block8: {
            if (this.rulesLoaded.booleanValue()) {
                return;
            }
            Connection conn = this.getConnection();
            String schemaName = this.getName();
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            EList ruleList = super.getRules();
            ArrayList existingRules = new ArrayList(ruleList.size());
            existingRules.addAll(ruleList);
            ruleList.clear();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getCatalog().getName());
                    stmt = conn.prepareStatement("select distinct O.name, U.name from dbo.sysobjects O, dbo.sysusers U, dbo.sysprocedures P where O.uid = U.uid and O.id = P.id and P.sequence = 0 and P.status & 4096 != 4096 and U.name = ? and O.type = ? order by 1");
                    stmt.setString(1, schemaName);
                    stmt.setString(2, "R");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String ruleName = rs.getString(1);
                        Object rule = (SybaseASERule)ASEUtil.getSQLObject(existingRules, ruleName);
                        if (rule != null) {
                            ruleList.add(rule);
                            if (!(rule instanceof ICatalogObject)) continue;
                            ((ICatalogObject)rule).refresh();
                            continue;
                        }
                        rule = new SybaseASECatalogRule();
                        rule.setName(ruleName);
                        ruleList.add(rule);
                    }
                }
                catch (Exception e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.rulesLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    public EList getTriggers() {
        this.batchLoadTriggers();
        return super.getTriggers();
    }

    private void batchLoadTriggers() {
        boolean deliver;
        block8: {
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            HashMap tableMap = new HashMap();
            HashMap<TableMapKey, ArrayList<String>> trigMap = new HashMap<TableMapKey, ArrayList<String>>();
            this.initTableMap(tableMap);
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT TB.name as TABLE_NAME, TR.name AS TRIGGER_NAME, TU.name as TABLE_OWNER FROM sysobjects TR, sysobjects TB, sysusers TU, sysusers TRS WHERE TR.type='TR' and TR.deltrig = TB.id and TU.uid = TB.uid and TRS.name = ? and TRS.uid = TR.uid order by 2");
                    stmt.setString(1, this.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String trigName = rs.getString(2);
                        String tableName = rs.getString(1);
                        String ownerName = rs.getString(3);
                        if (trigName == null) continue;
                        TableMapKey key = new TableMapKey(ownerName, tableName);
                        ArrayList<String> trigNameList = (ArrayList<String>)trigMap.get(key);
                        if (trigNameList == null) {
                            trigNameList = new ArrayList<String>();
                            trigMap.put(key, trigNameList);
                        }
                        trigNameList.add(trigName);
                    }
                    super.getTriggers().clear();
                    for (Object tableKey : trigMap.keySet()) {
                        List trigWrapperList = (List)trigMap.get(tableKey);
                        ISybaseASECatalogTable table = (ISybaseASECatalogTable)tableMap.get(tableKey);
                        this.loadTriggers(trigWrapperList, table);
                    }
                }
                catch (Exception e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.eSetDeliver(deliver);
    }

    public void loadTriggers(List trigNames, ISybaseASECatalogTable table) {
        SybaseASECatalogTable t = (SybaseASECatalogTable)table;
        boolean deliver = t.eDeliver();
        t.eSetDeliver(false);
        EList triggerList = table.getTriggersSuper();
        ArrayList existingTriggers = new ArrayList(triggerList);
        if (t.isTriggerNeedClear) {
            triggerList.clear();
            t.isTriggerNeedClear = false;
        }
        for (String trigName : trigNames) {
            SybaseASECatalogTrigger trigger = (SybaseASECatalogTrigger)ASEUtil.getSQLObject(existingTriggers, trigName);
            if (trigger != null) {
                triggerList.add((Object)trigger);
                super.getTriggers().add((Object)trigger);
                trigger.refresh();
                continue;
            }
            trigger = new SybaseASECatalogTrigger();
            trigger.setName(trigName);
            super.getTriggers().add((Object)trigger);
            triggerList.add((Object)trigger);
        }
        t.eSetDeliver(deliver);
    }

    private void initTableMap(Map tableMap) {
        EList schemas = this.getCatalog().getSchemas();
        for (Schema schema : schemas) {
            String schemaName = schema.getName();
            EList tables = schema.getTables();
            for (Table table : tables) {
                if (!(table instanceof ISybaseASECatalogTable)) continue;
                TableMapKey key = new TableMapKey(schemaName, table.getName());
                tableMap.put(key, table);
            }
        }
    }

    public EList getIndices() {
        this.batchLoadIndices();
        return super.getIndices();
    }

    private void batchLoadIndices() {
        boolean deliver;
        block8: {
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            HashMap tableMap = new HashMap();
            HashMap indexMap = new HashMap();
            this.initTableMap(tableMap);
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT I.name, T.name, I.status2 FROM sysindexes I, sysobjects T, sysusers U WHERE U.name = ? and U.uid = T.uid and I.id = T.id AND I.indid BETWEEN 1 AND 254 AND ((I.status & 16 = 16 OR I.status2 & 512 = 512) OR (I.status & 16 = 0 AND I.status2 & 512 = 0))  order by 1");
                    stmt.setString(1, this.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String indexName = rs.getString(1);
                        String tableName = rs.getString(2);
                        TableMapKey key = new TableMapKey(this.getName(), tableName);
                        ArrayList<IndexWrapper> indices = (ArrayList<IndexWrapper>)indexMap.get(key);
                        if (indices == null) {
                            indices = new ArrayList<IndexWrapper>();
                            indexMap.put(key, indices);
                        }
                        boolean isSysGen = (rs.getInt(3) & 2) == 2;
                        IndexWrapper wrapper = new IndexWrapper(indexName, isSysGen);
                        indices.add(wrapper);
                    }
                    super.getIndices().clear();
                    for (Object key : indexMap.keySet()) {
                        List indexWrapperList = (List)indexMap.get(key);
                        ISybaseASECatalogTable table = (ISybaseASECatalogTable)tableMap.get(key);
                        this.loadIndices(indexWrapperList, table);
                    }
                }
                catch (Exception e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.eSetDeliver(deliver);
    }

    public void loadIndices(List indexWrappers, ISybaseASECatalogTable table) {
        Table t = (Table)table;
        boolean deliver = t.eDeliver();
        t.eSetDeliver(false);
        EList indexList = table.getIndexSuper();
        ArrayList existingIdx = new ArrayList(indexList);
        indexList.clear();
        for (IndexWrapper wrapper : indexWrappers) {
            SybaseASECatalogIndex index = (SybaseASECatalogIndex)ASEUtil.getSQLObject(existingIdx, wrapper.indexName);
            if (index != null) {
                indexList.add((Object)index);
                super.getIndices().add((Object)index);
                index.refresh();
            } else {
                index = new SybaseASECatalogIndex();
                index.setName(wrapper.indexName);
                indexList.add((Object)index);
                super.getIndices().add((Object)index);
            }
            index.setSystemGenerated(wrapper.isSysGen);
        }
        t.eSetDeliver(deliver);
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }

    public EList getSuperTriggers() {
        return super.getTriggers();
    }

    public EList getSuperIndices() {
        return super.getIndices();
    }

    private static class ASEDistinctTypeFactory
    extends JDBCUserDefinedTypeLoader.DistinctTypeFactory {
        public ASEDistinctTypeFactory(DatabaseDefinition databaseDefinition) {
            super(databaseDefinition);
        }

        protected UserDefinedType newUDT() {
            return new SybaseASECatalogUserDefinedType();
        }

        public void initialize(UserDefinedType udt, ResultSet rs) throws SQLException {
            EStructuralFeature feature;
            super.initialize(udt, rs);
            PredefinedDataType pdt = ((DistinctUserDefinedType)udt).getPredefinedRepresentation();
            if (pdt == null) {
                return;
            }
            PredefinedDataTypeDefinition pdtd = this.getDatabaseDefinition().getPredefinedDataTypeDefinition(pdt.getName());
            if (pdtd == null) {
                return;
            }
            if (pdtd.isLengthSupported()) {
                feature = pdt.eClass().getEStructuralFeature("length");
                pdt.eSet(feature, (Object)new Integer(rs.getInt("length")));
            }
            if (pdtd.isPrecisionSupported()) {
                feature = pdt.eClass().getEStructuralFeature("precision");
                pdt.eSet(feature, (Object)new Integer(rs.getInt("prec")));
            }
            if (pdtd.isScaleSupported()) {
                feature = pdt.eClass().getEStructuralFeature("scale");
                pdt.eSet(feature, (Object)new Integer(rs.getInt("scale")));
            }
        }
    }

    public static class ASEProcedureFactory
    implements JDBCRoutineLoader.IRoutineFactory {
        public Routine createRoutine(ResultSet rs) throws SQLException {
            SybaseASECatalogProcedure sp = new SybaseASECatalogProcedure();
            this.initialize((Routine)sp, rs);
            return sp;
        }

        public EClass getRoutineEClass() {
            return SybaseasesqlmodelPackage.eINSTANCE.getSybaseASEProcedure();
        }

        public void initialize(Routine sp, ResultSet rs) throws SQLException {
            sp.setName(rs.getString("PROCEDURE_NAME"));
            ((SybaseASECatalogProcedure)sp).setGroupNumber(1);
        }
    }

    private static class ASERoutineLoader
    extends JDBCRoutineLoader {
        String oldCatalog = null;
        Connection connection = null;

        public ASERoutineLoader(ICatalogObject catalogObject) {
            super(catalogObject, null);
            this.setProcedureFactory(new ASEProcedureFactory());
        }

        protected ResultSet createResultSet() throws SQLException {
            Schema schema = (Schema)this.getCatalogObject();
            String catalog = schema.getCatalog().getName();
            this.connection = this.getCatalogObject().getConnection();
            ResultSet rs = null;
            try {
                this.oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(catalog);
                rs = SybaseASECatalogUtils.getStoredProcs(schema.getName(), this.connection);
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
                throw e;
            }
            return rs;
        }

        protected boolean isProcedure(ResultSet rs) throws SQLException {
            return true;
        }

        protected Routine processRow(ResultSet rs) throws SQLException {
            JDBCRoutineLoader.IRoutineFactory routineFactory = this.getProcedureFactory();
            int status = rs.getInt("PROCEDURE_TYPE");
            if ((status & 0x2000000) == 0) {
                return routineFactory.createRoutine(rs);
            }
            return null;
        }

        protected void closeResultSet(ResultSet rs) {
            try {
                super.closeResultSet(rs);
            }
            finally {
                try {
                    if (this.oldCatalog != null) {
                        this.getCatalogObject().getConnection().setCatalog(this.oldCatalog);
                    }
                }
                catch (Exception e) {
                    JDBCASEPlugin.getDefault().log(e);
                }
            }
        }
    }

    public static class ASESysTableFactory
    implements JDBCTableLoader.ITableFactory {
        public Table createTable(ResultSet rs) throws SQLException {
            SybaseASECatalogTable table = new SybaseASECatalogTable();
            this.initialize((Table)table, rs);
            return table;
        }

        public EClass getTableEClass() {
            return SQLTablesPackage.eINSTANCE.getPersistentTable();
        }

        public void setSupportedColumns(Set supportedColumns) {
        }

        public void initialize(Table table, ResultSet rs) throws SQLException {
            table.setName(rs.getString(2));
            ((SybaseASECatalogTable)table).setSystemTable(true);
        }
    }

    private static class ASETableLoader
    extends JDBCTableLoader {
        public static final String[] PB_SYS_TABLES = new String[]{"pbcatcol", "pbcatedt", "pbcatfmt", "pbcattbl", "pbcatvld"};
        public static final List PB_SYS_TABLE_LIST = Arrays.asList(PB_SYS_TABLES);
        String oldCatalogName = null;
        private boolean isWebServiceLoaded = false;

        public ASETableLoader(ICatalogObject catalogObject) {
            super(catalogObject, null);
            this.registerTableFactory("S ", new ASESysTableFactory());
            this.registerTableFactory("V ", new ASEViewTableFactory());
            this.registerTableFactory("U ", new ASEUserTableFactory(this));
        }

        protected ResultSet createResultSet() throws SQLException {
            this.isWebServiceLoaded = false;
            Connection conn = this.getCatalogObject().getConnection();
            this.oldCatalogName = conn.getCatalog();
            Schema schema = this.getSchema();
            conn.setCatalog(schema.getCatalog().getName());
            PreparedStatement stmt = conn.prepareStatement("SELECT o.id, o.name as TABLE_NAME, o.type as TABLE_TYPE, o.sysstat2, o.sysstat FROM dbo.sysobjects AS o, dbo.sysusers AS u WHERE o.uid = u.uid AND u.name = ? AND (o.type = 'U' OR o.type = 'S' OR o.type = 'V') ORDER BY TABLE_NAME");
            stmt.setString(1, schema.getName());
            return stmt.executeQuery();
        }

        protected Table processRow(ResultSet rs) throws SQLException {
            JDBCTableLoader.ITableFactory tableFactory;
            String tableType = rs.getString("TABLE_TYPE");
            String tableName = rs.getString("TABLE_NAME");
            if (PB_SYS_TABLE_LIST.contains(tableName)) {
                tableType = "S ";
            }
            if ((tableFactory = this.getTableFactory(tableType)) == null) {
                return null;
            }
            return tableFactory.createTable(rs);
        }

        protected void closeResultSet(ResultSet rs) {
            try {
                Statement stmt = rs.getStatement();
                rs.close();
                stmt.close();
                this.getCatalogObject().getConnection().setCatalog(this.oldCatalogName);
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }

        public boolean isWebServiceTableLoaded() {
            return this.isWebServiceLoaded;
        }

        public List getWebServiceTableWrappers() throws SQLException {
            this.isWebServiceLoaded = true;
            ArrayList<WebServiceTableWrapper> results = new ArrayList<WebServiceTableWrapper>();
            Connection conn = this.getCatalogObject().getConnection();
            PreparedStatement stmt = null;
            ResultSet rSet = null;
            try {
                try {
                    String sql = "{ call sp_webservices 'list' }";
                    stmt = conn.prepareStatement(sql);
                    rSet = stmt.executeQuery();
                    while (rSet.next()) {
                        WebServiceTableWrapper wrapper = new WebServiceTableWrapper(rSet.getString("Proxy Table Name"), rSet.getString("Owner"), rSet.getString("WebMethod"), rSet.getString("WSDL URI"));
                        results.add(wrapper);
                    }
                }
                catch (SQLException exception) {
                    JDBCASEPlugin.getDefault().log("error", exception);
                    if (rSet != null) {
                        rSet.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (rSet != null) {
                    rSet.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            return results;
        }
    }

    private static class ASEUDTLoader
    extends JDBCUserDefinedTypeLoader {
        private Statement udtQuery;
        private String oldCatalog;

        public ASEUDTLoader(ICatalogObject catalogObject) {
            super(catalogObject, null, (JDBCUserDefinedTypeLoader.IUDTFactory)new ASEDistinctTypeFactory(RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(catalogObject.getCatalogDatabase())), null, null);
        }

        protected void closeResultSet(ResultSet rs) {
            super.closeResultSet(rs);
            try {
                try {
                    this.udtQuery.close();
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    try {
                        this.getCatalogObject().getConnection().setCatalog(this.oldCatalog);
                    }
                    catch (Exception e2) {
                        JDBCASEPlugin.getDefault().log(e2);
                    }
                }
            }
            finally {
                try {
                    this.getCatalogObject().getConnection().setCatalog(this.oldCatalog);
                }
                catch (Exception e) {
                    JDBCASEPlugin.getDefault().log(e);
                }
            }
        }

        protected ResultSet createResultSet() throws SQLException {
            Connection conn = this.getCatalogObject().getConnection();
            this.oldCatalog = conn.getCatalog();
            conn.setCatalog(this.getSchema().getCatalog().getName());
            this.udtQuery = conn.createStatement();
            String sql = MessageFormat.format("SELECT T.name udt_name FROM  systypes T, sysusers U, systypes PHY WHERE T.uid = U.uid AND PHY.usertype =(SELECT min(usertype) FROM systypes WHERE type = T.type )AND T.type = PHY.type AND T.usertype >= 100 AND U.name = ?  order by 1", this.getSchema().getName());
            this.udtQuery.execute(sql);
            return this.udtQuery.getResultSet();
        }
    }

    public static class ASEUserTableFactory
    implements JDBCTableLoader.ITableFactory {
        private ASETableLoader loader;
        private List webServiceTableWrappers = new ArrayList();

        public ASEUserTableFactory(ASETableLoader loader) {
            this.loader = loader;
        }

        public Table createTable(ResultSet rs) throws SQLException {
            String tableName = rs.getString(2);
            int status2 = rs.getInt(4);
            SybaseASEDatabase db = (SybaseASEDatabase)this.loader.getCatalogObject().getCatalogDatabase();
            if (db.isWebserviceApplicable() && !this.loader.isWebServiceTableLoaded()) {
                this.webServiceTableWrappers = this.loader.getWebServiceTableWrappers();
            }
            if ((status2 & 0x400) == 1024) {
                IAdaptable table;
                WebServiceTableWrapper newWrapper = new WebServiceTableWrapper(tableName, ((Schema)this.loader.getCatalogObject()).getName());
                if (this.webServiceTableWrappers.size() != 0 && this.webServiceTableWrappers.contains(newWrapper)) {
                    table = new SybaseASECatalogWebServiceTable();
                    int i = this.webServiceTableWrappers.indexOf(newWrapper);
                    WebServiceTableWrapper wsWrapper = (WebServiceTableWrapper)this.webServiceTableWrappers.get(i);
                    ((SybaseASECatalogWebServiceTable)table).setExternalPath(wsWrapper.getUrl());
                    ((SybaseASECatalogWebServiceTable)table).setMethod(wsWrapper.getMethod());
                } else {
                    table = new SybaseASECatalogProxyTable();
                }
                table.setName(tableName);
                return table;
            }
            SybaseASECatalogSchema schema = (SybaseASECatalogSchema)this.loader.getCatalogObject();
            if (((SybaseASECatalog)schema.getCatalog()).getCatalogType().equals(SybaseASECatalogType.TEMPCATALOG_LITERAL) && tableName.startsWith("#")) {
                SybaseASECatalogTempTable table = new SybaseASECatalogTempTable();
                table.setName(tableName);
                return table;
            }
            SybaseASECatalogTable table = new SybaseASECatalogTable();
            table.setName(tableName);
            return table;
        }

        public EClass getTableEClass() {
            SybaseASECatalogSchema schema = (SybaseASECatalogSchema)this.loader.getCatalogObject();
            if (((SybaseASECatalog)schema.getCatalog()).getCatalogType().equals(SybaseASECatalogType.TEMPCATALOG_LITERAL)) {
                return SQLTablesPackage.eINSTANCE.getTemporaryTable();
            }
            return SQLTablesPackage.eINSTANCE.getPersistentTable();
        }

        public void setSupportedColumns(Set supportedColumns) {
        }

        public void initialize(Table table, ResultSet rs) throws SQLException {
        }
    }

    public static class ASEViewTableFactory
    implements JDBCTableLoader.ITableFactory {
        public Table createTable(ResultSet rs) throws SQLException {
            SybaseASECatalogView table = new SybaseASECatalogView();
            this.initialize((Table)table, rs);
            return table;
        }

        public EClass getTableEClass() {
            return SQLTablesPackage.eINSTANCE.getViewTable();
        }

        public void setSupportedColumns(Set supportedColumns) {
        }

        public void initialize(Table table, ResultSet rs) throws SQLException {
            String tableName = rs.getString(2);
            table.setName(tableName);
        }
    }

    private static class IndexWrapper {
        String indexName;
        boolean isSysGen;

        IndexWrapper(String indexName, boolean isSysGen) {
            this.isSysGen = isSysGen;
            this.indexName = indexName;
        }
    }

    private static class TableMapKey {
        private volatile int hashCode = 0;
        private String ownerName;
        private String tableName;

        TableMapKey(String ownerName, String tableName) {
            this.ownerName = ownerName;
            this.tableName = tableName;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = 37 * result + this.ownerName.hashCode();
                this.hashCode = result = 37 * result + this.tableName.hashCode();
            }
            return this.hashCode;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof TableMapKey) {
                TableMapKey key = (TableMapKey)arg0;
                return key.ownerName.equals(this.ownerName) && key.tableName.equals(this.tableName);
            }
            return false;
        }
    }
}

