/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors;

import org.eclipse.cdt.autotools.ui.editors.AutoconfEditor;
import org.eclipse.cdt.autotools.ui.editors.outline.AutoconfContentProvider;
import org.eclipse.cdt.autotools.ui.editors.outline.AutoconfLabelProvider;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfElement;
import org.eclipse.cdt.internal.autotools.ui.editors.ContainsFilter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class QuickOutlineDialog
extends PopupDialog {
    TreeViewer treeViewer;
    private Text filterText;
    private TextEditor editor;
    private ContainsFilter treeViewerFilter;

    public QuickOutlineDialog(Shell parent, int shellStyle, AutoconfEditor editor) {
        super(parent, shellStyle, true, true, true, true, true, null, null);
        this.editor = editor;
        this.create();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
            this.filterText.setFocus();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public void dispose() {
        this.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.createUIWidgetTreeViewer(parent);
        this.createUIListenersTreeViewer();
        return this.treeViewer.getControl();
    }

    protected Control createTitleControl(Composite parent) {
        this.filterText = new Text(parent, 0);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(-1, Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1)).applyTo((Control)this.filterText);
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    QuickOutlineDialog.this.gotoSelectedElement();
                } else if (e.keyCode == 0x1000002) {
                    QuickOutlineDialog.this.treeViewer.getTree().setFocus();
                } else if (e.keyCode == 0x1000001) {
                    QuickOutlineDialog.this.treeViewer.getTree().setFocus();
                } else if (e.character == '\u001b') {
                    QuickOutlineDialog.this.dispose();
                }
            }
        });
        this.filterText.addModifyListener(e -> {
            String filterTextInput = ((Text)e.widget).getText().toLowerCase();
            this.treeViewerFilter.setLookFor(filterTextInput);
            this.stringMatcherUpdated();
        });
        return this.filterText;
    }

    private void stringMatcherUpdated() {
        this.treeViewer.getControl().setRedraw(false);
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
        if (this.treeViewer.getTree().getTopItem() != null && this.treeViewer.getTree().getTopItem().getItemCount() > 0) {
            this.treeViewer.getTree().select(this.treeViewer.getTree().getTopItem().getItem(0));
        } else if (this.treeViewer.getTree().getItemCount() > 0) {
            this.treeViewer.getTree().select(this.treeViewer.getTree().getItem(0));
        }
        this.treeViewer.getControl().setRedraw(true);
    }

    private void createUIWidgetTreeViewer(Composite parent) {
        int style = 768;
        Tree widget = new Tree(parent, 768);
        GridData data = new GridData(1808);
        data.heightHint = widget.getItemHeight() * 12;
        widget.setLayoutData((Object)data);
        this.treeViewer = new TreeViewer(widget);
        this.treeViewerFilter = new ContainsFilter();
        this.treeViewer.addFilter((ViewerFilter)this.treeViewerFilter);
        AutoconfContentProvider fOutlineContentProvider = new AutoconfContentProvider((ITextEditor)this.editor);
        AutoconfLabelProvider fTreeLabelProvider = new AutoconfLabelProvider();
        this.treeViewer.setContentProvider((IContentProvider)fOutlineContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)fTreeLabelProvider);
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput(this.editor.getAdapter(IContentOutlinePage.class));
    }

    private void createUIListenersTreeViewer() {
        Tree tree = this.treeViewer.getTree();
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                QuickOutlineDialog.this.gotoSelectedElement();
            }
        });
    }

    private void gotoSelectedElement() {
        if (this.editor instanceof AutoconfEditor) {
            AutoconfElement curElement = (AutoconfElement)this.getSelectedElement();
            if (curElement == null) {
                return;
            }
            this.dispose();
            this.editor.setHighlightRange(curElement.getStartOffset(), curElement.getLength(), true);
        }
    }

    private Object getSelectedElement() {
        if (this.treeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }
}

