/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.util.Collection;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.GradleBuilds;
import org.eclipse.buildship.core.workspace.GradleWorkspaceManager;
import org.eclipse.buildship.core.workspace.internal.DefaultGradleBuild;
import org.eclipse.buildship.core.workspace.internal.DefaultGradleBuilds;
import org.eclipse.core.resources.IProject;

public class DefaultGradleWorkspaceManager
implements GradleWorkspaceManager {
    @Override
    public GradleBuild getGradleBuild(FixedRequestAttributes attributes) {
        return new DefaultGradleBuild(attributes);
    }

    @Override
    public Optional<GradleBuild> getGradleBuild(IProject project) {
        Optional<ProjectConfiguration> configuration = CorePlugin.projectConfigurationManager().tryReadProjectConfiguration(project);
        if (configuration.isPresent()) {
            return Optional.of((Object)new DefaultGradleBuild(((ProjectConfiguration)configuration.get()).toRequestAttributes(ProjectConfiguration.ConversionStrategy.MERGE_WORKSPACE_SETTINGS)));
        }
        return Optional.absent();
    }

    @Override
    public GradleBuilds getGradleBuilds() {
        return new DefaultGradleBuilds(this.getBuilds((Collection<IProject>)CorePlugin.workspaceOperations().getAllProjects()));
    }

    @Override
    public GradleBuilds getGradleBuilds(Set<IProject> projects) {
        return new DefaultGradleBuilds(this.getBuilds(projects));
    }

    private Set<FixedRequestAttributes> getBuilds(Collection<IProject> projects) {
        return FluentIterable.from(projects).filter(GradleProjectNature.isPresentOn()).transform((Function)new Function<IProject, FixedRequestAttributes>(){

            public FixedRequestAttributes apply(IProject project) {
                Optional<ProjectConfiguration> configuration = CorePlugin.projectConfigurationManager().tryReadProjectConfiguration(project);
                return configuration.isPresent() ? ((ProjectConfiguration)configuration.get()).toRequestAttributes(ProjectConfiguration.ConversionStrategy.MERGE_WORKSPACE_SETTINGS) : null;
            }
        }).filter(Predicates.notNull()).toSet();
    }
}

