/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.WorkspaceConfiguration;
import org.eclipse.buildship.core.configuration.WorkspaceConfigurationManager;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class DefaultWorkspaceConfigurationManager
implements WorkspaceConfigurationManager {
    private static final String GRADLE_USER_HOME = "gradle.user.home";
    private static final String GRADLE_OFFLINE_MODE = "gradle.offline.mode";

    @Override
    public WorkspaceConfiguration loadWorkspaceConfiguration() {
        IEclipsePreferences preferences = this.getPreferences();
        String userHome = preferences.get(GRADLE_USER_HOME, null);
        boolean offlineMode = preferences.getBoolean(GRADLE_OFFLINE_MODE, false);
        return new WorkspaceConfiguration(userHome == null ? null : new File(userHome), offlineMode);
    }

    @Override
    public void saveWorkspaceConfiguration(WorkspaceConfiguration config) {
        Preconditions.checkNotNull((Object)config);
        IEclipsePreferences preferences = this.getPreferences();
        if (config.getGradleUserHome() == null) {
            preferences.remove(GRADLE_USER_HOME);
        } else {
            preferences.put(GRADLE_USER_HOME, config.getGradleUserHome().getPath());
        }
        preferences.putBoolean(GRADLE_OFFLINE_MODE, config.isOffline());
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            throw new GradlePluginsRuntimeException("Could not persist workspace preferences", e);
        }
    }

    private IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.buildship.core");
    }
}

