/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.apache.ode.deploy.ui.editors;

import java.io.IOException;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.bpel.apache.ode.deploy.model.dd.DocumentRoot;
import org.eclipse.bpel.apache.ode.deploy.model.dd.ProcessType;
import org.eclipse.bpel.apache.ode.deploy.model.dd.TDeployment;
import org.eclipse.bpel.apache.ode.deploy.model.dd.util.ddResourceFactoryImpl;
import org.eclipse.bpel.apache.ode.deploy.ui.messages.ODEDeployUIMessages;
import org.eclipse.bpel.apache.ode.deploy.ui.pages.ProcessPage;
import org.eclipse.bpel.apache.ode.deploy.ui.util.DeployUtils;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.Process;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class ODEDeployMultiPageEditor
extends FormEditor
implements IEditingDomainProvider {
    private boolean readOnly = false;
    private boolean modelInSync = true;
    protected TDeployment deployDescriptor = null;
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;

    public ODEDeployMultiPageEditor() {
        this.initializeEditingDomain();
    }

    public void doSave(IProgressMonitor monitor) {
        this.commitPages(true);
        this.saveDeploymentDescriptor();
        ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
        this.modelInSync = true;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException(ODEDeployUIMessages.ODEDeployEditor_No_SaveAs);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException(ODEDeployUIMessages.ODEDeployEditor_InvalidInput);
        }
        this.createModel();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void saveDeploymentDescriptor() {
        try {
            if (!this.readOnly) {
                this.deployDescriptor.eResource().save(null);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    protected Process loadBPEL(IFile bpelFile) {
        IPath fullProcessPath = bpelFile.getFullPath();
        URI uri = URI.createPlatformResourceURI((String)fullProcessPath.toString(), (boolean)false);
        Resource bpelResource = this.editingDomain.getResourceSet().getResource(uri, true);
        try {
            bpelResource.load(Collections.EMPTY_MAP);
            EList contents = bpelResource.getContents();
            if (!contents.isEmpty()) {
                return (Process)contents.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void addPages() {
        try {
            for (ProcessType pt : this.deployDescriptor.getProcess()) {
                this.addPage((IFormPage)new ProcessPage(this, pt));
            }
        }
        catch (PartInitException partInitException) {}
    }

    public TDeployment getDeploymentModel() {
        return this.deployDescriptor;
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                ODEDeployMultiPageEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ODEDeployMultiPageEditor.this.editorDirtyStateChanged();
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public boolean isDirty() {
        return !this.readOnly && (((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded() || !this.modelInSync);
    }

    public void setFocus() {
        if (this.getActivePage() != -1 && this.getControl(this.getActivePage()) != null) {
            this.getControl(this.getActivePage()).setFocus();
        }
    }

    protected void createModel() throws PartInitException {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Resource resource = null;
        ddResourceFactoryImpl fac = new ddResourceFactoryImpl();
        resource = fac.createResource(resourceURI);
        this.editingDomain.getResourceSet().getResources().add((Object)resource);
        try {
            resource.load(Collections.EMPTY_MAP);
            EList contents = resource.getContents();
            if (!contents.isEmpty() && contents.get(0) instanceof DocumentRoot) {
                this.deployDescriptor = ((DocumentRoot)contents.get(0)).getDeploy();
                this.populateModel();
            }
        }
        catch (CoreException e) {
            throw new PartInitException(e.getStatus());
        }
        catch (IOException e) {
            throw new PartInitException(e.getMessage(), (Throwable)e);
        }
        if (this.deployDescriptor.getProcess().isEmpty()) {
            Process p = BPELFactory.eINSTANCE.createProcess();
            p.setName(ODEDeployUIMessages.ODEDeployEditor_NO_PROCESSES_FOUND);
            ProcessType pt = DeployUtils.createProcessStub(p);
            this.deployDescriptor.getProcess().add((Object)pt);
            pt.setModel(p);
            this.readOnly = true;
            this.modelInSync = true;
        }
    }

    public void populateModel() throws CoreException {
        final Vector processesFound = new Vector();
        ((IFileEditorInput)this.getEditorInput()).getFile().getProject().accept(new IResourceVisitor(){

            public boolean visit(IResource bpelfile) throws CoreException {
                Process p;
                if (DeployUtils.isBPELFile(bpelfile) && (p = DeployUtils.loadBPEL((IFile)bpelfile, ODEDeployMultiPageEditor.this.editingDomain.getResourceSet())) != null) {
                    ProcessType pt = DeployUtils.findProcessTypeInDD(p, ODEDeployMultiPageEditor.this.deployDescriptor);
                    if (pt == null) {
                        pt = DeployUtils.createProcessStub(p);
                        ODEDeployMultiPageEditor.this.deployDescriptor.getProcess().add((Object)pt);
                        ODEDeployMultiPageEditor.this.modelInSync = false;
                    }
                    pt.setModel(p);
                    processesFound.add(pt);
                }
                return true;
            }
        });
        Vector<ProcessType> processesToDelete = new Vector<ProcessType>();
        for (ProcessType pt : this.deployDescriptor.getProcess()) {
            if (processesFound.contains(pt)) continue;
            processesToDelete.add(pt);
        }
        if (processesToDelete.size() > 0) {
            this.deployDescriptor.getProcess().removeAll(processesToDelete);
            this.modelInSync = false;
        }
    }
}

