/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IGroupInstanceInfo;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.IPLSDataPopulator;
import org.eclipse.birt.data.engine.impl.document.ResultIterator;

public class PLSDataPopulator2
implements IPLSDataPopulator {
    private List<Boundary2> targetBoundaries;
    private int rowIndex = -1;
    private ResultIterator docIt;
    private Boundary2 currentBoundary;
    private boolean isEmpty;

    PLSDataPopulator2(List<IGroupInstanceInfo> targetGroups, ResultIterator docIt) throws DataException {
        this.docIt = docIt;
        this.populateBoundary(targetGroups);
        this.populateEmptyInfo();
    }

    @Override
    public ResultIterator getDocumentIterator() {
        return this.docIt;
    }

    private void populateEmptyInfo() {
        this.isEmpty = this.currentBoundary == null || this.currentBoundary.getStart() >= this.docIt.getExprResultSet().getDataSetResultSet().getRowCount();
    }

    private void populateBoundary(List<IGroupInstanceInfo> targetGroups) {
        ArrayList<IGroupInstanceInfo> groups = new ArrayList<IGroupInstanceInfo>(targetGroups);
        Collections.sort(groups, new Comparator<IGroupInstanceInfo>(){

            @Override
            public int compare(IGroupInstanceInfo arg0, IGroupInstanceInfo arg1) {
                if (arg0.getGroupLevel() < arg1.getGroupLevel()) {
                    return -1;
                }
                if (arg0.getGroupLevel() > arg1.getGroupLevel()) {
                    return 1;
                }
                if (arg0.getRowId() < arg1.getRowId()) {
                    return -1;
                }
                if (arg0.getRowId() > arg1.getRowId()) {
                    return 1;
                }
                return 0;
            }
        });
        LinkedList<Boundary2> boundaries = new LinkedList<Boundary2>();
        block0: for (IGroupInstanceInfo info : groups) {
            Boundary2 b = new Boundary2(info.getGroupLevel(), info.getRowId());
            for (Boundary2 target : boundaries) {
                if (b.containedBy(target)) continue block0;
            }
            boundaries.add(b);
        }
        Collections.sort(boundaries, new Comparator<Boundary2>(){

            @Override
            public int compare(Boundary2 o1, Boundary2 o2) {
                if (o1.start < o2.start) {
                    return -1;
                }
                if (o1.start > o2.start) {
                    return 1;
                }
                return 0;
            }
        });
        if (boundaries.size() > 0) {
            this.currentBoundary = (Boundary2)boundaries.get(0);
        }
        this.targetBoundaries = boundaries;
    }

    @Override
    public void close() throws DataException {
        try {
            this.docIt.close();
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean next() throws DataException {
        if (this.isEmpty) {
            return false;
        }
        try {
            if (this.currentBoundary == null) {
                return false;
            }
            if (!this.docIt.next()) return false;
            this.getDocumentIterator().getExprResultSet().getDataSetResultSet().next();
            if (this.docIt.getRowIndex() < this.currentBoundary.start) {
                this.docIt.moveTo(this.currentBoundary.start);
                this.getDocumentIterator().getExprResultSet().getDataSetResultSet().skipTo(this.currentBoundary.start);
            }
            if (this.docIt.getEndingGroupLevel() == this.currentBoundary.endGroupLevel) {
                this.targetBoundaries.remove(this.currentBoundary);
                if (this.targetBoundaries.size() == 0) {
                    ++this.rowIndex;
                    this.currentBoundary = null;
                    return true;
                }
                this.currentBoundary = this.targetBoundaries.get(0);
            }
            ++this.rowIndex;
            return true;
        }
        catch (BirtException e1) {
            throw DataException.wrap(e1);
        }
    }

    protected static class Boundary2 {
        private int start;
        int startGroupLevel;
        int endGroupLevel;

        Boundary2(int groupLevel, int start) {
            this.start = start;
            this.startGroupLevel = groupLevel;
            this.endGroupLevel = groupLevel;
        }

        public boolean containedBy(Boundary2 target) {
            return target.start == this.start;
        }

        public int getStart() {
            return this.start;
        }
    }
}

