/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.refactoring;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.common.types.access.impl.Primitives;
import org.eclipse.xtext.common.types.xtext.ui.JdtVariableCompletions;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IExpressionScope;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class NewFeatureNameUtil {
    @Inject
    private IValueConverterService valueConverterService;
    @Inject
    private IBatchTypeResolver batchTypeResolver;
    @Inject
    private JdtVariableCompletions jdtVariableCompletions;
    private Set<String> allKeywords;
    private IScope featureCallScope;

    @Inject
    public NewFeatureNameUtil(IGrammarAccess grammarAccess) {
        this.allKeywords = GrammarUtil.getAllKeywords((Grammar)grammarAccess.getGrammar());
    }

    public void setFeatureScopeContext(XExpression siblingExpression) {
        XBlockExpression containerBlock = siblingExpression.eContainer() instanceof XBlockExpression ? (XBlockExpression)siblingExpression.eContainer() : null;
        XExpression context = siblingExpression;
        if (containerBlock != null && !containerBlock.getExpressions().isEmpty()) {
            context = (EObject)containerBlock.getExpressions().get(containerBlock.getExpressions().size() - 1);
        }
        IExpressionScope expressionScope = this.batchTypeResolver.resolveTypes((EObject)context).getExpressionScope((EObject)context, IExpressionScope.Anchor.AFTER);
        this.featureCallScope = expressionScope.getFeatureScope();
    }

    public void checkNewFeatureName(String newFeatureName, boolean isLookupInScope, RefactoringStatus status) {
        Class asPrimitive;
        if (Strings.isEmpty((String)newFeatureName)) {
            status.addFatalError("Choose a name");
            return;
        }
        try {
            Object value = this.valueConverterService.toValue(newFeatureName, "ValidID", null);
            this.valueConverterService.toString(value, "ValidID");
        }
        catch (ValueConverterException exc) {
            status.addFatalError(exc.getMessage());
        }
        if (Character.isUpperCase(newFeatureName.charAt(0))) {
            status.addError("Discouraged name '" + newFeatureName + "'. Name should start with a lowercase letter. ");
        }
        if (this.isKeyword(newFeatureName)) {
            status.addFatalError("'" + newFeatureName + "' is keyword.");
        }
        if ((asPrimitive = Primitives.forName((String)newFeatureName)) != null) {
            status.addFatalError("'" + newFeatureName + "' is reserved.");
        }
        if (isLookupInScope && this.featureCallScope != null && this.isAlreadyDefined(newFeatureName)) {
            status.addError("The name '" + newFeatureName + "' is already defined in this scope.");
        }
    }

    protected boolean isKeyword(String newFeatureName) {
        return this.allKeywords.contains(newFeatureName);
    }

    protected boolean isAlreadyDefined(String newFeatureName) {
        IEObjectDescription existing = this.featureCallScope.getSingleElement(QualifiedName.create((String)newFeatureName));
        return existing != null;
    }

    public String getDefaultName(XExpression expression) {
        String baseName = this.getBaseName(expression);
        final ArrayList candidates = Lists.newArrayList();
        HashSet<String> excludedNames = new HashSet<String>(this.allKeywords);
        for (IEObjectDescription featureDescription : this.featureCallScope.getAllElements()) {
            QualifiedName featureQName = featureDescription.getQualifiedName();
            if (featureQName.getSegmentCount() != 1) continue;
            excludedNames.add(featureQName.getLastSegment());
        }
        this.jdtVariableCompletions.getVariableProposals(baseName, (EObject)expression, JdtVariableCompletions.VariableType.LOCAL_VAR, excludedNames, new JdtVariableCompletions.CompletionDataAcceptor(){

            public void accept(String replaceText, StyledString label, Image img) {
                candidates.add(replaceText);
            }
        });
        return candidates.isEmpty() ? "dingenskirchen" : (String)candidates.get(0);
    }

    protected String getBaseName(XExpression expression) {
        if (expression instanceof XMemberFeatureCall || expression instanceof XFeatureCall) {
            String featureName = ((XAbstractFeatureCall)expression).getFeature().getSimpleName();
            if (featureName.startsWith("get")) {
                return featureName.substring(3);
            }
            if (featureName.startsWith("is")) {
                return featureName.substring(2);
            }
            return featureName;
        }
        if (expression instanceof XClosure) {
            return "function";
        }
        LightweightTypeReference type = this.batchTypeResolver.resolveTypes((EObject)expression).getActualType(expression);
        if (type != null) {
            return type.getSimpleName();
        }
        return "";
    }
}

