/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.folding.FoldedPosition;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;

@Beta
public abstract class AbstractFoldingTest
extends AbstractEditorTest {
    @Inject
    protected FileExtensionProvider fileExtensionProvider;
    @Inject
    protected IFoldingRegionProvider foldingRegionProvider;

    public String b() {
        return "[>";
    }

    public String e() {
        return "<]";
    }

    public void testFoldingRegions(CharSequence charSequence) {
        IFile file = this.dslFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), this.getContent(charSequence));
        this.foldingRegionsArePresent(this.openInEditor(file), charSequence);
    }

    protected String getProjectName() {
        return "FoldingTestProject";
    }

    protected String getFileName() {
        return "folding";
    }

    protected String getFileExtension() {
        return this.fileExtensionProvider.getPrimaryFileExtension();
    }

    protected String getContent(CharSequence text) {
        return text.toString().replace(this.b(), "").replace(this.e(), "");
    }

    protected IXtextDocument openInEditor(IFile dslFile) {
        try {
            IXtextDocument document = this.openEditor(dslFile).getDocument();
            AbstractFoldingTest.assertNotNull((Object)document);
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void foldingRegionsArePresent(IXtextDocument document, CharSequence expected) {
        AbstractFoldingTest.assertEquals((Object)expected.toString().trim(), (Object)this.insertFoldingRegionMarkers(document));
    }

    protected String insertFoldingRegionMarkers(IXtextDocument document) {
        if (document.getLength() == 0) {
            return null;
        }
        try {
            String lineSeparator = document.getLineDelimiter(0);
            if (lineSeparator == null) {
                lineSeparator = document.getLegalLineDelimiters()[0];
            }
            return this.insertFoldingRegionMarkers(document, lineSeparator);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected String insertFoldingRegionMarkers(IXtextDocument document, String lineSeparator) {
        List<String> lines = Arrays.asList(document.get().split(lineSeparator));
        try {
            for (FoldedPosition foldingRegion : this.foldingRegionProvider.getFoldingRegions(document)) {
                int startLine = document.getLineOfOffset(foldingRegion.offset);
                lines.set(startLine, this.b() + lines.get(startLine));
                int endLine = document.getLineOfOffset(foldingRegion.offset + foldingRegion.length) - 1;
                lines.set(endLine, lines.get(endLine) + this.e());
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        return Joiner.on((String)lineSeparator).join(lines);
    }
}

