/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.interpreter.internal.language;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.ui.interpreter.internal.view.Variable;

public class InterpreterContext {
    private final String expression;
    private final ISelection selection;
    @Deprecated
    private final List<EObject> targetEObjects;
    private final List<Notifier> targetNotifiers;
    private final List<Variable> variables;

    public InterpreterContext(InterpreterContext context) {
        this.expression = context.expression;
        this.selection = context.selection;
        this.targetEObjects = new ArrayList<EObject>(context.targetEObjects);
        this.targetNotifiers = new ArrayList<Notifier>(context.targetNotifiers);
        this.variables = new ArrayList<Variable>(context.variables);
    }

    public InterpreterContext(String expression, ISelection selection, List<Notifier> targetNotifiers, List<Variable> variables) {
        this.expression = expression;
        this.selection = selection;
        this.targetNotifiers = targetNotifiers;
        this.targetEObjects = new ArrayList<EObject>(targetNotifiers.size());
        for (Notifier notifier : targetNotifiers) {
            if (!(notifier instanceof EObject)) continue;
            this.targetEObjects.add((EObject)notifier);
        }
        this.variables = variables;
    }

    public String getExpression() {
        return this.expression;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    @Deprecated
    public List<EObject> getTargetEObjects() {
        return this.targetEObjects;
    }

    public List<Notifier> getTargetNotifiers() {
        return this.targetNotifiers;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }
}

