/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.spi.net4j;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.internal.net4j.TransportConfig;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.ITransportConfig;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.util.security.INegotiator;
import org.eclipse.spi.net4j.InternalAcceptor;
import org.eclipse.spi.net4j.InternalConnector;

public abstract class Acceptor
extends Container<IConnector>
implements InternalAcceptor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_ACCEPTOR, Acceptor.class);
    private final IRegistry<String, Object> properties = new HashMapRegistry.AutoCommit();
    private ITransportConfig config;
    private ConnectorPreparer connectorPreparer;
    private transient IListener connectorListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            Acceptor.this.removeConnector((IConnector)lifecycle);
        }
    };
    private Set<IConnector> acceptedConnectors = new HashSet<IConnector>(0);

    public final IRegistry<String, Object> properties() {
        return this.properties;
    }

    @Override
    public boolean needsBufferProvider() {
        return true;
    }

    @Override
    public synchronized ITransportConfig getConfig() {
        if (this.config == null) {
            this.config = new TransportConfig((ILifecycle)this);
        }
        return this.config;
    }

    @Override
    public synchronized void setConfig(ITransportConfig config) {
        this.config = Net4jUtil.copyTransportConfig((ILifecycle)this, config);
    }

    public ConnectorPreparer getConnectorPreparer() {
        return this.connectorPreparer;
    }

    public void setConnectorPreparer(ConnectorPreparer connectorPreparer) {
        this.connectorPreparer = connectorPreparer;
    }

    public INegotiator getNegotiator() {
        return this.getConfig().getNegotiator();
    }

    public void setNegotiator(INegotiator negotiator) {
        this.getConfig().setNegotiator(negotiator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConnector[] getAcceptedConnectors() {
        Set<IConnector> set = this.acceptedConnectors;
        synchronized (set) {
            return this.acceptedConnectors.toArray(new IConnector[this.acceptedConnectors.size()]);
        }
    }

    public boolean isEmpty() {
        return this.acceptedConnectors.isEmpty();
    }

    public IConnector[] getElements() {
        return this.getAcceptedConnectors();
    }

    public void prepareConnector(InternalConnector connector) {
        connector.setConfig(this.getConfig());
        if (this.connectorPreparer != null) {
            this.connectorPreparer.prepareConnector(connector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(InternalConnector connector) {
        Set<IConnector> set = this.acceptedConnectors;
        synchronized (set) {
            this.acceptedConnectors.add(connector);
        }
        connector.addListener(this.connectorListener);
        if (TRACER.isEnabled()) {
            TRACER.trace("Added connector " + connector);
        }
        this.fireElementAddedEvent(connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnector(IConnector connector) {
        connector.removeListener(this.connectorListener);
        Set<IConnector> set = this.acceptedConnectors;
        synchronized (set) {
            this.acceptedConnectors.remove(connector);
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Removed connector " + connector);
        }
        this.fireElementRemovedEvent(connector);
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.needsBufferProvider()) {
            this.checkState(this.getConfig().getBufferProvider(), "getConfig().getBufferProvider()");
        }
    }

    protected void doDeactivate() throws Exception {
        IConnector[] iConnectorArray = this.getAcceptedConnectors();
        int n = iConnectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnector connector = iConnectorArray[n2];
            connector.close();
            ++n2;
        }
        super.doDeactivate();
    }

    public static interface ConnectorPreparer {
        public void prepareConnector(InternalConnector var1);
    }
}

