/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.launcher.compat;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.emf.EMFInjector;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.emf.EMFReferenceModel;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.m2m.atl.core.service.LauncherService;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Messages;
import org.eclipse.m2m.atl.emftvm.Metamodel;
import org.eclipse.m2m.atl.emftvm.Model;
import org.eclipse.m2m.atl.emftvm.Module;
import org.eclipse.m2m.atl.emftvm.util.DefaultModuleResolver;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;
import org.eclipse.m2m.atl.emftvm.util.LazyCollections;
import org.eclipse.m2m.atl.emftvm.util.ModuleNotFoundException;
import org.eclipse.m2m.atl.emftvm.util.ModuleResolver;
import org.eclipse.m2m.atl.emftvm.util.TimingData;
import org.eclipse.m2m.atl.emftvm.util.VMException;
import org.eclipse.m2m.atl.emftvm.util.VMMonitor;

public class EMFTVMLauncher
implements ILauncher {
    public static final String MODEL_FACTORY_NAME = "EMF";
    private static final String EMF_URI_PREFIX = "emftvm://";
    protected Map<String, IModel> models;
    protected Map<String, Module> libraries;
    protected ResourceSet moduleResourceSet;
    protected ModuleResolver moduleResolver;
    protected ExecEnv execEnv;
    protected ResourceSet outputResourceSet;
    protected TimingData timingData;

    public String getName() {
        return "EMFTVM";
    }

    protected Model addModel(IModel model, String name, String referenceModelName) {
        Model emftvmModel;
        if (this.models.containsKey(name)) {
            ATLLogger.warning((String)Messages.getString("EMFTVMLauncher.MODEL_REGISTERED", name));
            emftvmModel = null;
        } else {
            this.models.put(name, model);
            EMFModel emfModel = (EMFModel)model;
            Resource resource = emfModel.getResource();
            if (resource == null) {
                EMFInjector emfInjector;
                try {
                    emfInjector = (EMFInjector)CoreService.getInjector((String)MODEL_FACTORY_NAME);
                }
                catch (ATLCoreException e) {
                    throw new VMException(null, e.getLocalizedMessage(), e);
                }
                emfInjector.inject((IModel)emfModel, this.outputResourceSet.createResource(URI.createURI((String)(String.valueOf(name) + ".xmi"))));
            }
            emftvmModel = EmftvmFactory.eINSTANCE.createModel(emfModel.getResource());
        }
        if (!this.models.containsKey(referenceModelName)) {
            this.models.put(referenceModelName, (IModel)model.getReferenceModel());
            Metamodel metamodel = EmftvmFactory.eINSTANCE.createMetamodel(((EMFReferenceModel)model.getReferenceModel()).getResource());
            this.execEnv.registerMetaModel(referenceModelName, metamodel);
        }
        return emftvmModel;
    }

    public void addInModel(IModel model, String name, String referenceModelName) {
        model.setIsTarget(false);
        Model emftvmModel = this.addModel(model, name, referenceModelName);
        if (emftvmModel != null) {
            this.execEnv.registerInputModel(name, emftvmModel);
        }
    }

    public void addInOutModel(IModel model, String name, String referenceModelName) {
        model.setIsTarget(true);
        Model emftvmModel = this.addModel(model, name, referenceModelName);
        if (emftvmModel != null) {
            this.execEnv.registerInOutModel(name, emftvmModel);
        }
    }

    public void addOutModel(IModel model, String name, String referenceModelName) {
        model.setIsTarget(true);
        Model emftvmModel = this.addModel(model, name, referenceModelName);
        if (emftvmModel != null) {
            this.execEnv.registerOutputModel(name, emftvmModel);
        }
    }

    public void addLibrary(String name, Object library) {
        if (this.libraries.containsKey(name)) {
            ATLLogger.warning((String)Messages.getString("EMFTVMLauncher.LIBRARY_REGISTERED", name));
        } else {
            this.libraries.put(name, this.getModuleFromObject(library));
        }
    }

    public void initialize(Map<String, Object> parameters) {
        this.models = new HashMap<String, IModel>();
        this.libraries = new HashMap<String, Module>();
        this.moduleResourceSet = new ResourceSetImpl();
        this.moduleResolver = new DefaultModuleResolver(EMF_URI_PREFIX, this.moduleResourceSet);
        this.execEnv = EmftvmFactory.eINSTANCE.createExecEnv();
        this.outputResourceSet = new ResourceSetImpl();
        this.timingData = new TimingData();
    }

    public Object launch(String mode, IProgressMonitor monitor, Map<String, Object> options, Object ... modules) {
        return this.internalLaunch(null, monitor, options, modules);
    }

    protected Object internalLaunch(VMMonitor tool, IProgressMonitor monitor, Map<String, Object> options, Object ... modules) {
        this.getModuleFromObject(modules[0]);
        int i = 1;
        while (i < modules.length) {
            this.getModuleFromObject(modules[i]);
            ++i;
        }
        for (Model model : LazyCollections.asLazySet(this.execEnv.getInoutModels().values()).union(LazyCollections.asLazySet(this.execEnv.getOutputModels().values()))) {
            model.setAllowInterModelReferences(LauncherService.getBooleanOption((Object)options.get("allowInterModelReferences"), (boolean)false));
        }
        this.execEnv.setMonitor(tool);
        this.execEnv.setJitDisabled(LauncherService.getBooleanOption((Object)options.get("jitDisabled"), (boolean)false));
        this.timingData.finishLoading();
        Object result = this.execEnv.run(this.timingData);
        this.timingData.finish();
        if (LauncherService.getBooleanOption((Object)options.get("printExecutionTime"), (boolean)false)) {
            ATLLogger.info((String)this.timingData.toString());
        }
        return result;
    }

    public Module loadModule(InputStream inputStream) {
        Resource resource = this.moduleResourceSet.createResource(URI.createURI((String)(String.valueOf(UUID.randomUUID().toString()) + ".emftvm")));
        try {
            resource.load(inputStream, Collections.emptyMap());
            Module module = this.findModule(resource);
            Matcher matcher = EMFTVMUtil.DELIM_PATTERN.matcher(module.getName());
            String path = matcher.replaceAll("/");
            resource.setURI(URI.createURI((String)(EMF_URI_PREFIX + path + ".emftvm")));
            this.execEnv.loadModule(this.moduleResolver, module.getName());
            return module;
        }
        catch (IOException e) {
            throw new VMException(null, e.getLocalizedMessage(), e);
        }
    }

    protected Module getModuleFromObject(Object module) {
        if (module instanceof InputStream) {
            return this.loadModule((InputStream)module);
        }
        if (module instanceof Module) {
            return (Module)module;
        }
        return null;
    }

    private Module findModule(Resource r) throws ModuleNotFoundException {
        for (EObject o : r.getContents()) {
            if (!(o instanceof Module)) continue;
            return (Module)o;
        }
        return null;
    }

    public IModel getModel(String modelName) {
        return this.models.get(modelName);
    }

    public Object getLibrary(String libraryName) {
        return this.libraries.get(libraryName);
    }

    public String getDefaultModelFactoryName() {
        return MODEL_FACTORY_NAME;
    }

    public String[] getModes() {
        return new String[]{"run"};
    }
}

