/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.types;

import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.common.internal.types.IAssignable;
import org.eclipse.jst.jsf.common.internal.types.SignatureBasedType;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.internal.types.TypeUtil;

public class ValueType
implements SignatureBasedType,
IAssignable {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String _signature;
    private final String[] _typeArgs;
    private final int _assignmentMask;
    private final String[] _superTypes;
    private final String[] _interfaceTypes;
    private final boolean _isEnumType;
    private String[] _allTypes;

    public ValueType(String signature, String[] typeArgs, String[] superTypes, String[] interfaceTypes, boolean isEnumType, int assignmentMask) {
        if (signature == null) {
            throw new AssertionError((Object)"signature can never be null");
        }
        this._signature = signature;
        this._typeArgs = typeArgs;
        this._assignmentMask = assignmentMask;
        this._superTypes = superTypes != null ? superTypes : EMPTY_STRING_ARRAY;
        this._interfaceTypes = interfaceTypes != null ? interfaceTypes : EMPTY_STRING_ARRAY;
        this._isEnumType = isEnumType;
    }

    public ValueType(ValueType template, int assignmentMask) {
        this(template._signature, template._typeArgs, template._superTypes, template._interfaceTypes, template._isEnumType, assignmentMask);
    }

    public ValueType(String signature, int assignmentMask) {
        this(signature, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, false, assignmentMask);
    }

    @Override
    public String getSignature() {
        return this._signature;
    }

    @Override
    public int getAssignability() {
        return this._assignmentMask;
    }

    @Override
    public boolean isLHS() {
        return TypeUtil.matchesLHS(this._assignmentMask);
    }

    @Override
    public boolean isRHS() {
        return TypeUtil.matchesRHS(this._assignmentMask);
    }

    public String toString() {
        return Signature.getSignatureSimpleName((String)TypeTransformer.transformBoxPrimitives(this._signature));
    }

    public String[] getSuperTypes() {
        return this._superTypes;
    }

    public String[] getInterfaceTypes() {
        return this._interfaceTypes;
    }

    public String[] getAllTypes() {
        if (this._allTypes == null) {
            int numberOfTypes = 1 + this._superTypes.length + this._interfaceTypes.length;
            this._allTypes = new String[numberOfTypes];
            this._allTypes[0] = this._signature;
            System.arraycopy(this._superTypes, 0, this._allTypes, 1, this._superTypes.length);
            System.arraycopy(this._interfaceTypes, 0, this._allTypes, 1 + this._superTypes.length, this._interfaceTypes.length);
        }
        return this._allTypes;
    }

    public String[] getTypeArguments() {
        return this._typeArgs;
    }

    @Override
    public CompositeType toCompositeType() {
        return new CompositeType(this.getAllTypes(), this.getAssignability());
    }

    public boolean isInstanceOf(String signature) {
        if (this.isArray()) {
            return this.getSignature().equals(signature);
        }
        String[] allTypes = this.getAllTypes();
        int i = 0;
        while (i < allTypes.length) {
            if (allTypes[i].equals(signature)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isArray() {
        return Signature.getArrayCount((String)this.getSignature()) > 0;
    }

    public boolean isEnumType() {
        return this._isEnumType;
    }
}

