/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.tcl.ast.AstFactory;
import org.eclipse.dltk.tcl.ast.Script;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.internal.structure.TclSourceElementParser2;
import org.eclipse.dltk.tcl.internal.structure.TclTypeResolver;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.TclParser;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionManager;
import org.eclipse.dltk.tcl.parser.definitions.IScopeProcessor;
import org.eclipse.dltk.tcl.parser.definitions.NamespaceScopeProcessor;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;
import org.eclipse.dltk.tcl.structure.ITclTypeHandler;
import org.eclipse.dltk.tcl.structure.ITclTypeResolver;
import org.eclipse.dltk.tcl.structure.TclProcessorUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TclModelBuildContext
implements ITclModelBuildContext {
    private final TclSourceElementParser2 fParser;
    private final ISourceElementRequestor fRequestor;
    private final ITclErrorReporter errorReporter;
    private Stack<ITclTypeHandler> exitStack = new Stack();
    private Map<TclCommand, List<ITclModelBuildContext.ITclModelHandler>> handlers = new IdentityHashMap<TclCommand, List<ITclModelBuildContext.ITclModelHandler>>();
    private TclTypeResolver typeResolver = null;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public TclModelBuildContext(TclSourceElementParser2 parser, ISourceElementRequestor requestor, ITclErrorReporter errorReporter) {
        this.fParser = parser;
        this.fRequestor = requestor;
        this.errorReporter = errorReporter;
        this.exitStack.push(new TopLevelNamespace());
    }

    @Override
    public ISourceElementRequestor getRequestor() {
        return this.fRequestor;
    }

    @Override
    public ITclErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public String getEnclosingNamespace() {
        int head = this.exitStack.size();
        while (--head >= 0) {
            ITclTypeHandler handler = (ITclTypeHandler)this.exitStack.get(head);
            String namespace = handler.getNamespace();
            if (namespace == null) continue;
            return namespace;
        }
        return null;
    }

    @Override
    public void addHandler(TclCommand command, ITclModelBuildContext.ITclModelHandler handler) {
        List<ITclModelBuildContext.ITclModelHandler> commandHandlers = this.handlers.get(command);
        if (commandHandlers == null) {
            commandHandlers = new ArrayList<ITclModelBuildContext.ITclModelHandler>(4);
            this.handlers.put(command, commandHandlers);
        }
        commandHandlers.add(handler);
        if (handler instanceof ITclTypeHandler) {
            this.exitStack.push((ITclTypeHandler)handler);
        }
    }

    @Override
    public void leave(TclCommand command) {
        List<ITclModelBuildContext.ITclModelHandler> commandHandlers = this.handlers.remove(command);
        if (commandHandlers != null) {
            for (ITclModelBuildContext.ITclModelHandler handler : commandHandlers) {
                handler.leave(this.fRequestor);
                if (!(handler instanceof ITclTypeHandler)) continue;
                this.exitStack.remove(handler);
            }
        }
    }

    @Override
    public void enterNamespace(ITclTypeHandler typeHandler) {
        this.exitStack.push(typeHandler);
    }

    @Override
    public void leaveNamespace(ITclTypeHandler namespace) {
        if (this.exitStack.remove(namespace)) {
            namespace.leave(this.fRequestor);
        }
    }

    @Override
    public <E> E get(Class<E> clazz) {
        if (clazz == ITclTypeResolver.class) {
            if (this.typeResolver == null) {
                this.typeResolver = new TclTypeResolver(this.fRequestor, this);
            }
            return (E)this.typeResolver;
        }
        return null;
    }

    @Override
    public List<TclCommand> parse(String source, int offset) {
        return this.parse(source, offset, 0);
    }

    public List<TclCommand> parse(String source, int offset, int options) {
        TclParser newParser = new TclParser();
        newParser.setGlobalOffset(offset);
        NamespaceScopeProcessor coreProcessor = DefinitionManager.getInstance().createProcessor();
        List commands = newParser.parse(source, this.errorReporter, (IScopeProcessor)coreProcessor);
        if ((options & 1) == 0) {
            this.fParser.traverse(commands, this);
        }
        return commands;
    }

    @Override
    public Script parse(TclArgument arg) {
        return this.parse(arg, 0);
    }

    @Override
    public Script parse(TclArgument arg, int options) {
        if (arg instanceof Script) {
            Script script = (Script)arg;
            if ((options & 1) == 0) {
                this.fParser.traverse((List<TclCommand>)script.getCommands(), this);
            }
            return script;
        }
        Script script = AstFactory.eINSTANCE.createScript();
        script.setStart(arg.getStart());
        script.setEnd(arg.getEnd());
        ITclModelBuildContext.ITclParserInput input = TclProcessorUtil.asInput(arg);
        if (input != null) {
            script.setContentStart(input.getStart());
            script.setContentEnd(input.getEnd());
            script.getCommands().addAll(this.parse(input.getContent(), input.getStart(), options));
        } else {
            script.setContentStart(arg.getStart());
            script.setContentEnd(arg.getEnd());
        }
        EcoreUtil.replace((EObject)arg, (EObject)script);
        return script;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    private static class TopLevelNamespace
    implements ITclTypeHandler {
        private TopLevelNamespace() {
        }

        @Override
        public String getNamespace() {
            return "::";
        }

        @Override
        public void leave(ISourceElementRequestor requestor) {
        }
    }
}

