/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oracle.ui.drivers;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.datatools.connectivity.ui.wizards.OptionalPropertiesPane;
import org.eclipse.datatools.enablement.oracle.internal.ui.drivers.Messages;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class OracleThinDriverUIContributorBase
implements IDriverUIContributor,
Listener {
    private static final String CUI_NEWCW_DATABASE_LBL_UI_ = TextProcessor.process((String)Messages.getString("CUI_NEWCW_DATABASE_LBL_UI_"));
    private static final String CUI_NEWCW_HOST_LBL_UI_ = Messages.getString("CUI_NEWCW_HOST_LBL_UI_");
    private static final String CUI_NEWCW_PORT_LBL_UI_ = Messages.getString("CUI_NEWCW_PORT_LBL_UI_");
    private static final String CUI_NEWCW_USERNAME_LBL_UI_ = Messages.getString("CUI_NEWCW_USERNAME_LBL_UI_");
    private static final String CUI_NEWCW_PASSWORD_LBL_UI_ = Messages.getString("CUI_NEWCW_PASSWORD_LBL_UI_");
    private static final String CUI_NEWCW_SAVE_PASSWORD_LBL_UI_ = Messages.getString("CUI_NEWCW_SAVE_PASSWORD_LBL_UI_");
    private static final String CUI_NEWCW_CONNECTIONURL_LBL_UI_ = Messages.getString("CUI_NEWCW_CONNECTIONURL_LBL_UI_");
    private static final String CATALOG_LBL_UI_ = Messages.getString("CATALOG_LBL_UI_");
    private static final String ALL_CATALOGS = Messages.getString("ALL_CATALOGS_OPTION_UI_");
    private static final String DBA_CATALOG = Messages.getString("DBA_CATALOG_OPTION_UI_");
    private static final String USER_CATALOG = Messages.getString("USER_CATALOG_OPTION_UI_");
    private static final String CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_CATALOG_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_CATALOG_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_URL_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_URL_SUMMARY_DATA_TEXT_");
    private IDriverUIContributorInformation contributorInformation;
    private Label databaseLabel;
    protected Button svcBtn;
    protected Button sidBtn;
    protected boolean isUsingService;
    protected Text databaseText;
    private Text serviceText;
    private Text sidText;
    private Label hostLabel;
    protected Text hostText;
    private Label portLabel;
    protected Text portText;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Button savePasswordButton;
    private Label urlLabel;
    protected Text urlText;
    private Label catalogLabel;
    private Combo catalogCombo;
    protected DialogPage parentPage;
    private ScrolledComposite parentComposite;
    protected OptionalPropertiesPane optionalPropsComposite;
    private Properties properties;
    protected boolean isReadOnly = false;

    public boolean determineContributorCompletion() {
        boolean isComplete = true;
        if (this.databaseText.getText().trim().length() < 1) {
            if (!this.isDialogUsingService()) {
                this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_"));
            } else {
                this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_SERVICE_REQ_UI_"));
            }
            isComplete = false;
        } else if (this.hostText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_HOST_REQ_UI_"));
            isComplete = false;
        } else if (this.portText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_PORT_REQ_UI_"));
            isComplete = false;
        } else if (this.usernameText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_USERID_REQ_UI_"));
            isComplete = false;
        } else if (this.passwordText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_PASSWORD_REQ_UI_"));
            isComplete = false;
        } else if (!this.optionalPropsComposite.validateControl(this.parentPage)) {
            isComplete = false;
        }
        if (isComplete) {
            this.parentPage.setErrorMessage(null);
        }
        return isComplete;
    }

    public Composite getContributedDriverUI(Composite parent, boolean isReadOnlyUI) {
        if (this.parentComposite == null || this.parentComposite.isDisposed() || this.isReadOnly != isReadOnlyUI) {
            this.isReadOnly = isReadOnlyUI;
            int additionalStyles = 0;
            if (isReadOnlyUI) {
                additionalStyles = 8;
            }
            this.parentComposite = new ScrolledComposite(parent, 768);
            this.parentComposite.setExpandHorizontal(true);
            this.parentComposite.setExpandVertical(true);
            this.parentComposite.setLayout((Layout)new GridLayout());
            TabFolder tabComposite = new TabFolder((Composite)this.parentComposite, 128);
            TabItem generalTab = new TabItem(tabComposite, 0);
            generalTab.setText(ConnectivityUIPlugin.getDefault().getResourceString("CommonDriverUIContributor.generaltab"));
            Composite baseComposite = new Composite((Composite)tabComposite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            baseComposite.setLayout((Layout)layout);
            generalTab.setControl((Control)baseComposite);
            this.databaseLabel = new Label(baseComposite, 0);
            this.databaseLabel.setText(CUI_NEWCW_DATABASE_LBL_UI_);
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            this.databaseLabel.setLayoutData((Object)gd);
            this.svcBtn = new Button(baseComposite, 16);
            this.svcBtn.setText("Service Name");
            this.svcBtn.setSelection(true);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 1;
            this.svcBtn.setLayoutData((Object)gd);
            this.serviceText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 1;
            gd.grabExcessHorizontalSpace = true;
            this.serviceText.setLayoutData((Object)gd);
            this.databaseText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 1;
            gd.grabExcessHorizontalSpace = false;
            gd.widthHint = 0;
            this.databaseText.setLayoutData((Object)gd);
            this.databaseText.setEnabled(false);
            this.databaseText.setVisible(false);
            this.sidBtn = new Button(baseComposite, 16);
            this.sidBtn.setText("SID");
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 1;
            this.sidBtn.setLayoutData((Object)gd);
            this.sidText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 1;
            gd.grabExcessHorizontalSpace = true;
            this.sidText.setLayoutData((Object)gd);
            this.sidText.setEnabled(false);
            this.urlLabel = new Label(baseComposite, 0);
            this.urlLabel.setText(CUI_NEWCW_CONNECTIONURL_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.urlLabel.setLayoutData((Object)gd);
            this.urlText = new Text(baseComposite, 2060);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.urlText.setLayoutData((Object)gd);
            this.hostLabel = new Label(baseComposite, 0);
            this.hostLabel.setText(CUI_NEWCW_HOST_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.hostLabel.setLayoutData((Object)gd);
            this.hostText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            this.hostText.setLayoutData((Object)gd);
            this.portLabel = new Label(baseComposite, 0);
            this.portLabel.setText(CUI_NEWCW_PORT_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.portLabel.setLayoutData((Object)gd);
            this.portText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.portText.setLayoutData((Object)gd);
            this.usernameLabel = new Label(baseComposite, 0);
            this.usernameLabel.setText(CUI_NEWCW_USERNAME_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.usernameLabel.setLayoutData((Object)gd);
            this.usernameText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.usernameText.setLayoutData((Object)gd);
            this.passwordLabel = new Label(baseComposite, 0);
            this.passwordLabel.setText(CUI_NEWCW_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.passwordLabel.setLayoutData((Object)gd);
            this.passwordText = new Text(baseComposite, 0x400804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.passwordText.setLayoutData((Object)gd);
            new Label(baseComposite, 0);
            this.savePasswordButton = new Button(baseComposite, 32);
            this.savePasswordButton.setText(CUI_NEWCW_SAVE_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            this.savePasswordButton.setLayoutData((Object)gd);
            this.catalogLabel = new Label(baseComposite, 0);
            this.catalogLabel.setText(CATALOG_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.catalogLabel.setLayoutData((Object)gd);
            this.catalogCombo = new Combo(baseComposite, 2060);
            this.catalogCombo.setEnabled(!isReadOnlyUI);
            this.catalogCombo.add(ALL_CATALOGS);
            this.catalogCombo.add(DBA_CATALOG);
            this.catalogCombo.add(USER_CATALOG);
            gd = new GridData();
            this.catalogCombo.setLayoutData((Object)gd);
            TabItem optionalPropsTab = new TabItem(tabComposite, 0);
            optionalPropsTab.setText(ConnectivityUIPlugin.getDefault().getResourceString("CommonDriverUIContributor.optionaltab"));
            this.optionalPropsComposite = this.createOptionalPropertiesPane((Composite)tabComposite, 0, this.isReadOnly);
            optionalPropsTab.setControl((Control)this.optionalPropsComposite);
            this.parentComposite.setContent((Control)tabComposite);
            this.parentComposite.setMinSize(tabComposite.computeSize(-1, -1));
            this.initialize();
        }
        return this.parentComposite;
    }

    private void initialize() {
        this.updateURL();
        this.addListeners();
    }

    private void addListeners() {
        this.serviceText.addListener(24, (Listener)this);
        this.sidText.addListener(24, (Listener)this);
        this.databaseText.addListener(24, (Listener)this);
        this.hostText.addListener(24, (Listener)this);
        this.portText.addListener(24, (Listener)this);
        this.usernameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
        this.savePasswordButton.addListener(13, (Listener)this);
        this.catalogCombo.addListener(24, (Listener)this);
        this.svcBtn.addListener(13, (Listener)this);
        this.sidBtn.addListener(13, (Listener)this);
    }

    private void removeListeners() {
        this.serviceText.removeListener(24, (Listener)this);
        this.sidText.removeListener(24, (Listener)this);
        this.databaseText.removeListener(24, (Listener)this);
        this.hostText.removeListener(24, (Listener)this);
        this.portText.removeListener(24, (Listener)this);
        this.usernameText.removeListener(24, (Listener)this);
        this.passwordText.removeListener(24, (Listener)this);
        this.savePasswordButton.removeListener(13, (Listener)this);
        this.catalogCombo.removeListener(24, (Listener)this);
        this.svcBtn.removeListener(13, (Listener)this);
        this.sidBtn.removeListener(13, (Listener)this);
    }

    protected void updateURL() {
        String url = this.getURLHandle(this.hostText.getText().trim(), this.portText.getText().trim(), this.databaseText.getText().trim()).formatURL();
        this.urlText.setText(url);
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>();
        summaryData.add(new String[]{CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_, this.databaseText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_, this.hostText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_, this.portText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_CATALOG_SUMMARY_DATA_TEXT_, this.catalogCombo.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_, this.usernameText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_, this.savePasswordButton.getSelection() ? CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ : CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{CUI_NEWCW_URL_SUMMARY_DATA_TEXT_, this.urlText.getText().trim()});
        return summaryData;
    }

    public void loadProperties() {
        String savePassword;
        String password;
        this.removeListeners();
        OracleJDBCURL url = this.getURLHandle(this.properties.getProperty("org.eclipse.datatools.connectivity.db.URL"));
        this.hostText.setText(url.getNode());
        this.portText.setText(url.getPort());
        this.databaseText.setText(url.getDatabaseName());
        this.isUsingService = url.isUrlUsingService();
        this.svcBtn.setSelection(this.isUsingService);
        this.sidBtn.setSelection(!this.isUsingService);
        this.serviceText.setText(this.isUsingService ? url.getDatabaseName() : "");
        this.sidText.setText(!this.isUsingService ? url.getDatabaseName() : "");
        String username = this.properties.getProperty("org.eclipse.datatools.connectivity.db.username");
        if (username != null) {
            this.usernameText.setText(username);
        }
        if ((password = this.properties.getProperty("org.eclipse.datatools.connectivity.db.password")) != null) {
            this.passwordText.setText(password);
        }
        if ((savePassword = this.properties.getProperty("org.eclipse.datatools.connectivity.db.savePWD")) != null && Boolean.valueOf(savePassword) == Boolean.TRUE) {
            this.savePasswordButton.setSelection(true);
        }
        String catalog = USER_CATALOG;
        String catalogSetting = this.properties.getProperty("org.eclipse.datatools.enablement.oracle.catalogType");
        if (catalogSetting != null && catalogSetting.equals("USER")) {
            catalog = USER_CATALOG;
        } else if (catalogSetting != null && catalogSetting.equals("DBA")) {
            catalog = DBA_CATALOG;
        } else if (catalogSetting != null && catalogSetting.equals("ALL")) {
            catalog = ALL_CATALOGS;
        }
        this.catalogCombo.select(this.catalogCombo.indexOf(catalog));
        this.optionalPropsComposite.loadProperties();
        this.updateURL();
        this.addListeners();
        this.setConnectionInformation();
    }

    public void setDialogPage(DialogPage parentPage) {
        this.parentPage = parentPage;
    }

    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.contributorInformation = contributorInformation;
        this.properties = contributorInformation.getProperties();
        this.optionalPropsComposite.setDriverUIContributorInformation(contributorInformation);
    }

    public void handleEvent(Event event) {
        if (this.isReadOnly) {
            if (event.widget == this.savePasswordButton) {
                this.savePasswordButton.setSelection(!this.savePasswordButton.getSelection());
            }
        } else {
            if (event.widget == this.svcBtn) {
                this.serviceText.setEnabled(true);
                this.databaseText.setText(this.serviceText.getText());
                this.sidText.setEnabled(false);
                this.isUsingService = true;
            } else if (event.widget == this.sidBtn) {
                this.serviceText.setEnabled(false);
                this.databaseText.setText(this.sidText.getText());
                this.sidText.setEnabled(true);
                this.isUsingService = false;
            } else if (event.widget == this.sidText) {
                this.databaseText.setText(this.sidText.getText());
            } else if (event.widget == this.serviceText) {
                this.databaseText.setText(this.serviceText.getText());
            }
            this.updateURL();
            this.setConnectionInformation();
        }
    }

    private void setConnectionInformation() {
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.databaseText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.password", this.passwordText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.savePasswordButton.getSelection()));
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.username", this.usernameText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.URL", this.urlText.getText().trim());
        String catalog = "USER";
        String catalogSetting = this.catalogCombo.getText();
        if (catalogSetting.equals(USER_CATALOG)) {
            catalog = "USER";
        } else if (catalogSetting.equals(DBA_CATALOG)) {
            catalog = "DBA";
        } else if (catalogSetting.equals(ALL_CATALOGS)) {
            catalog = "ALL";
        }
        this.properties.setProperty("org.eclipse.datatools.enablement.oracle.catalogType", catalog);
        this.optionalPropsComposite.setConnectionInformation();
        this.contributorInformation.setProperties(this.properties);
    }

    protected OptionalPropertiesPane createOptionalPropertiesPane(Composite parent, int style, boolean useReadOnlyControls) {
        return new OptionalPropertiesPane(parent, style, useReadOnlyControls);
    }

    protected OracleJDBCURL getURLHandle(String url) {
        return new OracleJDBCURL(url);
    }

    protected OracleJDBCURL getURLHandle(String node, String port, String sid) {
        return new OracleJDBCURL(node, port, sid);
    }

    protected boolean isDialogUsingService() {
        return this.isUsingService;
    }

    protected void setDialogUsingService(boolean isDialogUsingService) {
        this.isUsingService = isDialogUsingService;
    }

    protected class OracleJDBCURL {
        protected String subprotocol = "";
        protected String node = "";
        protected String port = "";
        protected String databaseName = "";
        protected String urlProperties = "";
        protected boolean isUrlUsingService = true;
        private static final String URL_SEPARATOR = ":";
        protected static final String URL_ATTRIBUTE_NAME_SERVICE = "ServiceName";
        protected static final String URL_ATTRIBUTE_NAME_SID = "SID";

        public OracleJDBCURL(String url) {
            this.parseURL(url);
        }

        public OracleJDBCURL(String node, String port, String databaseName) {
            this.node = node;
            this.port = port;
            this.databaseName = databaseName;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getNode() {
            return this.node;
        }

        public String getSubprotocol() {
            return this.subprotocol;
        }

        public String getPort() {
            return this.port;
        }

        public String getProperties() {
            return this.urlProperties;
        }

        protected String formatURL() {
            String url = "jdbc:oracle:thin:@" + this.getNode() + URL_SEPARATOR + this.getPort() + URL_SEPARATOR + this.getDatabaseName();
            return url;
        }

        protected void parseURL(String url) {
            try {
                String remainingURL = url.substring(url.indexOf(58) + 1);
                this.subprotocol = remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
                this.subprotocol = String.valueOf(this.subprotocol) + remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 2);
                this.node = remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
                this.port = remainingURL.substring(0, remainingURL.indexOf(58));
                this.databaseName = remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
            }
            catch (Exception exception) {}
        }

        protected boolean isUrlUsingService() {
            return this.isUrlUsingService;
        }

        protected void setUrlUsingService(boolean isUsingService) {
            this.isUrlUsingService = isUsingService;
        }

        protected void parseAttributes(String remainingURL) throws IOException {
            StringReader reader = new StringReader(remainingURL);
            Properties props = new Properties();
            props.load(reader);
            if (props.containsKey(URL_ATTRIBUTE_NAME_SERVICE)) {
                this.databaseName = props.getProperty(URL_ATTRIBUTE_NAME_SERVICE);
                props.remove(URL_ATTRIBUTE_NAME_SERVICE);
                this.setUrlUsingService(true);
            } else if (props.containsKey(URL_ATTRIBUTE_NAME_SID)) {
                this.databaseName = props.getProperty(URL_ATTRIBUTE_NAME_SID);
                props.remove(URL_ATTRIBUTE_NAME_SID);
                this.setUrlUsingService(false);
            }
            if (!props.isEmpty()) {
                this.urlProperties = props.toString();
            }
        }
    }
}

